/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.internal.registry.WorkingSetDescriptor;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;

public class WorkingSetRegistryReader
extends RegistryReader {
    private WorkingSetRegistry registry;

    public WorkingSetRegistryReader() {
    }

    public WorkingSetRegistryReader(WorkingSetRegistry workingSetRegistry) {
        this.registry = workingSetRegistry;
    }

    @Override
    public boolean readElement(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement.getName().equals("workingSet")) {
            try {
                WorkingSetDescriptor workingSetDescriptor = new WorkingSetDescriptor(iConfigurationElement);
                this.registry.addWorkingSetDescriptor(workingSetDescriptor);
            }
            catch (CoreException coreException) {
                WorkbenchPlugin.log("Unable to create working set descriptor.", coreException.getStatus());
            }
            return true;
        }
        return false;
    }

    public void readWorkingSets(IExtensionRegistry iExtensionRegistry, WorkingSetRegistry workingSetRegistry) {
        this.registry = workingSetRegistry;
        this.readRegistry(iExtensionRegistry, "org.eclipse.ui", "workingSets");
    }
}

