/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.internal.registry.WorkingSetDescriptor;
import org.eclipse.ui.internal.registry.WorkingSetRegistryReader;

public class WorkingSetRegistry
implements IExtensionChangeHandler {
    private static final String DEFAULT_PAGE_ID = "org.eclipse.ui.resourceWorkingSetPage";
    private HashMap workingSetDescriptors = new HashMap();

    public WorkingSetRegistry() {
        IExtensionTracker iExtensionTracker = PlatformUI.getWorkbench().getExtensionTracker();
        iExtensionTracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getExtensionPointFilter()));
    }

    private IExtensionPoint getExtensionPointFilter() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "workingSets");
    }

    public void addWorkingSetDescriptor(WorkingSetDescriptor workingSetDescriptor) {
        Assert.isTrue((!this.workingSetDescriptors.containsValue(workingSetDescriptor) ? 1 : 0) != 0, (String)"working set descriptor already registered");
        IExtensionTracker iExtensionTracker = PlatformUI.getWorkbench().getExtensionTracker();
        iExtensionTracker.registerObject(workingSetDescriptor.getConfigurationElement().getDeclaringExtension(), (Object)workingSetDescriptor, 2);
        this.workingSetDescriptors.put(workingSetDescriptor.getId(), workingSetDescriptor);
    }

    public IWorkingSetPage getDefaultWorkingSetPage() {
        WorkingSetDescriptor workingSetDescriptor = (WorkingSetDescriptor)this.workingSetDescriptors.get(DEFAULT_PAGE_ID);
        if (workingSetDescriptor != null) {
            return workingSetDescriptor.createWorkingSetPage();
        }
        return null;
    }

    public WorkingSetDescriptor getWorkingSetDescriptor(String string) {
        return (WorkingSetDescriptor)this.workingSetDescriptors.get(string);
    }

    public WorkingSetDescriptor[] getWorkingSetDescriptors() {
        return this.workingSetDescriptors.values().toArray(new WorkingSetDescriptor[this.workingSetDescriptors.size()]);
    }

    public WorkingSetDescriptor[] getNewPageWorkingSetDescriptors() {
        Collection collection = this.workingSetDescriptors.values();
        ArrayList<WorkingSetDescriptor> arrayList = new ArrayList<WorkingSetDescriptor>(collection.size());
        for (WorkingSetDescriptor workingSetDescriptor : collection) {
            if (workingSetDescriptor.getPageClassName() == null) continue;
            arrayList.add(workingSetDescriptor);
        }
        return arrayList.toArray(new WorkingSetDescriptor[arrayList.size()]);
    }

    public boolean hasNewPageWorkingSetDescriptor() {
        Collection collection = this.workingSetDescriptors.values();
        for (WorkingSetDescriptor workingSetDescriptor : collection) {
            if (workingSetDescriptor.getPageClassName() == null) continue;
            return true;
        }
        return false;
    }

    public WorkingSetDescriptor[] getUpdaterDescriptorsForNamespace(String string) {
        if (string == null) {
            return new WorkingSetDescriptor[0];
        }
        Collection collection = this.workingSetDescriptors.values();
        ArrayList<WorkingSetDescriptor> arrayList = new ArrayList<WorkingSetDescriptor>();
        for (WorkingSetDescriptor workingSetDescriptor : collection) {
            if (!string.equals(workingSetDescriptor.getUpdaterNamespace())) continue;
            arrayList.add(workingSetDescriptor);
        }
        return arrayList.toArray(new WorkingSetDescriptor[arrayList.size()]);
    }

    public WorkingSetDescriptor[] getElementAdapterDescriptorsForNamespace(String string) {
        if (string == null) {
            return new WorkingSetDescriptor[0];
        }
        Collection collection = this.workingSetDescriptors.values();
        ArrayList<WorkingSetDescriptor> arrayList = new ArrayList<WorkingSetDescriptor>();
        for (WorkingSetDescriptor workingSetDescriptor : collection) {
            if (!string.equals(workingSetDescriptor.getDeclaringNamespace())) continue;
            arrayList.add(workingSetDescriptor);
        }
        return arrayList.toArray(new WorkingSetDescriptor[arrayList.size()]);
    }

    public IWorkingSetPage getWorkingSetPage(String string) {
        WorkingSetDescriptor workingSetDescriptor = (WorkingSetDescriptor)this.workingSetDescriptors.get(string);
        if (workingSetDescriptor == null) {
            return null;
        }
        return workingSetDescriptor.createWorkingSetPage();
    }

    public void load() {
        WorkingSetRegistryReader workingSetRegistryReader = new WorkingSetRegistryReader();
        workingSetRegistryReader.readWorkingSets(Platform.getExtensionRegistry(), this);
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        WorkingSetRegistryReader workingSetRegistryReader = new WorkingSetRegistryReader(this);
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            workingSetRegistryReader.readElement(iConfigurationElementArray[n]);
            ++n;
        }
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof WorkingSetDescriptor) {
                WorkingSetDescriptor workingSetDescriptor = (WorkingSetDescriptor)objectArray[n];
                this.workingSetDescriptors.remove(workingSetDescriptor.getId());
            }
            ++n;
        }
    }
}

