/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkingSetElementAdapter;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class WorkingSetDescriptor
implements IPluginContribution {
    private String id;
    private String name;
    private String icon;
    private String pageClassName;
    private String updaterClassName;
    private IConfigurationElement configElement;
    private String[] classTypes;
    private String[] adapterTypes;
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_ICON = "icon";
    private static final String ATT_PAGE_CLASS = "pageClass";
    private static final String ATT_UPDATER_CLASS = "updaterClass";
    private static final String ATT_ELEMENT_ADAPTER_CLASS = "elementAdapterClass";
    private static final String TAG_APPLICABLE_TYPE = "applicableType";

    public WorkingSetDescriptor(IConfigurationElement iConfigurationElement) throws CoreException {
        this.configElement = iConfigurationElement;
        this.id = iConfigurationElement.getAttribute(ATT_ID);
        this.name = iConfigurationElement.getAttribute(ATT_NAME);
        this.icon = iConfigurationElement.getAttribute(ATT_ICON);
        this.pageClassName = iConfigurationElement.getAttribute(ATT_PAGE_CLASS);
        this.updaterClassName = iConfigurationElement.getAttribute(ATT_UPDATER_CLASS);
        if (this.name == null) {
            throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, "Invalid extension (missing class name): " + this.id, null));
        }
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren(TAG_APPLICABLE_TYPE);
        if (iConfigurationElementArray.length > 0) {
            ArrayList<String> arrayList = new ArrayList<String>(iConfigurationElementArray.length);
            ArrayList<String> arrayList2 = new ArrayList<String>(iConfigurationElementArray.length);
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n];
                String string = iConfigurationElement2.getAttribute("class");
                if (string != null) {
                    arrayList.add(string);
                }
                if ("true".equals(iConfigurationElement2.getAttribute("adaptable"))) {
                    arrayList2.add(string);
                }
                ++n;
            }
            if (!arrayList.isEmpty()) {
                this.classTypes = arrayList.toArray(new String[arrayList.size()]);
                Arrays.sort(this.classTypes);
            }
            if (!arrayList2.isEmpty()) {
                this.adapterTypes = arrayList2.toArray(new String[arrayList2.size()]);
                Arrays.sort(this.adapterTypes);
            }
        }
    }

    public String getDeclaringNamespace() {
        return this.configElement.getNamespace();
    }

    public String getUpdaterNamespace() {
        return WorkbenchPlugin.getBundleForExecutableExtension(this.configElement, ATT_UPDATER_CLASS).getSymbolicName();
    }

    public String getElementAdapterNamespace() {
        return WorkbenchPlugin.getBundleForExecutableExtension(this.configElement, ATT_UPDATER_CLASS).getSymbolicName();
    }

    public IWorkingSetPage createWorkingSetPage() {
        Object object = null;
        if (this.pageClassName != null) {
            try {
                object = WorkbenchPlugin.createExtension(this.configElement, ATT_PAGE_CLASS);
            }
            catch (CoreException coreException) {
                WorkbenchPlugin.log("Unable to create working set page: " + this.pageClassName, coreException.getStatus());
            }
        }
        return (IWorkingSetPage)object;
    }

    public ImageDescriptor getIcon() {
        if (this.icon == null) {
            return null;
        }
        IExtension iExtension = this.configElement.getDeclaringExtension();
        String string = iExtension.getNamespace();
        return AbstractUIPlugin.imageDescriptorFromPlugin(string, this.icon);
    }

    public String getId() {
        return this.id;
    }

    public String getPageClassName() {
        return this.pageClassName;
    }

    public String getName() {
        return this.name;
    }

    public String getUpdaterClassName() {
        return this.updaterClassName;
    }

    public IWorkingSetElementAdapter createWorkingSetElementAdapter() {
        if (!WorkbenchPlugin.hasExecutableExtension(this.configElement, ATT_ELEMENT_ADAPTER_CLASS)) {
            return null;
        }
        IWorkingSetElementAdapter iWorkingSetElementAdapter = null;
        try {
            iWorkingSetElementAdapter = (IWorkingSetElementAdapter)WorkbenchPlugin.createExtension(this.configElement, ATT_ELEMENT_ADAPTER_CLASS);
        }
        catch (CoreException coreException) {
            WorkbenchPlugin.log("Unable to create working set element adapter: " + iWorkingSetElementAdapter, coreException.getStatus());
        }
        return iWorkingSetElementAdapter;
    }

    public IWorkingSetUpdater createWorkingSetUpdater() {
        if (this.updaterClassName == null) {
            return null;
        }
        IWorkingSetUpdater iWorkingSetUpdater = null;
        try {
            iWorkingSetUpdater = (IWorkingSetUpdater)WorkbenchPlugin.createExtension(this.configElement, ATT_UPDATER_CLASS);
        }
        catch (CoreException coreException) {
            WorkbenchPlugin.log("Unable to create working set updater: " + this.updaterClassName, coreException.getStatus());
        }
        return iWorkingSetUpdater;
    }

    public boolean isUpdaterClassLoaded() {
        return WorkbenchPlugin.isBundleLoadedForExecutableExtension(this.configElement, ATT_UPDATER_CLASS);
    }

    public boolean isElementAdapterClassLoaded() {
        return WorkbenchPlugin.isBundleLoadedForExecutableExtension(this.configElement, ATT_ELEMENT_ADAPTER_CLASS);
    }

    public boolean isEditable() {
        return this.getPageClassName() != null;
    }

    @Override
    public String getLocalId() {
        return this.getId();
    }

    @Override
    public String getPluginId() {
        return this.getDeclaringNamespace();
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    public String getDescription() {
        String string = this.configElement.getAttribute("description");
        if (string == null) {
            string = "";
        }
        return string;
    }
}

