/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.registry.Category;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.internal.util.Util;

public class WizardsRegistryReader
extends RegistryReader {
    private String pluginPoint;
    private WizardCollectionElement wizardElements = null;
    private ArrayList deferWizards = null;
    private ArrayList deferCategories = null;
    private Set deferPrimary;
    public static final String FULL_EXAMPLES_WIZARD_CATEGORY = "org.eclipse.ui.Examples";
    public static final String UNCATEGORIZED_WIZARD_CATEGORY = "org.eclipse.ui.Other";
    public static final String GENERAL_WIZARD_CATEGORY = "org.eclipse.ui.Basic";
    private static final String UNCATEGORIZED_WIZARD_CATEGORY_LABEL = WorkbenchMessages.NewWizardsRegistryReader_otherCategory;
    private static final String CATEGORY_SEPARATOR = "/";
    private WorkbenchWizardElement[] primaryWizards = new WorkbenchWizardElement[0];
    private static final Comparator comparer = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object object, Object object2) {
            String string = ((CategoryNode)object).getPath();
            String string2 = ((CategoryNode)object2).getPath();
            return this.collator.compare(string, string2);
        }
    };
    private boolean readAll = true;
    private String plugin;

    public WizardsRegistryReader(String string, String string2) {
        this.pluginPoint = string2;
        this.plugin = string;
    }

    protected void addNewElementToResult(WorkbenchWizardElement workbenchWizardElement, IConfigurationElement iConfigurationElement) {
        this.deferWizard(workbenchWizardElement);
    }

    private WizardCollectionElement createCollectionElement(WizardCollectionElement wizardCollectionElement, IConfigurationElement iConfigurationElement) {
        WizardCollectionElement wizardCollectionElement2 = new WizardCollectionElement(iConfigurationElement, wizardCollectionElement);
        wizardCollectionElement.add(wizardCollectionElement2);
        return wizardCollectionElement2;
    }

    protected WizardCollectionElement createCollectionElement(WizardCollectionElement wizardCollectionElement, String string, String string2, String string3) {
        WizardCollectionElement wizardCollectionElement2 = new WizardCollectionElement(string, string2, string3, wizardCollectionElement);
        wizardCollectionElement.add(wizardCollectionElement2);
        return wizardCollectionElement2;
    }

    protected void createEmptyWizardCollection() {
        this.wizardElements = new WizardCollectionElement("root", null, "root", null);
    }

    public void setInitialCollection(WizardCollectionElement wizardCollectionElement) {
        this.wizardElements = wizardCollectionElement;
        this.readAll = false;
    }

    private void deferCategory(IConfigurationElement iConfigurationElement) {
        Category category = null;
        try {
            category = new Category(iConfigurationElement);
        }
        catch (CoreException coreException) {
            WorkbenchPlugin.log("Cannot create category: ", coreException.getStatus());
            return;
        }
        if (this.deferCategories == null) {
            this.deferCategories = new ArrayList(20);
        }
        this.deferCategories.add(category);
    }

    private void deferWizard(WorkbenchWizardElement workbenchWizardElement) {
        if (this.deferWizards == null) {
            this.deferWizards = new ArrayList(50);
        }
        this.deferWizards.add(workbenchWizardElement);
    }

    private void finishCategories() {
        if (this.deferCategories == null) {
            return;
        }
        CategoryNode[] categoryNodeArray = new CategoryNode[this.deferCategories.size()];
        int n = 0;
        while (n < this.deferCategories.size()) {
            categoryNodeArray[n] = new CategoryNode((Category)this.deferCategories.get(n));
            ++n;
        }
        Collections.sort(Arrays.asList(categoryNodeArray), comparer);
        n = 0;
        while (n < categoryNodeArray.length) {
            Category category = categoryNodeArray[n].getCategory();
            this.finishCategory(category);
            ++n;
        }
        this.deferCategories = null;
    }

    private void finishCategory(Category category) {
        WizardCollectionElement wizardCollectionElement;
        String[] stringArray = category.getParentPath();
        WizardCollectionElement wizardCollectionElement2 = this.wizardElements;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                WizardCollectionElement wizardCollectionElement3 = this.getChildWithID(wizardCollectionElement2, stringArray[n]);
                if (wizardCollectionElement3 == null) {
                    return;
                }
                wizardCollectionElement2 = wizardCollectionElement3;
                ++n;
            }
        }
        if ((wizardCollectionElement = this.getChildWithID(wizardCollectionElement2, category.getId())) != null) {
            return;
        }
        if (wizardCollectionElement2 != null) {
            this.createCollectionElement(wizardCollectionElement2, (IConfigurationElement)Util.getAdapter(category, IConfigurationElement.class));
        }
    }

    private void finishPrimary() {
        if (this.deferPrimary != null) {
            ArrayList<WorkbenchWizardElement> arrayList = new ArrayList<WorkbenchWizardElement>();
            for (String string : this.deferPrimary) {
                WorkbenchWizardElement workbenchWizardElement;
                WorkbenchWizardElement workbenchWizardElement2 = workbenchWizardElement = this.wizardElements == null ? null : this.wizardElements.findWizard(string, true);
                if (workbenchWizardElement == null) continue;
                arrayList.add(workbenchWizardElement);
            }
            this.primaryWizards = arrayList.toArray(new WorkbenchWizardElement[arrayList.size()]);
            this.deferPrimary = null;
        }
    }

    private void finishWizard(WorkbenchWizardElement workbenchWizardElement, IConfigurationElement iConfigurationElement) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getCategoryStringFor(iConfigurationElement), CATEGORY_SEPARATOR);
        WizardCollectionElement wizardCollectionElement = this.wizardElements;
        boolean bl = false;
        while (stringTokenizer.hasMoreElements()) {
            WizardCollectionElement wizardCollectionElement2 = this.getChildWithID(wizardCollectionElement, stringTokenizer.nextToken());
            if (wizardCollectionElement2 == null) {
                bl = true;
                break;
            }
            wizardCollectionElement = wizardCollectionElement2;
        }
        if (bl) {
            this.moveElementToUncategorizedCategory(this.wizardElements, workbenchWizardElement);
        } else {
            wizardCollectionElement.add(workbenchWizardElement);
            workbenchWizardElement.setParent(wizardCollectionElement);
        }
    }

    private void finishWizards() {
        if (this.deferWizards != null) {
            for (WorkbenchWizardElement workbenchWizardElement : this.deferWizards) {
                IConfigurationElement iConfigurationElement = workbenchWizardElement.getConfigurationElement();
                this.finishWizard(workbenchWizardElement, iConfigurationElement);
            }
            this.deferWizards = null;
        }
    }

    protected String getCategoryStringFor(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("category");
        if (string == null) {
            string = UNCATEGORIZED_WIZARD_CATEGORY;
        }
        return string;
    }

    protected WizardCollectionElement getChildWithID(WizardCollectionElement wizardCollectionElement, String string) {
        Object[] objectArray = wizardCollectionElement.getChildren(null);
        int n = 0;
        while (n < objectArray.length) {
            WizardCollectionElement wizardCollectionElement2 = (WizardCollectionElement)objectArray[n];
            if (wizardCollectionElement2.getId().equals(string)) {
                return wizardCollectionElement2;
            }
            ++n;
        }
        return null;
    }

    protected void moveElementToUncategorizedCategory(WizardCollectionElement wizardCollectionElement, WorkbenchWizardElement workbenchWizardElement) {
        WizardCollectionElement wizardCollectionElement2 = this.getChildWithID(wizardCollectionElement, UNCATEGORIZED_WIZARD_CATEGORY);
        if (wizardCollectionElement2 == null) {
            wizardCollectionElement2 = this.createCollectionElement(wizardCollectionElement, UNCATEGORIZED_WIZARD_CATEGORY, null, UNCATEGORIZED_WIZARD_CATEGORY_LABEL);
        }
        wizardCollectionElement2.add(workbenchWizardElement);
        workbenchWizardElement.setParent(wizardCollectionElement2);
    }

    private void pruneEmptyCategories(WizardCollectionElement wizardCollectionElement) {
        Object[] objectArray = wizardCollectionElement.getChildren(null);
        int n = 0;
        while (n < objectArray.length) {
            WizardCollectionElement wizardCollectionElement2 = (WizardCollectionElement)objectArray[n];
            this.pruneEmptyCategories(wizardCollectionElement2);
            boolean bl = wizardCollectionElement2.getId().equals(FULL_EXAMPLES_WIZARD_CATEGORY);
            if (wizardCollectionElement2.isEmpty() && bl) {
                wizardCollectionElement.remove(wizardCollectionElement2);
            }
            ++n;
        }
    }

    @Override
    public boolean readElement(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement.getName().equals("category")) {
            this.deferCategory(iConfigurationElement);
            return true;
        }
        if (iConfigurationElement.getName().equals("primaryWizard")) {
            if (this.deferPrimary == null) {
                this.deferPrimary = new HashSet();
            }
            this.deferPrimary.add(iConfigurationElement.getAttribute("id"));
            return true;
        }
        if (!iConfigurationElement.getName().equals("wizard")) {
            return false;
        }
        WorkbenchWizardElement workbenchWizardElement = this.createWizardElement(iConfigurationElement);
        if (workbenchWizardElement != null) {
            this.addNewElementToResult(workbenchWizardElement, iConfigurationElement);
        }
        return true;
    }

    protected void readWizards() {
        if (this.readAll && !this.areWizardsRead()) {
            this.createEmptyWizardCollection();
            IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
            this.readRegistry(iExtensionRegistry, this.plugin, this.pluginPoint);
        }
        this.finishCategories();
        this.finishWizards();
        this.finishPrimary();
        if (this.wizardElements != null) {
            this.pruneEmptyCategories(this.wizardElements);
        }
    }

    public WorkbenchWizardElement[] getPrimaryWizards() {
        if (!this.areWizardsRead()) {
            this.readWizards();
        }
        return (WorkbenchWizardElement[])WorkbenchActivityHelper.restrictArray(this.primaryWizards);
    }

    protected boolean areWizardsRead() {
        return this.wizardElements != null && this.readAll;
    }

    public WizardCollectionElement getWizardElements() {
        if (!this.areWizardsRead()) {
            this.readWizards();
        }
        return this.wizardElements;
    }

    protected Object[] getWizardCollectionElements() {
        if (!this.areWizardsRead()) {
            this.readWizards();
        }
        return this.wizardElements.getChildren();
    }

    protected WorkbenchWizardElement createWizardElement(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement.getAttribute("name") == null) {
            WizardsRegistryReader.logMissingAttribute(iConfigurationElement, "name");
            return null;
        }
        if (WizardsRegistryReader.getClassValue(iConfigurationElement, "class") == null) {
            WizardsRegistryReader.logMissingAttribute(iConfigurationElement, "class");
            return null;
        }
        return new WorkbenchWizardElement(iConfigurationElement);
    }

    public WorkbenchWizardElement findWizard(String string) {
        Object[] objectArray = this.getWizardCollectionElements();
        int n = 0;
        while (n < objectArray.length) {
            WizardCollectionElement wizardCollectionElement = (WizardCollectionElement)objectArray[n];
            WorkbenchWizardElement workbenchWizardElement = wizardCollectionElement.findWizard(string, true);
            if (workbenchWizardElement != null && !WorkbenchActivityHelper.restrictUseOf(workbenchWizardElement)) {
                return workbenchWizardElement;
            }
            ++n;
        }
        return null;
    }

    private class CategoryNode {
        private Category category;
        private String path;

        CategoryNode(Category category) {
            this.category = category;
            this.path = "";
            String[] stringArray = this.category.getParentPath();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    this.path = String.valueOf(this.path) + stringArray[n] + '/';
                    ++n;
                }
            }
            this.path = String.valueOf(this.path) + category.getId();
        }

        String getPath() {
            return this.path;
        }

        Category getCategory() {
            return this.category;
        }
    }
}

