/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.Category;
import org.eclipse.ui.internal.registry.StickyViewDescriptor;
import org.eclipse.ui.internal.registry.ViewDescriptor;
import org.eclipse.ui.internal.registry.ViewRegistryReader;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.views.IStickyViewDescriptor;
import org.eclipse.ui.views.IViewCategory;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ViewRegistry
implements IViewRegistry,
IExtensionChangeHandler {
    private static String EXTENSIONPOINT_UNIQUE_ID = String.valueOf(WorkbenchPlugin.PI_WORKBENCH) + "." + "views";
    private SortedSet views = new TreeSet(new ViewDescriptorComparator());
    private List categories;
    private List sticky;
    private Category miscCategory;
    protected static final String TAG_DESCRIPTION = "description";
    private ViewRegistryReader reader = new ViewRegistryReader();
    private boolean dirtyViewCategoryMappings = true;

    public ViewRegistry() {
        this.categories = new ArrayList();
        this.sticky = new ArrayList();
        PlatformUI.getWorkbench().getExtensionTracker().registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getExtensionPointFilter()));
        this.reader.readViews(Platform.getExtensionRegistry(), this);
    }

    public void add(Category category) {
        if (this.internalFindCategory(category.getId()) == null) {
            this.dirtyViewCategoryMappings = true;
            this.categories.add(category);
            IConfigurationElement iConfigurationElement = (IConfigurationElement)Util.getAdapter(category, IConfigurationElement.class);
            if (iConfigurationElement == null) {
                return;
            }
            PlatformUI.getWorkbench().getExtensionTracker().registerObject(iConfigurationElement.getDeclaringExtension(), (Object)category, 2);
        }
    }

    public void add(ViewDescriptor viewDescriptor) {
        if (this.views.add(viewDescriptor)) {
            this.dirtyViewCategoryMappings = true;
            PlatformUI.getWorkbench().getExtensionTracker().registerObject(viewDescriptor.getConfigurationElement().getDeclaringExtension(), (Object)viewDescriptor, 2);
        }
    }

    public void add(StickyViewDescriptor stickyViewDescriptor) {
        if (!this.sticky.contains(stickyViewDescriptor)) {
            this.sticky.add(stickyViewDescriptor);
            PlatformUI.getWorkbench().getExtensionTracker().registerObject(stickyViewDescriptor.getConfigurationElement().getDeclaringExtension(), (Object)stickyViewDescriptor, 2);
        }
    }

    @Override
    public IViewDescriptor find(String string) {
        IViewDescriptor iViewDescriptor = this.findInternal(string);
        if (WorkbenchActivityHelper.restrictUseOf(iViewDescriptor)) {
            return null;
        }
        return iViewDescriptor;
    }

    public IViewDescriptor findInternal(String string) {
        for (IViewDescriptor iViewDescriptor : this.views) {
            if (!string.equals(iViewDescriptor.getId())) continue;
            return iViewDescriptor;
        }
        return null;
    }

    public IViewCategory findCategory(String string) {
        this.mapViewsToCategories();
        Category category = this.internalFindCategory(string);
        if (category == null) {
            return null;
        }
        return new ViewCategoryProxy(category);
    }

    private Category internalFindCategory(String string) {
        for (Category category : this.categories) {
            if (!string.equals(category.getRootPath())) continue;
            return category;
        }
        return null;
    }

    @Override
    public IViewCategory[] getCategories() {
        this.mapViewsToCategories();
        int n = this.categories.size();
        IViewCategory[] iViewCategoryArray = new IViewCategory[n];
        int n2 = 0;
        Iterator iterator = this.categories.iterator();
        while (iterator.hasNext()) {
            iViewCategoryArray[n2++] = new ViewCategoryProxy((Category)iterator.next());
        }
        return iViewCategoryArray;
    }

    @Override
    public IStickyViewDescriptor[] getStickyViews() {
        Collection collection = WorkbenchActivityHelper.restrictCollection(this.sticky, new ArrayList());
        return collection.toArray(new IStickyViewDescriptor[collection.size()]);
    }

    public Category getMiscCategory() {
        return this.miscCategory;
    }

    @Override
    public IViewDescriptor[] getViews() {
        Collection collection = WorkbenchActivityHelper.restrictCollection(this.views, new TreeSet(new ViewDescriptorComparator()));
        return collection.toArray(new IViewDescriptor[collection.size()]);
    }

    public void mapViewsToCategories() {
        if (this.dirtyViewCategoryMappings) {
            this.dirtyViewCategoryMappings = false;
            for (IAdaptable iAdaptable : this.categories) {
                iAdaptable.clear();
            }
            if (this.miscCategory != null) {
                this.miscCategory.clear();
            }
            for (IAdaptable iAdaptable : this.views) {
                String string;
                Category category = null;
                String[] stringArray = iAdaptable.getCategoryPath();
                if (stringArray != null) {
                    string = stringArray[0];
                    category = this.internalFindCategory(string);
                }
                if (category != null) {
                    if (category.hasElement(iAdaptable)) continue;
                    category.addElement(iAdaptable);
                    continue;
                }
                if (this.miscCategory == null) {
                    this.miscCategory = new Category();
                    this.add(this.miscCategory);
                }
                if (stringArray != null) {
                    string = "Category {0} not found for view {1}.  This view added to ''{2}'' category.";
                    WorkbenchPlugin.log(MessageFormat.format((String)string, (Object[])new Object[]{stringArray[0], iAdaptable.getId(), this.miscCategory.getLabel()}));
                }
                this.miscCategory.addElement(iAdaptable);
            }
        }
    }

    public void dispose() {
        PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler((IExtensionChangeHandler)this);
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof StickyViewDescriptor) {
                this.sticky.remove(objectArray[n]);
            } else if (objectArray[n] instanceof ViewDescriptor) {
                this.views.remove(objectArray[n]);
                this.dirtyViewCategoryMappings = true;
            } else if (objectArray[n] instanceof Category) {
                this.categories.remove(objectArray[n]);
                this.dirtyViewCategoryMappings = true;
            }
            ++n;
        }
    }

    private IExtensionPoint getExtensionPointFilter() {
        return Platform.getExtensionRegistry().getExtensionPoint(EXTENSIONPOINT_UNIQUE_ID);
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.getName().equals("view")) {
                this.reader.readView(iConfigurationElement);
            } else if (iConfigurationElement.getName().equals("category")) {
                this.reader.readCategory(iConfigurationElement);
            } else if (iConfigurationElement.getName().equals("stickyView")) {
                this.reader.readSticky(iConfigurationElement);
            }
            ++n;
        }
    }

    private static class ViewCategoryProxy
    implements IViewCategory,
    IPluginContribution {
        private Category rawCategory;

        public ViewCategoryProxy(Category category) {
            this.rawCategory = category;
        }

        @Override
        public IViewDescriptor[] getViews() {
            ArrayList arrayList = this.rawCategory.getElements();
            if (arrayList == null) {
                return new IViewDescriptor[0];
            }
            Collection collection = WorkbenchActivityHelper.restrictCollection(arrayList, new ArrayList());
            return collection.toArray(new IViewDescriptor[collection.size()]);
        }

        @Override
        public String getId() {
            return this.rawCategory.getId();
        }

        @Override
        public IPath getPath() {
            String string = this.rawCategory.getRawParentPath();
            if (string == null) {
                return new Path("");
            }
            return new Path(string);
        }

        @Override
        public String getLabel() {
            return this.rawCategory.getLabel();
        }

        @Override
        public String getLocalId() {
            return this.getId();
        }

        @Override
        public String getPluginId() {
            return this.rawCategory.getPluginId();
        }

        public boolean equals(Object object) {
            if (object instanceof IViewCategory) {
                return this.getId().equals(((IViewCategory)object).getId());
            }
            return false;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }
    }

    private static final class ViewDescriptorComparator
    implements Comparator {
        private ViewDescriptorComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = ((ViewDescriptor)object).getId();
            String string2 = ((ViewDescriptor)object2).getId();
            return string.compareTo(string2);
        }
    }
}

