/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.internal.tweaklets.InterceptContributions;
import org.eclipse.ui.internal.tweaklets.Tweaklets;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.IViewDescriptor;

public class ViewDescriptor
implements IViewDescriptor,
IPluginContribution {
    private String id;
    private ImageDescriptor imageDescriptor;
    private IConfigurationElement configElement;
    private String[] categoryPath;
    private float fastViewWidthRatio;

    public ViewDescriptor(IConfigurationElement iConfigurationElement) throws CoreException {
        this.configElement = iConfigurationElement;
        this.loadFromExtension();
    }

    @Override
    public IViewPart createView() throws CoreException {
        Object object = WorkbenchPlugin.createExtension(this.getConfigurationElement(), "class");
        return ((InterceptContributions)Tweaklets.get(InterceptContributions.KEY)).tweakView(object);
    }

    @Override
    public String[] getCategoryPath() {
        return this.categoryPath;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    @Override
    public String getDescription() {
        return RegistryReader.getDescription(this.configElement);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor != null) {
            return this.imageDescriptor;
        }
        String string = this.configElement.getAttribute("icon");
        if (string == null) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEF_VIEW");
        }
        IExtension iExtension = this.configElement.getDeclaringExtension();
        String string2 = iExtension.getNamespace();
        this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(string2, string);
        if (this.imageDescriptor == null) {
            this.imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        return this.imageDescriptor;
    }

    @Override
    public String getLabel() {
        return this.configElement.getAttribute("name");
    }

    public String getAccelerator() {
        return this.configElement.getAttribute("accelerator");
    }

    @Override
    public float getFastViewWidthRatio() {
        this.configElement.getAttribute("fastViewWidthRatio");
        return this.fastViewWidthRatio;
    }

    private void loadFromExtension() throws CoreException {
        Object object;
        this.id = this.configElement.getAttribute("id");
        String string = this.configElement.getAttribute("category");
        if (this.configElement.getAttribute("name") == null || RegistryReader.getClassValue(this.configElement, "class") == null) {
            throw new CoreException((IStatus)new Status(4, this.configElement.getNamespace(), 0, "Invalid extension (missing label or class name): " + this.id, null));
        }
        if (string != null) {
            object = new StringTokenizer(string, "/");
            this.categoryPath = new String[((StringTokenizer)object).countTokens()];
            int n = 0;
            while (((StringTokenizer)object).hasMoreTokens()) {
                this.categoryPath[n] = ((StringTokenizer)object).nextToken();
                ++n;
            }
        }
        if ((object = this.configElement.getAttribute("fastViewWidthRatio")) != null) {
            try {
                this.fastViewWidthRatio = new Float((String)object).floatValue();
                if (this.fastViewWidthRatio > 0.95f) {
                    this.fastViewWidthRatio = 0.95f;
                }
                if (this.fastViewWidthRatio < 0.05f) {
                    this.fastViewWidthRatio = 0.05f;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.fastViewWidthRatio = 0.3f;
            }
        } else {
            this.fastViewWidthRatio = 0.3f;
        }
    }

    public String toString() {
        return "View(" + this.getId() + ")";
    }

    @Override
    public String getPluginId() {
        String string = this.configElement.getNamespace();
        return string == null ? "" : string;
    }

    @Override
    public String getLocalId() {
        return this.getId() == null ? "" : this.getId();
    }

    @Override
    public boolean getAllowMultiple() {
        String string = this.configElement.getAttribute("allowMultiple");
        return string == null ? false : Boolean.valueOf(string);
    }

    @Override
    public boolean isRestorable() {
        String string = this.configElement.getAttribute("restorable");
        return string == null ? true : Boolean.valueOf(string);
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(IConfigurationElement.class)) {
            return this.getConfigurationElement();
        }
        return null;
    }
}

