/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.views.IStickyViewDescriptor;

public class StickyViewDescriptor
implements IStickyViewDescriptor,
IPluginContribution {
    private IConfigurationElement configurationElement;
    private String id;
    public static final String STICKY_FOLDER_RIGHT = "stickyFolderRight";
    public static final String STICKY_FOLDER_LEFT = "stickyFolderLeft";
    public static final String STICKY_FOLDER_TOP = "stickyFolderTop";
    public static final String STICKY_FOLDER_BOTTOM = "stickyFolderBottom";

    public StickyViewDescriptor(IConfigurationElement iConfigurationElement) throws CoreException {
        this.configurationElement = iConfigurationElement;
        this.id = this.configurationElement.getAttribute("id");
        if (this.id == null) {
            throw new CoreException((IStatus)new Status(4, iConfigurationElement.getNamespace(), 0, "Invalid extension (missing id) ", null));
        }
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    @Override
    public int getLocation() {
        int n = 2;
        String string = this.configurationElement.getAttribute("location");
        if (string != null) {
            if (string.equalsIgnoreCase("left")) {
                n = 1;
            } else if (string.equalsIgnoreCase("top")) {
                n = 3;
            } else if (string.equalsIgnoreCase("bottom")) {
                n = 4;
            }
        }
        return n;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLocalId() {
        return this.id;
    }

    @Override
    public String getPluginId() {
        return this.configurationElement.getContributor().getName();
    }

    @Override
    public boolean isCloseable() {
        boolean bl = true;
        String string = this.configurationElement.getAttribute("closeable");
        if (string != null) {
            bl = !string.equals("false");
        }
        return bl;
    }

    @Override
    public boolean isMoveable() {
        boolean bl = true;
        String string = this.configurationElement.getAttribute("moveable");
        if (string != null) {
            bl = !string.equals("false");
        }
        return bl;
    }
}

