/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.RegistryPageContributor;
import org.eclipse.ui.internal.registry.CategorizedPageRegistryReader;

public class PropertyPagesRegistryReader
extends CategorizedPageRegistryReader {
    public static final String ATT_NAME_FILTER = "nameFilter";
    public static final String ATT_FILTER_NAME = "name";
    public static final String ATT_FILTER_VALUE = "value";
    public static final String ATT_SELECTION_FILTER = "selectionFilter";
    public static final String ATT_SELECTION_FILTER_MULTI = "multi";
    private static final String TAG_PAGE = "page";
    public static final String TAG_FILTER = "filter";
    public static final String TAG_KEYWORD_REFERENCE = "keywordReference";
    public static final String ATT_OBJECTCLASS = "objectClass";
    public static final String ATT_ADAPTABLE = "adaptable";
    private static final String CHILD_ENABLED_WHEN = "enabledWhen";
    private Collection pages = new ArrayList();
    private PropertyPageContributorManager manager;

    public PropertyPagesRegistryReader(PropertyPageContributorManager propertyPageContributorManager) {
        this.manager = propertyPageContributorManager;
    }

    private void processPageElement(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("id");
        if (string == null) {
            PropertyPagesRegistryReader.logMissingAttribute(iConfigurationElement, "id");
            return;
        }
        RegistryPageContributor registryPageContributor = new RegistryPageContributor(string, iConfigurationElement);
        String string2 = PropertyPagesRegistryReader.getClassValue(iConfigurationElement, "class");
        if (string2 == null) {
            PropertyPagesRegistryReader.logMissingAttribute(iConfigurationElement, "class");
            return;
        }
        if (iConfigurationElement.getAttribute(ATT_OBJECTCLASS) == null) {
            this.pages.add(registryPageContributor);
            this.manager.registerContributor(registryPageContributor, Object.class.getName());
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(iConfigurationElement.getAttribute(ATT_OBJECTCLASS));
            this.registerContributors(registryPageContributor, arrayList);
        }
    }

    private void registerContributors(RegistryPageContributor registryPageContributor, List list) {
        this.pages.add(registryPageContributor);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.manager.registerContributor(registryPageContributor, (String)iterator.next());
        }
    }

    @Override
    public boolean readElement(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement.getName().equals(TAG_PAGE)) {
            this.processPageElement(iConfigurationElement);
            this.readElementChildren(iConfigurationElement);
            return true;
        }
        if (iConfigurationElement.getName().equals(TAG_FILTER)) {
            return true;
        }
        if (iConfigurationElement.getName().equals(CHILD_ENABLED_WHEN)) {
            return true;
        }
        return iConfigurationElement.getName().equals(TAG_KEYWORD_REFERENCE);
    }

    public void registerPropertyPages(IExtensionRegistry iExtensionRegistry) {
        this.readRegistry(iExtensionRegistry, "org.eclipse.ui", "propertyPages");
        this.processNodes();
    }

    @Override
    void add(Object object, Object object2) {
        ((RegistryPageContributor)object).addSubPage((RegistryPageContributor)object2);
    }

    @Override
    CategorizedPageRegistryReader.CategoryNode createCategoryNode(CategorizedPageRegistryReader categorizedPageRegistryReader, Object object) {
        return new PropertyCategoryNode(categorizedPageRegistryReader, (RegistryPageContributor)object);
    }

    @Override
    Object findNode(Object object, String string) {
        return ((RegistryPageContributor)object).getChild(string);
    }

    @Override
    Object findNode(String string) {
        for (RegistryPageContributor registryPageContributor : this.pages) {
            if (!registryPageContributor.getPageId().equals(string)) continue;
            return registryPageContributor;
        }
        return null;
    }

    @Override
    String getCategory(Object object) {
        return ((RegistryPageContributor)object).getCategory();
    }

    @Override
    protected String invalidCategoryNodeMessage(CategorizedPageRegistryReader.CategoryNode categoryNode) {
        RegistryPageContributor registryPageContributor = (RegistryPageContributor)categoryNode.getNode();
        return "Invalid property category path: " + registryPageContributor.getCategory() + " (bundle: " + registryPageContributor.getPluginId() + ", propertyPage: " + registryPageContributor.getLocalId() + ")";
    }

    @Override
    Collection getNodes() {
        return this.pages;
    }

    class PropertyCategoryNode
    extends CategorizedPageRegistryReader.CategoryNode {
        RegistryPageContributor page;

        PropertyCategoryNode(CategorizedPageRegistryReader categorizedPageRegistryReader, RegistryPageContributor registryPageContributor) {
            super(categorizedPageRegistryReader);
            this.page = registryPageContributor;
        }

        @Override
        String getLabelText() {
            return this.page.getPageName();
        }

        @Override
        String getLabelText(Object object) {
            return ((RegistryPageContributor)object).getPageName();
        }

        @Override
        Object getNode() {
            return this.page;
        }
    }
}

