/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.PreferenceFilterEntry;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.preferences.PreferenceTransferElement;
import org.eclipse.ui.internal.registry.RegistryReader;

public class PreferenceTransferRegistryReader
extends RegistryReader {
    private List preferenceTransfers;
    private String pluginPoint;

    public PreferenceTransferRegistryReader(String string) {
        this.pluginPoint = string;
    }

    protected PreferenceTransferElement createPreferenceTransferElement(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement.getAttribute("name") == null) {
            PreferenceTransferRegistryReader.logMissingAttribute(iConfigurationElement, "name");
            return null;
        }
        if (iConfigurationElement.getChildren("mapping") == null) {
            PreferenceTransferRegistryReader.logMissingElement(iConfigurationElement, "mapping");
            return null;
        }
        return new PreferenceTransferElement(iConfigurationElement);
    }

    public PreferenceTransferElement[] getPreferenceTransfers() {
        this.readPreferenceTransfers();
        PreferenceTransferElement[] preferenceTransferElementArray = new PreferenceTransferElement[this.preferenceTransfers.size()];
        Collections.sort(this.preferenceTransfers, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = ((PreferenceTransferElement)object).getName();
                String string2 = ((PreferenceTransferElement)object2).getName();
                return Collator.getInstance().compare(string, string2);
            }
        });
        this.preferenceTransfers.toArray(preferenceTransferElementArray);
        return preferenceTransferElementArray;
    }

    @Override
    protected boolean readElement(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement.getName().equals("transfer")) {
            PreferenceTransferElement preferenceTransferElement = this.createPreferenceTransferElement(iConfigurationElement);
            if (preferenceTransferElement != null) {
                this.preferenceTransfers.add(preferenceTransferElement);
            }
            return true;
        }
        return iConfigurationElement.getName().equals("settingsTransfer");
    }

    protected void readPreferenceTransfers() {
        this.preferenceTransfers = new ArrayList();
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        this.readRegistry(iExtensionRegistry, WorkbenchPlugin.PI_WORKBENCH, this.pluginPoint);
    }

    public static IConfigurationElement[] getMappings(IConfigurationElement iConfigurationElement) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("mapping");
        if (iConfigurationElementArray.length < 1) {
            PreferenceTransferRegistryReader.logMissingElement(iConfigurationElement, "mapping");
            return new IConfigurationElement[0];
        }
        return iConfigurationElementArray;
    }

    public static String getScope(IConfigurationElement iConfigurationElement) {
        return iConfigurationElement.getAttribute("scope");
    }

    public static Map getEntry(IConfigurationElement iConfigurationElement) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("entry");
        if (iConfigurationElementArray.length == 0) {
            return null;
        }
        HashMap<String, PreferenceFilterEntry[]> hashMap = new HashMap<String, PreferenceFilterEntry[]>(iConfigurationElementArray.length);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n];
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElement2.getChildren("key");
            PreferenceFilterEntry[] preferenceFilterEntryArray = null;
            if (iConfigurationElementArray2.length > 0) {
                preferenceFilterEntryArray = new PreferenceFilterEntry[iConfigurationElementArray2.length];
                int n2 = 0;
                while (n2 < iConfigurationElementArray2.length) {
                    IConfigurationElement iConfigurationElement3 = iConfigurationElementArray2[n2];
                    preferenceFilterEntryArray[n2] = new PreferenceFilterEntry(iConfigurationElement3.getAttribute("name"), iConfigurationElement3.getAttribute("match"));
                    ++n2;
                }
            }
            hashMap.put(iConfigurationElement2.getAttribute("node"), preferenceFilterEntryArray);
            ++n;
        }
        return hashMap;
    }
}

