/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceNode;
import org.eclipse.ui.internal.registry.CategorizedPageRegistryReader;

public class PreferencePageRegistryReader
extends CategorizedPageRegistryReader {
    private static final String TAG_PAGE = "page";
    private List nodes;
    private IWorkbench workbench;

    public PreferencePageRegistryReader(IWorkbench iWorkbench) {
        this.workbench = iWorkbench;
    }

    @Override
    Object findNode(String string) {
        int n = 0;
        while (n < this.nodes.size()) {
            WorkbenchPreferenceNode workbenchPreferenceNode = (WorkbenchPreferenceNode)this.nodes.get(n);
            if (workbenchPreferenceNode.getId().equals(string)) {
                return workbenchPreferenceNode;
            }
            ++n;
        }
        return null;
    }

    @Override
    Object findNode(Object object, String string) {
        IPreferenceNode[] iPreferenceNodeArray = ((WorkbenchPreferenceNode)object).getSubNodes();
        int n = 0;
        while (n < iPreferenceNodeArray.length) {
            WorkbenchPreferenceNode workbenchPreferenceNode = (WorkbenchPreferenceNode)iPreferenceNodeArray[n];
            if (workbenchPreferenceNode.getId().equals(string)) {
                return workbenchPreferenceNode;
            }
            ++n;
        }
        return null;
    }

    @Override
    void add(Object object, Object object2) {
        ((IPreferenceNode)object).add((IPreferenceNode)object2);
    }

    @Override
    CategorizedPageRegistryReader.CategoryNode createCategoryNode(CategorizedPageRegistryReader categorizedPageRegistryReader, Object object) {
        return new PreferencesCategoryNode(categorizedPageRegistryReader, (WorkbenchPreferenceNode)object);
    }

    @Override
    String getCategory(Object object) {
        return ((WorkbenchPreferenceNode)object).getCategory();
    }

    @Override
    protected String invalidCategoryNodeMessage(CategorizedPageRegistryReader.CategoryNode categoryNode) {
        WorkbenchPreferenceNode workbenchPreferenceNode = (WorkbenchPreferenceNode)categoryNode.getNode();
        return "Invalid preference category path: " + workbenchPreferenceNode.getCategory() + " (bundle: " + workbenchPreferenceNode.getPluginId() + ", page: " + workbenchPreferenceNode.getLocalId() + ")";
    }

    @Override
    Collection getNodes() {
        return this.nodes;
    }

    public void loadFromRegistry(IExtensionRegistry iExtensionRegistry) {
        this.nodes = new ArrayList();
        this.readRegistry(iExtensionRegistry, "org.eclipse.ui", "preferencePages");
        this.processNodes();
    }

    @Override
    protected boolean readElement(IConfigurationElement iConfigurationElement) {
        if (!iConfigurationElement.getName().equals(TAG_PAGE)) {
            return false;
        }
        WorkbenchPreferenceNode workbenchPreferenceNode = PreferencePageRegistryReader.createNode(iConfigurationElement);
        if (workbenchPreferenceNode != null) {
            if (this.workbench instanceof Workbench && workbenchPreferenceNode.getId().equals(((Workbench)this.workbench).getMainPreferencePageId())) {
                workbenchPreferenceNode.setPriority(-1);
            }
            this.nodes.add(workbenchPreferenceNode);
        }
        return true;
    }

    public static WorkbenchPreferenceNode createNode(IConfigurationElement iConfigurationElement) {
        boolean bl;
        boolean bl2 = iConfigurationElement.getAttribute("name") == null;
        String string = iConfigurationElement.getAttribute("id");
        boolean bl3 = bl = PreferencePageRegistryReader.getClassValue(iConfigurationElement, "class") == null;
        if (bl2) {
            PreferencePageRegistryReader.logMissingAttribute(iConfigurationElement, "name");
        }
        if (string == null) {
            PreferencePageRegistryReader.logMissingAttribute(iConfigurationElement, "id");
        }
        if (bl) {
            PreferencePageRegistryReader.logMissingAttribute(iConfigurationElement, "class");
        }
        if (bl2 || string == null || bl) {
            return null;
        }
        WorkbenchPreferenceNode workbenchPreferenceNode = new WorkbenchPreferenceNode(string, iConfigurationElement);
        return workbenchPreferenceNode;
    }

    public Collection getTopLevelNodes() {
        return WorkbenchActivityHelper.restrictCollection(this.topLevelNodes, new ArrayList());
    }

    class PreferencesCategoryNode
    extends CategorizedPageRegistryReader.CategoryNode {
        WorkbenchPreferenceNode node;

        public PreferencesCategoryNode(CategorizedPageRegistryReader categorizedPageRegistryReader, WorkbenchPreferenceNode workbenchPreferenceNode) {
            super(categorizedPageRegistryReader);
            this.node = workbenchPreferenceNode;
        }

        @Override
        String getLabelText() {
            return this.node.getLabelText();
        }

        @Override
        String getLabelText(Object object) {
            return ((WorkbenchPreferenceNode)object).getLabelText();
        }

        @Override
        Object getNode() {
            return this.node;
        }
    }
}

