/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ui.IViewLayout;
import org.eclipse.ui.internal.DirtyPerspectiveMarker;
import org.eclipse.ui.internal.PageLayout;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;

public class PerspectiveExtensionReader
extends RegistryReader {
    private String targetID;
    private PageLayout pageLayout;
    private Set includeOnlyTags = null;
    private static final String VAL_LEFT = "left";
    private static final String VAL_RIGHT = "right";
    private static final String VAL_TOP = "top";
    private static final String VAL_BOTTOM = "bottom";
    private static final String VAL_STACK = "stack";
    private static final String VAL_FAST = "fast";
    private static final String VAL_TRUE = "true";
    private static final String VAL_FALSE = "false";
    private IExtensionTracker tracker;

    public void extendLayout(IExtensionTracker iExtensionTracker, String string, PageLayout pageLayout) {
        this.tracker = iExtensionTracker;
        this.targetID = string;
        this.pageLayout = pageLayout;
        this.readRegistry(Platform.getExtensionRegistry(), "org.eclipse.ui", "perspectiveExtensions");
    }

    private boolean includeTag(String string) {
        return this.includeOnlyTags == null || this.includeOnlyTags.contains(string);
    }

    private boolean processActionSet(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("id");
        if (string != null) {
            this.pageLayout.addActionSet(string);
        }
        return true;
    }

    private boolean processExtension(IConfigurationElement iConfigurationElement) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n];
            String string = iConfigurationElement2.getName();
            if (this.includeTag(string)) {
                boolean bl = false;
                if (string.equals("actionSet")) {
                    bl = this.processActionSet(iConfigurationElement2);
                } else if (string.equals("view")) {
                    bl = this.processView(iConfigurationElement2);
                } else if (string.equals("viewShortcut")) {
                    bl = this.processViewShortcut(iConfigurationElement2);
                } else if (string.equals("newWizardShortcut")) {
                    bl = this.processWizardShortcut(iConfigurationElement2);
                } else if (string.equals("perspectiveShortcut")) {
                    bl = this.processPerspectiveShortcut(iConfigurationElement2);
                } else if (string.equals("showInPart")) {
                    bl = this.processShowInPart(iConfigurationElement2);
                } else if (string.equals("hiddenMenuItem")) {
                    bl = this.processHiddenMenuItem(iConfigurationElement2);
                } else if (string.equals("hiddenToolBarItem")) {
                    bl = this.processHiddenToolBarItem(iConfigurationElement2);
                }
                if (!bl) {
                    WorkbenchPlugin.log("Unable to process element: " + string + " in perspective extension: " + iConfigurationElement.getDeclaringExtension().getUniqueIdentifier());
                }
            }
            ++n;
        }
        return true;
    }

    private boolean processPerspectiveShortcut(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("id");
        if (string != null) {
            this.pageLayout.addPerspectiveShortcut(string);
        }
        return true;
    }

    private boolean processShowInPart(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("id");
        if (string != null) {
            this.pageLayout.addShowInPart(string);
        }
        return true;
    }

    private boolean processHiddenMenuItem(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("id");
        if (string != null) {
            this.pageLayout.addHiddenMenuItemId(string);
        }
        return true;
    }

    private boolean processHiddenToolBarItem(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("id");
        if (string != null) {
            this.pageLayout.addHiddenToolBarItemId(string);
        }
        return true;
    }

    private boolean processView(IConfigurationElement iConfigurationElement) {
        float f;
        boolean bl;
        String string = iConfigurationElement.getAttribute("id");
        String string2 = iConfigurationElement.getAttribute("relative");
        String string3 = iConfigurationElement.getAttribute("relationship");
        String string4 = iConfigurationElement.getAttribute("ratio");
        boolean bl2 = !VAL_FALSE.equals(iConfigurationElement.getAttribute("visible"));
        String string5 = iConfigurationElement.getAttribute("closeable");
        String string6 = iConfigurationElement.getAttribute("moveable");
        String string7 = iConfigurationElement.getAttribute("standalone");
        String string8 = iConfigurationElement.getAttribute("showTitle");
        String string9 = iConfigurationElement.getAttribute("minimized");
        boolean bl3 = bl = string9 != null && VAL_TRUE.equals(string9);
        if (string == null) {
            PerspectiveExtensionReader.logMissingAttribute(iConfigurationElement, "id");
            return false;
        }
        if (string3 == null) {
            PerspectiveExtensionReader.logMissingAttribute(iConfigurationElement, "relationship");
            return false;
        }
        if (!VAL_FAST.equals(string3) && string2 == null) {
            PerspectiveExtensionReader.logError(iConfigurationElement, "Attribute 'relative' not defined.  This attribute is required when relationship=\"" + string3 + "\".");
            return false;
        }
        if (string4 == null) {
            f = -2.0f;
        } else {
            try {
                f = new Float(string4).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (f < 0.05f || f > 0.95f) {
                f = -1.0f;
            }
        }
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        if (string3.equals(VAL_LEFT)) {
            n = 1;
        } else if (string3.equals(VAL_RIGHT)) {
            n = 2;
        } else if (string3.equals(VAL_TOP)) {
            n = 3;
        } else if (string3.equals(VAL_BOTTOM)) {
            n = 4;
        } else if (string3.equals(VAL_STACK)) {
            bl4 = true;
        } else if (string3.equals(VAL_FAST)) {
            bl5 = true;
        } else {
            return false;
        }
        if (bl2) {
            this.pageLayout.removePlaceholder(string);
        }
        if (bl4) {
            if (bl2) {
                this.pageLayout.stackView(string, string2);
            } else {
                this.pageLayout.stackPlaceholder(string, string2);
            }
        } else if (bl5) {
            if (f == -2.0f) {
                this.pageLayout.addFastView(string);
            } else {
                this.pageLayout.addFastView(string, f);
            }
        } else {
            if (f == -2.0f || f == -1.0f) {
                f = 0.5f;
            }
            if (bl2) {
                if (VAL_TRUE.equals(string7)) {
                    this.pageLayout.addStandaloneView(string, !VAL_FALSE.equals(string8), n, f, string2);
                } else {
                    this.pageLayout.addView(string, n, f, string2, bl);
                }
            } else if (VAL_TRUE.equals(string7)) {
                this.pageLayout.addStandaloneViewPlaceholder(string, n, f, string2, !VAL_FALSE.equals(string8));
            } else {
                this.pageLayout.addPlaceholder(string, n, f, string2);
            }
        }
        IViewLayout iViewLayout = this.pageLayout.getViewLayout(string);
        if (iViewLayout != null) {
            if (string5 != null) {
                iViewLayout.setCloseable(!VAL_FALSE.equals(string5));
            }
            if (string6 != null) {
                iViewLayout.setMoveable(!VAL_FALSE.equals(string6));
            }
        }
        return true;
    }

    private boolean processViewShortcut(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("id");
        if (string != null) {
            this.pageLayout.addShowViewShortcut(string);
        }
        return true;
    }

    private boolean processWizardShortcut(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("id");
        if (string != null) {
            this.pageLayout.addNewWizardShortcut(string);
        }
        return true;
    }

    @Override
    protected boolean readElement(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getName();
        if (string.equals("perspectiveExtension")) {
            String string2 = iConfigurationElement.getAttribute("targetID");
            if (this.targetID.equals(string2) || "*".equals(string2)) {
                if (this.tracker != null) {
                    this.tracker.registerObject(iConfigurationElement.getDeclaringExtension(), (Object)new DirtyPerspectiveMarker(string2), 0);
                }
                return this.processExtension(iConfigurationElement);
            }
            return true;
        }
        return false;
    }

    public void setIncludeOnlyTags(String[] stringArray) {
        this.includeOnlyTags = new HashSet();
        int n = 0;
        while (n < stringArray.length) {
            this.includeOnlyTags.add(stringArray[n]);
            ++n;
        }
    }
}

