/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PerspectiveDescriptor
implements IPerspectiveDescriptor,
IPluginContribution {
    private String id;
    private String pluginId;
    private String originalId;
    private String label;
    private String className;
    private String description;
    private boolean singleton;
    private boolean fixed;
    private ImageDescriptor image;
    private IConfigurationElement configElement;

    public PerspectiveDescriptor(String string, String string2, PerspectiveDescriptor perspectiveDescriptor) {
        this.id = string;
        this.label = string2;
        if (perspectiveDescriptor != null) {
            this.originalId = perspectiveDescriptor.getOriginalId();
            this.image = perspectiveDescriptor.image;
            this.pluginId = perspectiveDescriptor.getPluginId();
        }
    }

    public PerspectiveDescriptor(String string, IConfigurationElement iConfigurationElement) throws CoreException {
        this.configElement = iConfigurationElement;
        this.id = string;
        if (this.getId() == null || this.getLabel() == null || this.getClassName() == null) {
            throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, "Invalid extension (missing label, id or class name): " + this.getId(), null));
        }
    }

    public IPerspectiveFactory createFactory() throws CoreException {
        if (this.originalId != null) {
            IPerspectiveDescriptor iPerspectiveDescriptor = ((PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry()).findPerspectiveWithId(this.originalId);
            return iPerspectiveDescriptor == null ? null : ((PerspectiveDescriptor)iPerspectiveDescriptor).createFactory();
        }
        if (this.configElement != null) {
            try {
                return (IPerspectiveFactory)this.configElement.createExecutableExtension("class");
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public void deleteCustomDefinition() {
        ((PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry()).deleteCustomDefinition(this);
    }

    @Override
    public String getDescription() {
        return this.configElement == null ? this.description : RegistryReader.getDescription(this.configElement);
    }

    public boolean getFixed() {
        return this.configElement == null ? this.fixed : Boolean.valueOf(this.configElement.getAttribute("fixed"));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        if (this.image == null && this.configElement != null) {
            String string = this.configElement.getAttribute("icon");
            if (string != null) {
                this.image = AbstractUIPlugin.imageDescriptorFromPlugin(this.configElement.getNamespace(), string);
            }
            if (this.image == null) {
                this.image = WorkbenchImages.getImageDescriptor("IMG_ETOOL_DEF_PERSPECTIVE");
            }
        }
        return this.image;
    }

    @Override
    public String getLabel() {
        return this.configElement == null ? this.label : this.configElement.getAttribute("name");
    }

    public String getOriginalId() {
        if (this.originalId == null) {
            return this.getId();
        }
        return this.originalId;
    }

    public boolean hasCustomDefinition() {
        return ((PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry()).hasCustomDefinition(this);
    }

    public boolean hasDefaultFlag() {
        if (this.configElement == null) {
            return false;
        }
        return Boolean.valueOf(this.configElement.getAttribute("default"));
    }

    public boolean isPredefined() {
        return this.getClassName() != null && this.configElement != null;
    }

    public boolean isSingleton() {
        return this.configElement == null ? this.singleton : this.configElement.getAttributeAsIs("singleton") != null;
    }

    public IStatus restoreState(IMemento iMemento) {
        IMemento iMemento2 = iMemento.getChild("descriptor");
        if (iMemento2 != null) {
            this.id = iMemento2.getString("id");
            this.originalId = iMemento2.getString("descriptor");
            this.label = iMemento2.getString("label");
            this.className = iMemento2.getString("class");
            this.singleton = iMemento2.getInteger("singleton") != null;
            IPerspectiveDescriptor iPerspectiveDescriptor = WorkbenchPlugin.getDefault().getPerspectiveRegistry().findPerspectiveWithId(this.getOriginalId());
            if (iPerspectiveDescriptor != null) {
                this.image = iPerspectiveDescriptor.getImageDescriptor();
            }
        }
        return Status.OK_STATUS;
    }

    public void revertToPredefined() {
        if (this.isPredefined()) {
            this.deleteCustomDefinition();
        }
    }

    public IStatus saveState(IMemento iMemento) {
        IMemento iMemento2 = iMemento.createChild("descriptor");
        iMemento2.putString("id", this.getId());
        if (this.originalId != null) {
            iMemento2.putString("descriptor", this.originalId);
        }
        iMemento2.putString("label", this.getLabel());
        iMemento2.putString("class", this.getClassName());
        if (this.singleton) {
            iMemento2.putInteger("singleton", 1);
        }
        return Status.OK_STATUS;
    }

    public IConfigurationElement getConfigElement() {
        return this.configElement;
    }

    @Override
    public String getLocalId() {
        return this.getId();
    }

    @Override
    public String getPluginId() {
        return this.configElement == null ? this.pluginId : this.configElement.getNamespace();
    }

    public String getClassName() {
        return this.configElement == null ? this.className : RegistryReader.getClassValue(this.configElement, "class");
    }
}

