/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.util.Util;

class MockMapping
implements IFileEditorMapping {
    private IContentType contentType;
    private String extension;
    private String filename;

    MockMapping(IContentType iContentType, String string, String string2) {
        this.contentType = iContentType;
        this.filename = string;
        this.extension = string2;
    }

    @Override
    public IEditorDescriptor getDefaultEditor() {
        IEditorDescriptor[] iEditorDescriptorArray = ((EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry()).getEditorsForContentType(this.contentType);
        if (iEditorDescriptorArray.length == 0 || WorkbenchActivityHelper.restrictUseOf(iEditorDescriptorArray[0])) {
            return null;
        }
        return iEditorDescriptorArray[0];
    }

    @Override
    public IEditorDescriptor[] getEditors() {
        Object[] objectArray = ((EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry()).getEditorsForContentType(this.contentType);
        return (IEditorDescriptor[])WorkbenchActivityHelper.restrictArray(objectArray);
    }

    @Override
    public IEditorDescriptor[] getDeletedEditors() {
        return new IEditorDescriptor[0];
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        IEditorDescriptor iEditorDescriptor = this.getDefaultEditor();
        if (iEditorDescriptor == null) {
            return WorkbenchImages.getImageDescriptor("IMG_OBJ_FILE");
        }
        return iEditorDescriptor.getImageDescriptor();
    }

    @Override
    public String getLabel() {
        return String.valueOf(this.filename) + '.' + this.extension;
    }

    @Override
    public String getName() {
        return this.filename;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MockMapping)) {
            return false;
        }
        MockMapping mockMapping = (MockMapping)object;
        if (!this.filename.equals(mockMapping.filename)) {
            return false;
        }
        if (!this.extension.equals(mockMapping.extension)) {
            return false;
        }
        if (!Util.equals(this.getEditors(), mockMapping.getEditors())) {
            return false;
        }
        return Util.equals(this.getDeletedEditors(), mockMapping.getDeletedEditors());
    }
}

