/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ui.PlatformUI;

public final class KeywordRegistry
implements IExtensionChangeHandler {
    private static final String ATT_ID = "id";
    private static final String ATT_LABEL = "label";
    private static KeywordRegistry instance;
    private static final String TAG_KEYWORD = "keyword";
    private Map internalKeywordMap = new HashMap();

    public static KeywordRegistry getInstance() {
        if (instance == null) {
            instance = new KeywordRegistry();
        }
        return instance;
    }

    private KeywordRegistry() {
        IExtensionTracker iExtensionTracker = PlatformUI.getWorkbench().getExtensionTracker();
        iExtensionTracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getExtensionPointFilter()));
        IExtension[] iExtensionArray = this.getExtensionPointFilter().getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            this.addExtension(PlatformUI.getWorkbench().getExtensionTracker(), iExtensionArray[n]);
            ++n;
        }
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if (iConfigurationElementArray[n].getName().equals(TAG_KEYWORD)) {
                String string = iConfigurationElementArray[n].getAttribute(ATT_LABEL);
                String string2 = iConfigurationElementArray[n].getAttribute(ATT_ID);
                this.internalKeywordMap.put(string2, string);
                PlatformUI.getWorkbench().getExtensionTracker().registerObject(iExtension, (Object)string2, 2);
            }
            ++n;
        }
    }

    private IExtensionPoint getExtensionPointFilter() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "keywords");
    }

    public String getKeywordLabel(String string) {
        return (String)this.internalKeywordMap.get(string);
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof String) {
                this.internalKeywordMap.remove(objectArray[n]);
            }
            ++n;
        }
    }
}

