/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.registry.EditorDescriptor;

public class FileEditorMapping
implements IFileEditorMapping,
Cloneable {
    private static final String STAR = "*";
    private static final String DOT = ".";
    private String name = "*";
    private String extension;
    private List editors = new ArrayList(1);
    private List deletedEditors = new ArrayList(1);
    private List declaredDefaultEditors = new ArrayList(1);

    public FileEditorMapping(String string) {
        this(STAR, string);
    }

    public FileEditorMapping(String string, String string2) {
        if (string == null || string.length() < 1) {
            this.setName(STAR);
        } else {
            this.setName(string);
        }
        if (string2 == null) {
            this.setExtension("");
        } else {
            this.setExtension(string2);
        }
    }

    public void addEditor(EditorDescriptor editorDescriptor) {
        this.editors.add(editorDescriptor);
        this.deletedEditors.remove(editorDescriptor);
    }

    public Object clone() {
        try {
            FileEditorMapping fileEditorMapping = (FileEditorMapping)super.clone();
            fileEditorMapping.editors = (List)((ArrayList)this.editors).clone();
            fileEditorMapping.deletedEditors = (List)((ArrayList)this.deletedEditors).clone();
            fileEditorMapping.declaredDefaultEditors = (List)((ArrayList)this.declaredDefaultEditors).clone();
            return fileEditorMapping;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FileEditorMapping)) {
            return false;
        }
        FileEditorMapping fileEditorMapping = (FileEditorMapping)object;
        if (!this.name.equals(fileEditorMapping.name)) {
            return false;
        }
        if (!this.extension.equals(fileEditorMapping.extension)) {
            return false;
        }
        if (!this.compareList(this.editors, fileEditorMapping.editors)) {
            return false;
        }
        if (!this.compareList(this.declaredDefaultEditors, fileEditorMapping.declaredDefaultEditors)) {
            return false;
        }
        return this.compareList(this.deletedEditors, fileEditorMapping.deletedEditors);
    }

    private boolean compareList(List list, List list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Object e = iterator.next();
            Object e2 = iterator2.next();
            if (!(e == null ? e2 != null : !e.equals(e2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.declaredDefaultEditors == null ? 0 : this.declaredDefaultEditors.hashCode());
        n = 31 * n + (this.deletedEditors == null ? 0 : this.deletedEditors.hashCode());
        n = 31 * n + (this.editors == null ? 0 : this.editors.hashCode());
        n = 31 * n + (this.extension == null ? 0 : this.extension.hashCode());
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    @Override
    public IEditorDescriptor getDefaultEditor() {
        if (this.editors.size() == 0 || WorkbenchActivityHelper.restrictUseOf(this.editors.get(0))) {
            return null;
        }
        return (IEditorDescriptor)this.editors.get(0);
    }

    IEditorDescriptor[] getUnfilteredEditors() {
        return this.editors.toArray(new IEditorDescriptor[this.editors.size()]);
    }

    @Override
    public IEditorDescriptor[] getEditors() {
        Collection collection = WorkbenchActivityHelper.restrictCollection(this.editors, new ArrayList());
        return collection.toArray(new IEditorDescriptor[collection.size()]);
    }

    @Override
    public IEditorDescriptor[] getDeletedEditors() {
        IEditorDescriptor[] iEditorDescriptorArray = new IEditorDescriptor[this.deletedEditors.size()];
        this.deletedEditors.toArray(iEditorDescriptorArray);
        return iEditorDescriptorArray;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        IEditorDescriptor iEditorDescriptor = this.getDefaultEditor();
        if (iEditorDescriptor == null) {
            return WorkbenchImages.getImageDescriptor("IMG_OBJ_FILE");
        }
        return iEditorDescriptor.getImageDescriptor();
    }

    @Override
    public String getLabel() {
        return TextProcessor.process((String)(String.valueOf(this.name) + (this.extension.length() == 0 ? "" : DOT + this.extension)), (String)"*.");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void removeEditor(EditorDescriptor editorDescriptor) {
        this.editors.remove(editorDescriptor);
        this.deletedEditors.add(editorDescriptor);
        this.declaredDefaultEditors.remove(editorDescriptor);
    }

    public void setDefaultEditor(EditorDescriptor editorDescriptor) {
        this.editors.remove(editorDescriptor);
        this.editors.add(0, editorDescriptor);
        this.declaredDefaultEditors.remove(editorDescriptor);
        this.declaredDefaultEditors.add(0, editorDescriptor);
    }

    public void setEditorsList(List list) {
        this.editors = list;
        this.declaredDefaultEditors.retainAll(list);
    }

    public void setDeletedEditorsList(List list) {
        this.deletedEditors = list;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public IEditorDescriptor[] getDeclaredDefaultEditors() {
        Collection collection = WorkbenchActivityHelper.restrictCollection(this.declaredDefaultEditors, new ArrayList());
        return collection.toArray(new IEditorDescriptor[collection.size()]);
    }

    public boolean isDeclaredDefaultEditor(IEditorDescriptor iEditorDescriptor) {
        return this.declaredDefaultEditors.contains(iEditorDescriptor) && !WorkbenchActivityHelper.restrictUseOf(iEditorDescriptor);
    }

    public void setDefaultEditors(List list) {
        this.declaredDefaultEditors = list;
    }
}

