/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import com.ibm.icu.text.Collator;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.editorsupport.ComponentSupport;
import org.eclipse.ui.internal.misc.ExternalProgramImageDescriptor;
import org.eclipse.ui.internal.misc.ProgramImageDescriptor;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistryReader;
import org.eclipse.ui.internal.registry.FileEditorMapping;
import org.eclipse.ui.internal.registry.MockMapping;

public class EditorRegistry
extends EventManager
implements IEditorRegistry,
IExtensionChangeHandler {
    private static final IEditorDescriptor[] EMPTY = new IEditorDescriptor[0];
    private Map contentTypeToEditorMappings = new HashMap();
    private Map extensionImages = new HashMap();
    private List sortedEditorsFromPlugins = new ArrayList();
    private Map mapIDtoEditor = this.initialIdToEditorMap(10);
    private EditorMap typeEditorMappings;
    private static final Comparator comparer = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object object, Object object2) {
            String string = ((IEditorDescriptor)object).getLabel();
            String string2 = ((IEditorDescriptor)object2).getLabel();
            return this.collator.compare(string, string2);
        }
    };
    private RelatedRegistry relatedRegistry;
    public static final String EMPTY_EDITOR_ID = "org.eclipse.ui.internal.emptyEditorTab";

    public EditorRegistry() {
        this.initializeFromStorage();
        IExtensionTracker iExtensionTracker = PlatformUI.getWorkbench().getExtensionTracker();
        iExtensionTracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getExtensionPointFilter()));
        this.relatedRegistry = new RelatedRegistry();
    }

    public void addEditorFromPlugin(EditorDescriptor editorDescriptor, List list, List list2, List list3, boolean bl) {
        IEditorDescriptor[] iEditorDescriptorArray;
        IEditorDescriptor[] iEditorDescriptorArray2;
        FileEditorMapping fileEditorMapping;
        PlatformUI.getWorkbench().getExtensionTracker().registerObject(editorDescriptor.getConfigurationElement().getDeclaringExtension(), (Object)editorDescriptor, 2);
        this.sortedEditorsFromPlugins.add(editorDescriptor);
        for (Object object : list) {
            if (object == null || object.length() <= 0) continue;
            fileEditorMapping = this.getMappingFor("*." + (String)object);
            if (fileEditorMapping == null) {
                fileEditorMapping = new FileEditorMapping((String)object);
                this.typeEditorMappings.putDefault(this.mappingKeyFor(fileEditorMapping), fileEditorMapping);
            }
            fileEditorMapping.addEditor(editorDescriptor);
            if (!bl) continue;
            fileEditorMapping.setDefaultEditor(editorDescriptor);
        }
        for (Object object : list2) {
            if (object == null || object.length() <= 0) continue;
            fileEditorMapping = this.getMappingFor((String)object);
            if (fileEditorMapping == null) {
                int n = object.indexOf(46);
                if (n < 0) {
                    iEditorDescriptorArray2 = object;
                    iEditorDescriptorArray = "";
                } else {
                    iEditorDescriptorArray2 = object.substring(0, n);
                    iEditorDescriptorArray = object.substring(n + 1);
                }
                fileEditorMapping = new FileEditorMapping((String)iEditorDescriptorArray2, (String)iEditorDescriptorArray);
                this.typeEditorMappings.putDefault(this.mappingKeyFor(fileEditorMapping), fileEditorMapping);
            }
            fileEditorMapping.addEditor(editorDescriptor);
            if (!bl) continue;
            fileEditorMapping.setDefaultEditor(editorDescriptor);
        }
        for (Object object : list3) {
            if (object == null || object.length() <= 0 || (fileEditorMapping = Platform.getContentTypeManager().getContentType((String)object)) == null) continue;
            iEditorDescriptorArray2 = (IEditorDescriptor[])this.contentTypeToEditorMappings.get(fileEditorMapping);
            if (iEditorDescriptorArray2 == null) {
                iEditorDescriptorArray2 = new IEditorDescriptor[]{editorDescriptor};
                this.contentTypeToEditorMappings.put(fileEditorMapping, iEditorDescriptorArray2);
                continue;
            }
            iEditorDescriptorArray = new IEditorDescriptor[iEditorDescriptorArray2.length + 1];
            if (bl) {
                iEditorDescriptorArray[0] = editorDescriptor;
                System.arraycopy(iEditorDescriptorArray2, 0, iEditorDescriptorArray, 1, iEditorDescriptorArray2.length);
            } else {
                iEditorDescriptorArray[iEditorDescriptorArray2.length] = editorDescriptor;
                System.arraycopy(iEditorDescriptorArray2, 0, iEditorDescriptorArray, 0, iEditorDescriptorArray2.length);
            }
            this.contentTypeToEditorMappings.put(fileEditorMapping, iEditorDescriptorArray);
        }
        this.mapIDtoEditor.put(editorDescriptor.getId(), editorDescriptor);
    }

    private void addExternalEditorsToEditorMap() {
        IEditorDescriptor iEditorDescriptor = null;
        FileEditorMapping[] fileEditorMappingArray = this.typeEditorMappings.allMappings();
        int n = 0;
        while (n < fileEditorMappingArray.length) {
            FileEditorMapping fileEditorMapping = fileEditorMappingArray[n];
            IEditorDescriptor[] iEditorDescriptorArray = fileEditorMapping.getEditors();
            int n2 = 0;
            while (n2 < iEditorDescriptorArray.length) {
                iEditorDescriptor = iEditorDescriptorArray[n2];
                this.mapIDtoEditor.put(iEditorDescriptor.getId(), iEditorDescriptor);
                ++n2;
            }
            ++n;
        }
    }

    @Override
    public void addPropertyListener(IPropertyListener iPropertyListener) {
        this.addListenerObject(iPropertyListener);
    }

    @Override
    public IEditorDescriptor findEditor(String string) {
        Object v = this.mapIDtoEditor.get(string);
        if (WorkbenchActivityHelper.restrictUseOf(v)) {
            return null;
        }
        return (IEditorDescriptor)v;
    }

    private void firePropertyChange(final int n) {
        Object[] objectArray = this.getListeners();
        int n2 = 0;
        while (n2 < objectArray.length) {
            final IPropertyListener iPropertyListener = (IPropertyListener)objectArray[n2];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iPropertyListener.propertyChanged(EditorRegistry.this, n);
                }
            });
            ++n2;
        }
    }

    @Override
    public IEditorDescriptor getDefaultEditor() {
        return this.findEditor("org.eclipse.ui.systemExternalEditor");
    }

    @Override
    public IEditorDescriptor getDefaultEditor(String string) {
        IEditorDescriptor iEditorDescriptor = this.getDefaultEditor(string, this.guessAtContentType(string));
        if (iEditorDescriptor != null) {
            return iEditorDescriptor;
        }
        IContentType[] iContentTypeArray = Platform.getContentTypeManager().findContentTypesFor(string);
        int n = 0;
        while (n < iContentTypeArray.length) {
            IEditorDescriptor iEditorDescriptor2 = this.getDefaultEditor(string, iContentTypeArray[n]);
            if (iEditorDescriptor2 != null) {
                return iEditorDescriptor2;
            }
            ++n;
        }
        return null;
    }

    private IContentType guessAtContentType(String string) {
        return Platform.getContentTypeManager().findContentTypeFor(string);
    }

    private ImageDescriptor getDefaultImage() {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_FILE");
    }

    @Override
    public IEditorDescriptor[] getEditors(String string) {
        return this.getEditors(string, this.guessAtContentType(string));
    }

    @Override
    public IFileEditorMapping[] getFileEditorMappings() {
        IFileEditorMapping[] iFileEditorMappingArray = this.typeEditorMappings.allMappings();
        final Collator collator = Collator.getInstance();
        Arrays.sort(iFileEditorMappingArray, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = ((FileEditorMapping)object).getLabel();
                String string2 = ((FileEditorMapping)object2).getLabel();
                return collator.compare(string, string2);
            }
        });
        return iFileEditorMappingArray;
    }

    @Override
    public ImageDescriptor getImageDescriptor(String string) {
        return this.getImageDescriptor(string, this.guessAtContentType(string));
    }

    private FileEditorMapping getMappingFor(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.mappingKeyFor(string);
        return this.typeEditorMappings.get(string2);
    }

    private FileEditorMapping[] getMappingForFilename(String string) {
        FileEditorMapping[] fileEditorMappingArray = new FileEditorMapping[2];
        fileEditorMappingArray[0] = this.getMappingFor(string);
        int n = string.lastIndexOf(46);
        if (n > -1) {
            String string2 = string.substring(n);
            fileEditorMappingArray[1] = this.getMappingFor("*" + string2);
        }
        return fileEditorMappingArray;
    }

    public IEditorDescriptor[] getSortedEditorsFromOS() {
        IEditorDescriptor[] iEditorDescriptorArray;
        ArrayList<IEditorDescriptor[]> arrayList = new ArrayList<IEditorDescriptor[]>();
        Program[] programArray = Program.getPrograms();
        int n = 0;
        while (n < programArray.length) {
            iEditorDescriptorArray = new EditorDescriptor();
            iEditorDescriptorArray.setOpenMode(4);
            iEditorDescriptorArray.setProgram(programArray[n]);
            ExternalProgramImageDescriptor externalProgramImageDescriptor = new ExternalProgramImageDescriptor(programArray[n]);
            iEditorDescriptorArray.setImageDescriptor(externalProgramImageDescriptor);
            arrayList.add(iEditorDescriptorArray);
            ++n;
        }
        Object[] objectArray = this.sortEditors(arrayList);
        iEditorDescriptorArray = new IEditorDescriptor[arrayList.size()];
        int n2 = 0;
        while (n2 < objectArray.length) {
            iEditorDescriptorArray[n2] = (IEditorDescriptor)objectArray[n2];
            ++n2;
        }
        return iEditorDescriptorArray;
    }

    public IEditorDescriptor[] getSortedEditorsFromPlugins() {
        Collection collection = WorkbenchActivityHelper.restrictCollection(this.sortedEditorsFromPlugins, new ArrayList());
        return collection.toArray(new IEditorDescriptor[collection.size()]);
    }

    private HashMap initialIdToEditorMap(int n) {
        HashMap hashMap = new HashMap(n);
        this.addSystemEditors(hashMap);
        return hashMap;
    }

    private void addSystemEditors(HashMap hashMap) {
        EditorDescriptor editorDescriptor = new EditorDescriptor();
        editorDescriptor.setID("org.eclipse.ui.systemExternalEditor");
        editorDescriptor.setName(WorkbenchMessages.SystemEditorDescription_name);
        editorDescriptor.setOpenMode(4);
        hashMap.put("org.eclipse.ui.systemExternalEditor", editorDescriptor);
        if (ComponentSupport.inPlaceEditorSupported()) {
            editorDescriptor = new EditorDescriptor();
            editorDescriptor.setID("org.eclipse.ui.systemInPlaceEditor");
            editorDescriptor.setName(WorkbenchMessages.SystemInPlaceDescription_name);
            editorDescriptor.setOpenMode(2);
            hashMap.put("org.eclipse.ui.systemInPlaceEditor", editorDescriptor);
        }
        EditorDescriptor editorDescriptor2 = new EditorDescriptor();
        editorDescriptor2.setID(EMPTY_EDITOR_ID);
        editorDescriptor2.setName("(Empty)");
        editorDescriptor2.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_OBJ_ELEMENT"));
        hashMap.put(EMPTY_EDITOR_ID, editorDescriptor2);
    }

    private void initializeFromStorage() {
        this.typeEditorMappings = new EditorMap();
        this.extensionImages = new HashMap();
        EditorRegistryReader editorRegistryReader = new EditorRegistryReader();
        editorRegistryReader.addEditors(this);
        this.sortInternalEditors();
        this.rebuildInternalEditorMap();
        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
        String string = iPreferenceStore.getString("defaultEditors");
        String string2 = iPreferenceStore.getString("defaultEditorsCache");
        if (string == null || string.equals(string2)) {
            this.setProductDefaults(string);
            this.loadAssociations();
        } else {
            this.loadAssociations();
            this.setProductDefaults(string);
            iPreferenceStore.putValue("defaultEditorsCache", string);
        }
        this.addExternalEditorsToEditorMap();
    }

    private void setProductDefaults(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, new Character(';').toString());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n = string2.indexOf(58);
            if (string2.length() < 3 || n <= 0 || n >= string2.length() - 1) {
                WorkbenchPlugin.log("Error setting default editor. Could not parse '" + string2 + "'. Default editors should be specified as '*.ext1:editorId1;*.ext2:editorId2'");
                return;
            }
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            FileEditorMapping fileEditorMapping = this.getMappingFor(string3);
            if (fileEditorMapping == null) {
                WorkbenchPlugin.log("Error setting default editor. Could not find mapping for '" + string3 + "'.");
                continue;
            }
            EditorDescriptor editorDescriptor = (EditorDescriptor)this.findEditor(string4);
            if (editorDescriptor == null) {
                WorkbenchPlugin.log("Error setting default editor. Could not find editor: '" + string4 + "'.");
                continue;
            }
            fileEditorMapping.setDefaultEditor(editorDescriptor);
        }
    }

    private boolean readEditors(Map map) {
        IPath iPath = WorkbenchPlugin.getDefault().getDataLocation();
        if (iPath == null) {
            return false;
        }
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        Reader reader = null;
        FileInputStream fileInputStream = null;
        try {
            try {
                String string = iPreferenceStore.getString("editors");
                if (string == null || string.length() == 0) {
                    fileInputStream = new FileInputStream(iPath.append("editors.xml").toOSString());
                    reader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "utf-8"));
                } else {
                    reader = new StringReader(string);
                }
                XMLMemento xMLMemento = XMLMemento.createReadRoot(reader);
                IMemento[] iMementoArray = xMLMemento.getChildren("descriptor");
                int n = 0;
                while (n < iMementoArray.length) {
                    EditorDescriptor editorDescriptor = new EditorDescriptor();
                    boolean bl = editorDescriptor.loadValues(iMementoArray[n]);
                    if (bl) {
                        Object object;
                        if (editorDescriptor.getPluginID() != null) {
                            object = (EditorDescriptor)this.mapIDtoEditor.get(editorDescriptor.getId());
                            if (object != null) {
                                map.put(((EditorDescriptor)object).getId(), object);
                            }
                        } else {
                            object = editorDescriptor.getProgram() == null ? new ProgramImageDescriptor(editorDescriptor.getFileName(), 0) : new ExternalProgramImageDescriptor(editorDescriptor.getProgram());
                            editorDescriptor.setImageDescriptor((ImageDescriptor)object);
                            map.put(editorDescriptor.getId(), editorDescriptor);
                        }
                    }
                    ++n;
                }
            }
            catch (IOException iOException) {
                try {
                    if (reader != null) {
                        reader.close();
                    } else if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException2) {
                    WorkbenchPlugin.log("Error reading editors: Could not close steam", iOException2);
                }
                return false;
            }
            catch (WorkbenchException workbenchException) {
                ErrorDialog.openError(null, (String)WorkbenchMessages.EditorRegistry_errorTitle, (String)WorkbenchMessages.EditorRegistry_errorMessage, (IStatus)workbenchException.getStatus());
                try {
                    if (reader != null) {
                        reader.close();
                    } else if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    WorkbenchPlugin.log("Error reading editors: Could not close steam", iOException);
                }
                return false;
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                } else if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                WorkbenchPlugin.log("Error reading editors: Could not close steam", iOException);
            }
        }
        return true;
    }

    public void readResources(Map map, Reader reader) throws WorkbenchException {
        XMLMemento xMLMemento = XMLMemento.createReadRoot(reader);
        String string = xMLMemento.getString("version");
        boolean bl = "3.1".equals(string);
        IMemento[] iMementoArray = xMLMemento.getChildren("info");
        int n = 0;
        while (n < iMementoArray.length) {
            int n2;
            Object[] objectArray;
            Serializable serializable;
            FileEditorMapping fileEditorMapping;
            String string2 = iMementoArray[n].getString("name");
            if (string2 == null) {
                string2 = "*";
            }
            String string3 = iMementoArray[n].getString("extension");
            IMemento[] iMementoArray2 = iMementoArray[n].getChildren("editor");
            String[] stringArray = new String[iMementoArray2.length];
            int n3 = 0;
            while (n3 < iMementoArray2.length) {
                stringArray[n3] = iMementoArray2[n3].getString("id");
                ++n3;
            }
            iMementoArray2 = iMementoArray[n].getChildren("deletedEditor");
            String[] stringArray2 = new String[iMementoArray2.length];
            int n4 = 0;
            while (n4 < iMementoArray2.length) {
                stringArray2[n4] = iMementoArray2[n4].getString("id");
                ++n4;
            }
            String string4 = string2;
            if (string3 != null && string3.length() > 0) {
                string4 = String.valueOf(string4) + "." + string3;
            }
            if ((fileEditorMapping = this.getMappingFor(string4)) == null) {
                fileEditorMapping = new FileEditorMapping(string2, string3);
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n5 = 0;
            while (n5 < stringArray.length) {
                if (stringArray[n5] != null && (serializable = (EditorDescriptor)map.get(stringArray[n5])) != null) {
                    arrayList.add(serializable);
                }
                ++n5;
            }
            ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
            int n6 = 0;
            while (n6 < stringArray2.length) {
                if (stringArray2[n6] != null && (objectArray = (String[])map.get(stringArray2[n6])) != null) {
                    arrayList2.add((String[])objectArray);
                }
                ++n6;
            }
            serializable = new ArrayList();
            if (bl) {
                iMementoArray2 = iMementoArray[n].getChildren("defaultEditor");
                objectArray = new String[iMementoArray2.length];
                n2 = 0;
                while (n2 < iMementoArray2.length) {
                    objectArray[n2] = iMementoArray2[n2].getString("id");
                    ++n2;
                }
                n2 = 0;
                while (n2 < objectArray.length) {
                    EditorDescriptor editorDescriptor;
                    if (objectArray[n2] != null && (editorDescriptor = (EditorDescriptor)map.get(objectArray[n2])) != null) {
                        serializable.add(editorDescriptor);
                    }
                    ++n2;
                }
            } else {
                if (!arrayList.isEmpty() && (objectArray = (EditorDescriptor)arrayList.get(0)) != null) {
                    serializable.add(objectArray);
                }
                serializable.addAll(Arrays.asList(fileEditorMapping.getDeclaredDefaultEditors()));
            }
            objectArray = fileEditorMapping.getEditors();
            n2 = 0;
            while (n2 < objectArray.length) {
                if (!this.contains(arrayList, (IEditorDescriptor)objectArray[n2]) && !arrayList2.contains(objectArray[n2])) {
                    arrayList.add(objectArray[n2]);
                }
                ++n2;
            }
            fileEditorMapping.setEditorsList(arrayList);
            fileEditorMapping.setDeletedEditorsList(arrayList2);
            fileEditorMapping.setDefaultEditors((List)((Object)serializable));
            this.typeEditorMappings.put(this.mappingKeyFor(fileEditorMapping), fileEditorMapping);
            ++n;
        }
    }

    private boolean contains(List list, IEditorDescriptor iEditorDescriptor) {
        IEditorDescriptor iEditorDescriptor22 = null;
        for (IEditorDescriptor iEditorDescriptor22 : list) {
            if (!iEditorDescriptor22.getId().equals(iEditorDescriptor.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean readResources(Map map) {
        IPath iPath = WorkbenchPlugin.getDefault().getDataLocation();
        if (iPath == null) {
            return false;
        }
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        Reader reader = null;
        FileInputStream fileInputStream = null;
        try {
            try {
                String string = iPreferenceStore.getString("resourcetypes");
                if (string == null || string.length() == 0) {
                    fileInputStream = new FileInputStream(iPath.append("resourcetypes.xml").toOSString());
                    reader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "utf-8"));
                } else {
                    reader = new StringReader(string);
                }
                this.readResources(map, reader);
            }
            catch (IOException iOException) {
                MessageDialog.openError(null, (String)WorkbenchMessages.EditorRegistry_errorTitle, (String)WorkbenchMessages.EditorRegistry_errorMessage);
                try {
                    if (reader != null) {
                        reader.close();
                    } else if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException2) {
                    WorkbenchPlugin.log("Error reading resources: Could not close steam", iOException2);
                }
                return false;
            }
            catch (WorkbenchException workbenchException) {
                ErrorDialog.openError(null, (String)WorkbenchMessages.EditorRegistry_errorTitle, (String)WorkbenchMessages.EditorRegistry_errorMessage, (IStatus)workbenchException.getStatus());
                try {
                    if (reader != null) {
                        reader.close();
                    } else if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    WorkbenchPlugin.log("Error reading resources: Could not close steam", iOException);
                }
                return false;
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                } else if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                WorkbenchPlugin.log("Error reading resources: Could not close steam", iOException);
            }
        }
        return true;
    }

    private boolean loadAssociations() {
        HashMap hashMap = new HashMap();
        if (!this.readEditors(hashMap)) {
            return false;
        }
        return this.readResources(hashMap);
    }

    private String mappingKeyFor(String string) {
        return string.toLowerCase();
    }

    private String mappingKeyFor(FileEditorMapping fileEditorMapping) {
        return this.mappingKeyFor(String.valueOf(fileEditorMapping.getName()) + (fileEditorMapping.getExtension().length() == 0 ? "" : "." + fileEditorMapping.getExtension()));
    }

    private void rebuildEditorMap() {
        this.rebuildInternalEditorMap();
        this.addExternalEditorsToEditorMap();
    }

    private void rebuildInternalEditorMap() {
        Iterator iterator = null;
        IEditorDescriptor iEditorDescriptor2 = null;
        this.mapIDtoEditor = this.initialIdToEditorMap(this.mapIDtoEditor.size());
        for (IEditorDescriptor iEditorDescriptor2 : this.sortedEditorsFromPlugins) {
            this.mapIDtoEditor.put(iEditorDescriptor2.getId(), iEditorDescriptor2);
        }
    }

    @Override
    public void removePropertyListener(IPropertyListener iPropertyListener) {
        this.removeListenerObject(iPropertyListener);
    }

    public void saveAssociations() {
        Object object;
        ArrayList<EditorDescriptor> arrayList = new ArrayList<EditorDescriptor>();
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        XMLMemento xMLMemento = XMLMemento.createWriteRoot("editors");
        xMLMemento.putString("version", "3.1");
        FileEditorMapping[] fileEditorMappingArray = this.typeEditorMappings.userMappings();
        int n = 0;
        while (n < fileEditorMappingArray.length) {
            IMemento iMemento;
            EditorDescriptor editorDescriptor;
            FileEditorMapping fileEditorMapping = fileEditorMappingArray[n];
            IMemento object2 = xMLMemento.createChild("info");
            object2.putString("name", fileEditorMapping.getName());
            object2.putString("extension", fileEditorMapping.getExtension());
            object = fileEditorMapping.getEditors();
            int n2 = 0;
            while (n2 < ((IEditorDescriptor[])object).length) {
                editorDescriptor = (EditorDescriptor)object[n2];
                if (!arrayList.contains(editorDescriptor)) {
                    arrayList.add(editorDescriptor);
                }
                iMemento = object2.createChild("editor");
                iMemento.putString("id", object[n2].getId());
                ++n2;
            }
            object = fileEditorMapping.getDeletedEditors();
            n2 = 0;
            while (n2 < ((IEditorDescriptor[])object).length) {
                editorDescriptor = (EditorDescriptor)object[n2];
                if (!arrayList.contains(editorDescriptor)) {
                    arrayList.add(editorDescriptor);
                }
                iMemento = object2.createChild("deletedEditor");
                iMemento.putString("id", object[n2].getId());
                ++n2;
            }
            object = fileEditorMapping.getDeclaredDefaultEditors();
            n2 = 0;
            while (n2 < ((IEditorDescriptor[])object).length) {
                editorDescriptor = (EditorDescriptor)object[n2];
                if (!arrayList.contains(editorDescriptor)) {
                    arrayList.add(editorDescriptor);
                }
                iMemento = object2.createChild("defaultEditor");
                iMemento.putString("id", object[n2].getId());
                ++n2;
            }
            ++n;
        }
        StringWriter stringWriter = null;
        try {
            stringWriter = new StringWriter();
            xMLMemento.save(stringWriter);
            ((Writer)stringWriter).close();
            iPreferenceStore.setValue("resourcetypes", ((Object)stringWriter).toString());
        }
        catch (IOException iOException) {
            try {
                if (stringWriter != null) {
                    ((Writer)stringWriter).close();
                }
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
            }
            MessageDialog.openError(null, (String)"Saving Problems", (String)"Unable to save resource associations.");
            return;
        }
        xMLMemento = XMLMemento.createWriteRoot("editors");
        for (EditorDescriptor editorDescriptor : arrayList) {
            object = xMLMemento.createChild("descriptor");
            editorDescriptor.saveValues((IMemento)object);
        }
        stringWriter = null;
        try {
            stringWriter = new StringWriter();
            xMLMemento.save(stringWriter);
            ((Writer)stringWriter).close();
            iPreferenceStore.setValue("editors", ((Object)stringWriter).toString());
        }
        catch (IOException iOException) {
            try {
                if (stringWriter != null) {
                    ((Writer)stringWriter).close();
                }
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
            }
            MessageDialog.openError(null, (String)"Error", (String)"Unable to save resource associations.");
            return;
        }
    }

    public void setFileEditorMappings(FileEditorMapping[] fileEditorMappingArray) {
        this.typeEditorMappings = new EditorMap();
        int n = 0;
        while (n < fileEditorMappingArray.length) {
            FileEditorMapping fileEditorMapping = fileEditorMappingArray[n];
            this.typeEditorMappings.put(this.mappingKeyFor(fileEditorMapping), fileEditorMapping);
            ++n;
        }
        this.extensionImages = new HashMap();
        this.rebuildEditorMap();
        this.firePropertyChange(1);
    }

    @Override
    public void setDefaultEditor(String string, String string2) {
        EditorDescriptor editorDescriptor = (EditorDescriptor)this.findEditor(string2);
        FileEditorMapping[] fileEditorMappingArray = this.getMappingForFilename(string);
        if (fileEditorMappingArray[0] != null) {
            fileEditorMappingArray[0].setDefaultEditor(editorDescriptor);
        }
        if (fileEditorMappingArray[1] != null) {
            fileEditorMappingArray[1].setDefaultEditor(editorDescriptor);
        }
    }

    private Object[] sortEditors(List list) {
        Object[] objectArray = new Object[list.size()];
        list.toArray(objectArray);
        Collections.sort(Arrays.asList(objectArray), comparer);
        return objectArray;
    }

    private void sortInternalEditors() {
        Object[] objectArray = this.sortEditors(this.sortedEditorsFromPlugins);
        this.sortedEditorsFromPlugins = new ArrayList();
        int n = 0;
        while (n < objectArray.length) {
            this.sortedEditorsFromPlugins.add(objectArray[n]);
            ++n;
        }
    }

    @Override
    public boolean isSystemInPlaceEditorAvailable(String string) {
        return ComponentSupport.inPlaceEditorAvailable(string);
    }

    @Override
    public boolean isSystemExternalEditorAvailable(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            String string2 = string.substring(n);
            return Program.findProgram((String)string2) != null;
        }
        return false;
    }

    @Override
    public ImageDescriptor getSystemExternalEditorImageDescriptor(String string) {
        Program program = null;
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            program = Program.findProgram((String)string.substring(n));
        }
        if (program == null) {
            return null;
        }
        return new ExternalProgramImageDescriptor(program);
    }

    private void removeEditorFromMapping(HashMap hashMap, IEditorDescriptor iEditorDescriptor) {
        for (FileEditorMapping fileEditorMapping : hashMap.values()) {
            IEditorDescriptor[] iEditorDescriptorArray = fileEditorMapping.getUnfilteredEditors();
            int n = 0;
            while (n < iEditorDescriptorArray.length) {
                if (iEditorDescriptorArray[n] == iEditorDescriptor) {
                    fileEditorMapping.removeEditor((EditorDescriptor)iEditorDescriptorArray[n]);
                    break;
                }
                ++n;
            }
            if (iEditorDescriptorArray.length > 0) continue;
            hashMap.remove(fileEditorMapping);
            break;
        }
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof EditorDescriptor) {
                EditorDescriptor editorDescriptor = (EditorDescriptor)objectArray[n];
                this.sortedEditorsFromPlugins.remove(editorDescriptor);
                this.mapIDtoEditor.values().remove(editorDescriptor);
                this.removeEditorFromMapping(this.typeEditorMappings.defaultMap, editorDescriptor);
                this.removeEditorFromMapping(this.typeEditorMappings.map, editorDescriptor);
                this.removeEditorFromContentTypeMappings(this.contentTypeToEditorMappings, editorDescriptor);
            }
            ++n;
        }
    }

    private void removeEditorFromContentTypeMappings(Map map, IEditorDescriptor iEditorDescriptor) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            IEditorDescriptor[] iEditorDescriptorArray;
            Map.Entry entry = iterator.next();
            IEditorDescriptor[] iEditorDescriptorArray2 = (IEditorDescriptor[])entry.getValue();
            if (iEditorDescriptorArray2 == (iEditorDescriptorArray = this.removeDescriptor(iEditorDescriptorArray2, iEditorDescriptor))) continue;
            if (iEditorDescriptorArray == null) {
                iterator.remove();
                continue;
            }
            entry.setValue(iEditorDescriptorArray);
        }
    }

    private IEditorDescriptor[] removeDescriptor(IEditorDescriptor[] iEditorDescriptorArray, IEditorDescriptor iEditorDescriptor) {
        int n = 0;
        while (n < iEditorDescriptorArray.length) {
            if (iEditorDescriptorArray[n] == iEditorDescriptor) {
                if (iEditorDescriptorArray.length == 1) {
                    return null;
                }
                IEditorDescriptor[] iEditorDescriptorArray2 = new IEditorDescriptor[iEditorDescriptorArray.length - 1];
                if (n == 0) {
                    System.arraycopy(iEditorDescriptorArray, 1, iEditorDescriptorArray2, 0, iEditorDescriptorArray2.length);
                } else {
                    System.arraycopy(iEditorDescriptorArray, 0, iEditorDescriptorArray2, 0, n);
                    if (n < iEditorDescriptorArray2.length) {
                        System.arraycopy(iEditorDescriptorArray, n + 1, iEditorDescriptorArray2, n, iEditorDescriptorArray2.length - n);
                    }
                }
                return iEditorDescriptorArray2;
            }
            ++n;
        }
        return iEditorDescriptorArray;
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        EditorRegistryReader editorRegistryReader = new EditorRegistryReader();
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string = iConfigurationElementArray[n].getAttribute("id");
            if (string == null || this.findEditor(string) == null) {
                editorRegistryReader.readElement(this, iConfigurationElementArray[n]);
            }
            ++n;
        }
    }

    private IExtensionPoint getExtensionPointFilter() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "editors");
    }

    @Override
    public IEditorDescriptor getDefaultEditor(String string, IContentType iContentType) {
        return this.getEditorForContentType(string, iContentType);
    }

    private IEditorDescriptor getEditorForContentType(String string, IContentType iContentType) {
        IEditorDescriptor iEditorDescriptor = null;
        IEditorDescriptor[] iEditorDescriptorArray = this.findRelatedObjects(iContentType, string, this.relatedRegistry);
        if (iEditorDescriptorArray != null && iEditorDescriptorArray.length > 0) {
            iEditorDescriptor = iEditorDescriptorArray[0];
        }
        return iEditorDescriptor;
    }

    @Override
    public IEditorDescriptor[] getEditors(String string, IContentType iContentType) {
        return this.findRelatedObjects(iContentType, string, this.relatedRegistry);
    }

    @Override
    public ImageDescriptor getImageDescriptor(String string, IContentType iContentType) {
        Object object;
        if (string == null) {
            return this.getDefaultImage();
        }
        if (iContentType != null && (object = this.getEditorForContentType(string, iContentType)) != null) {
            ImageDescriptor imageDescriptor = (ImageDescriptor)this.extensionImages.get(object);
            if (imageDescriptor != null) {
                return imageDescriptor;
            }
            imageDescriptor = object.getImageDescriptor();
            this.extensionImages.put(object, imageDescriptor);
            return imageDescriptor;
        }
        object = this.mappingKeyFor(string);
        ImageDescriptor imageDescriptor = (ImageDescriptor)this.extensionImages.get(object);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        FileEditorMapping[] fileEditorMappingArray = this.getMappingForFilename(string);
        int n = 0;
        while (n < 2) {
            if (fileEditorMappingArray[n] != null) {
                String string2 = this.mappingKeyFor(fileEditorMappingArray[n]);
                ImageDescriptor imageDescriptor2 = (ImageDescriptor)this.extensionImages.get(object);
                if (imageDescriptor2 != null) {
                    return imageDescriptor2;
                }
                IEditorDescriptor iEditorDescriptor = fileEditorMappingArray[n].getDefaultEditor();
                if (iEditorDescriptor != null) {
                    imageDescriptor2 = iEditorDescriptor.getImageDescriptor();
                    this.extensionImages.put(string2, imageDescriptor2);
                    return imageDescriptor2;
                }
            }
            ++n;
        }
        imageDescriptor = this.getSystemExternalEditorImageDescriptor(string);
        if (imageDescriptor == null) {
            imageDescriptor = this.getDefaultImage();
        }
        return imageDescriptor;
    }

    private IEditorDescriptor[] findRelatedObjects(IContentType iContentType, String string, RelatedRegistry relatedRegistry) {
        IEditorDescriptor[] iEditorDescriptorArray;
        ArrayList<IEditorDescriptor> arrayList = new ArrayList<IEditorDescriptor>();
        ArrayList<IEditorDescriptor> arrayList2 = new ArrayList<IEditorDescriptor>();
        if (string != null) {
            String string2;
            int n;
            FileEditorMapping fileEditorMapping = this.getMappingFor(string);
            if (fileEditorMapping != null) {
                iEditorDescriptorArray = fileEditorMapping.getDeclaredDefaultEditors();
                n = 0;
                while (n < iEditorDescriptorArray.length) {
                    if (!arrayList.contains(iEditorDescriptorArray[n]) && !WorkbenchActivityHelper.filterItem(iEditorDescriptorArray[n])) {
                        arrayList.add(iEditorDescriptorArray[n]);
                    }
                    ++n;
                }
                arrayList2.addAll(Arrays.asList(fileEditorMapping.getEditors()));
            }
            if ((n = string.lastIndexOf(46)) > -1 && (fileEditorMapping = this.getMappingFor(string2 = "*" + string.substring(n))) != null) {
                iEditorDescriptorArray = fileEditorMapping.getDeclaredDefaultEditors();
                int n2 = 0;
                while (n2 < iEditorDescriptorArray.length) {
                    if (!arrayList.contains(iEditorDescriptorArray[n2]) && !WorkbenchActivityHelper.filterItem(iEditorDescriptorArray[n2])) {
                        arrayList.add(iEditorDescriptorArray[n2]);
                    }
                    ++n2;
                }
                arrayList2.addAll(Arrays.asList(fileEditorMapping.getEditors()));
            }
        }
        if (iContentType != null) {
            iEditorDescriptorArray = relatedRegistry.getRelatedObjects(iContentType);
            int n = 0;
            while (n < iEditorDescriptorArray.length) {
                if (!arrayList.contains(iEditorDescriptorArray[n]) && !WorkbenchActivityHelper.filterItem(iEditorDescriptorArray[n])) {
                    arrayList.add(iEditorDescriptorArray[n]);
                }
                ++n;
            }
        }
        if (iContentType != null) {
            while ((iContentType = iContentType.getBaseType()) != null) {
                iEditorDescriptorArray = relatedRegistry.getRelatedObjects(iContentType);
                int n = 0;
                while (n < iEditorDescriptorArray.length) {
                    if (!arrayList.contains(iEditorDescriptorArray[n]) && !WorkbenchActivityHelper.filterItem(iEditorDescriptorArray[n])) {
                        arrayList.add(iEditorDescriptorArray[n]);
                    }
                    ++n;
                }
            }
        }
        for (IEditorDescriptor iEditorDescriptor : arrayList2) {
            if (arrayList.contains(iEditorDescriptor) || WorkbenchActivityHelper.filterItem(iEditorDescriptor)) continue;
            arrayList.add(iEditorDescriptor);
        }
        return arrayList.toArray(new IEditorDescriptor[arrayList.size()]);
    }

    public IEditorDescriptor[] getEditorsForContentType(IContentType iContentType) {
        ArrayList<IEditorDescriptor> arrayList = new ArrayList<IEditorDescriptor>();
        if (iContentType == null) {
            return new IEditorDescriptor[0];
        }
        IEditorDescriptor[] iEditorDescriptorArray = this.relatedRegistry.getRelatedObjects(iContentType);
        int n = 0;
        while (n < iEditorDescriptorArray.length) {
            if (!arrayList.contains(iEditorDescriptorArray[n]) && !WorkbenchActivityHelper.filterItem(iEditorDescriptorArray[n])) {
                arrayList.add(iEditorDescriptorArray[n]);
            }
            ++n;
        }
        while ((iContentType = iContentType.getBaseType()) != null) {
            iEditorDescriptorArray = this.relatedRegistry.getRelatedObjects(iContentType);
            n = 0;
            while (n < iEditorDescriptorArray.length) {
                if (!arrayList.contains(iEditorDescriptorArray[n]) && !WorkbenchActivityHelper.filterItem(iEditorDescriptorArray[n])) {
                    arrayList.add(iEditorDescriptorArray[n]);
                }
                ++n;
            }
        }
        return arrayList.toArray(new IEditorDescriptor[arrayList.size()]);
    }

    public IFileEditorMapping[] getUnifiedMappings() {
        IFileEditorMapping[] iFileEditorMappingArray = PlatformUI.getWorkbench().getEditorRegistry().getFileEditorMappings();
        ArrayList<IFileEditorMapping> arrayList = new ArrayList<IFileEditorMapping>(Arrays.asList(iFileEditorMappingArray));
        IContentType[] iContentTypeArray = Platform.getContentTypeManager().getAllContentTypes();
        int n = 0;
        while (n < iContentTypeArray.length) {
            IContentType iContentType = iContentTypeArray[n];
            String[] stringArray = iContentType.getFileSpecs(8);
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string = stringArray[n2];
                boolean bl = false;
                for (IFileEditorMapping iFileEditorMapping : arrayList) {
                    if (!"*".equals(iFileEditorMapping.getName()) || !string.equals(iFileEditorMapping.getExtension())) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    MockMapping mockMapping = new MockMapping(iContentType, "*", string);
                    arrayList.add(mockMapping);
                }
                ++n2;
            }
            String[] stringArray2 = iContentType.getFileSpecs(4);
            int n3 = 0;
            while (n3 < stringArray2.length) {
                String string = stringArray2[n3];
                int n4 = string.indexOf(46);
                String string2 = n4 == -1 ? string : string.substring(0, n4);
                String string3 = n4 == -1 ? "" : string.substring(n4 + 1);
                boolean bl = false;
                for (IFileEditorMapping iFileEditorMapping : arrayList) {
                    if (!string2.equals(iFileEditorMapping.getName()) || !string3.equals(iFileEditorMapping.getExtension())) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    MockMapping mockMapping = new MockMapping(iContentType, string2, string3);
                    arrayList.add(mockMapping);
                }
                ++n3;
            }
            ++n;
        }
        return arrayList.toArray(new IFileEditorMapping[arrayList.size()]);
    }

    private static class EditorMap {
        HashMap defaultMap = new HashMap();
        HashMap map = new HashMap();

        private EditorMap() {
        }

        public void putDefault(String string, FileEditorMapping fileEditorMapping) {
            this.defaultMap.put(string, fileEditorMapping);
        }

        public void put(String string, FileEditorMapping fileEditorMapping) {
            Object v = this.defaultMap.get(string);
            if (fileEditorMapping.equals(v)) {
                this.map.remove(string);
            } else {
                this.map.put(string, fileEditorMapping);
            }
        }

        public FileEditorMapping get(String string) {
            Object v = this.map.get(string);
            if (v == null) {
                v = this.defaultMap.get(string);
            }
            return (FileEditorMapping)v;
        }

        public FileEditorMapping[] allMappings() {
            HashMap hashMap = (HashMap)this.defaultMap.clone();
            hashMap.putAll(this.map);
            Collection collection = hashMap.values();
            FileEditorMapping[] fileEditorMappingArray = new FileEditorMapping[collection.size()];
            return collection.toArray(fileEditorMappingArray);
        }

        public FileEditorMapping[] userMappings() {
            Collection collection = this.map.values();
            FileEditorMapping[] fileEditorMappingArray = new FileEditorMapping[collection.size()];
            return collection.toArray(fileEditorMappingArray);
        }
    }

    class RelatedRegistry {
        RelatedRegistry() {
        }

        public IEditorDescriptor[] getRelatedObjects(IContentType iContentType) {
            Object[] objectArray = (IEditorDescriptor[])EditorRegistry.this.contentTypeToEditorMappings.get(iContentType);
            if (objectArray == null) {
                return EMPTY;
            }
            return (IEditorDescriptor[])WorkbenchActivityHelper.restrictArray(objectArray);
        }

        public IEditorDescriptor[] getRelatedObjects(String string) {
            FileEditorMapping fileEditorMapping = EditorRegistry.this.getMappingFor(string);
            if (fileEditorMapping == null) {
                return EMPTY;
            }
            return (IEditorDescriptor[])WorkbenchActivityHelper.restrictArray(fileEditorMapping.getEditors());
        }
    }
}

