/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.io.File;
import java.io.Serializable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.ProgramImageDescriptor;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.internal.tweaklets.InterceptContributions;
import org.eclipse.ui.internal.tweaklets.Tweaklets;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class EditorDescriptor
implements IEditorDescriptor,
Serializable,
IPluginContribution {
    private static final long serialVersionUID = 3905241225668998961L;
    public static final int OPEN_INTERNAL = 1;
    public static final int OPEN_INPLACE = 2;
    public static final int OPEN_EXTERNAL = 4;
    private String editorName;
    private String imageFilename;
    private transient ImageDescriptor imageDesc;
    private transient Object imageDescLock = new Object();
    private boolean testImage = true;
    private String className;
    private String launcherName;
    private String fileName;
    private String id = "";
    private boolean matchingStrategyChecked = false;
    private IEditorMatchingStrategy matchingStrategy;
    private Program program;
    private String pluginIdentifier;
    private int openMode = 0;
    private transient IConfigurationElement configurationElement;

    EditorDescriptor(String string, IConfigurationElement iConfigurationElement) {
        this.setID(string);
        this.setConfigurationElement(iConfigurationElement);
    }

    EditorDescriptor() {
    }

    public static EditorDescriptor createForProgram(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        EditorDescriptor editorDescriptor = new EditorDescriptor();
        editorDescriptor.setFileName(string);
        editorDescriptor.setID(string);
        editorDescriptor.setOpenMode(4);
        int n = string.lastIndexOf(File.separator);
        String string2 = n != -1 ? string.substring(n + 1) : string;
        int n2 = string2.lastIndexOf(46);
        if (n2 != -1) {
            string2 = string2.substring(0, n2);
        }
        editorDescriptor.setName(string2);
        ProgramImageDescriptor programImageDescriptor = new ProgramImageDescriptor(string, 0);
        editorDescriptor.setImageDescriptor(programImageDescriptor);
        return editorDescriptor;
    }

    private static Program findProgram(String string) {
        Program[] programArray = Program.getPrograms();
        int n = 0;
        while (n < programArray.length) {
            if (programArray[n].getName().equals(string)) {
                return programArray[n];
            }
            ++n;
        }
        return null;
    }

    public IEditorActionBarContributor createActionBarContributor() {
        if (this.configurationElement == null) {
            return null;
        }
        String string = this.configurationElement.getAttribute("contributorClass");
        if (string == null) {
            return null;
        }
        IEditorActionBarContributor iEditorActionBarContributor = null;
        try {
            iEditorActionBarContributor = (IEditorActionBarContributor)WorkbenchPlugin.createExtension(this.configurationElement, "contributorClass");
        }
        catch (CoreException coreException) {
            WorkbenchPlugin.log("Unable to create editor contributor: " + this.id, coreException.getStatus());
        }
        return iEditorActionBarContributor;
    }

    public String getClassName() {
        if (this.configurationElement == null) {
            return this.className;
        }
        return RegistryReader.getClassValue(this.configurationElement, "class");
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public IEditorPart createEditor() throws CoreException {
        Object object = WorkbenchPlugin.createExtension(this.getConfigurationElement(), "class");
        return ((InterceptContributions)Tweaklets.get(InterceptContributions.KEY)).tweakEditor(object);
    }

    public String getFileName() {
        if (this.program == null) {
            if (this.configurationElement == null) {
                return this.fileName;
            }
            return this.configurationElement.getAttribute("command");
        }
        return this.program.getName();
    }

    @Override
    public String getId() {
        if (this.program == null) {
            if (this.configurationElement == null) {
                return Util.safeString(this.id);
            }
            return Util.safeString(this.configurationElement.getAttribute("id"));
        }
        return Util.safeString(this.program.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageDescriptor getImageDescriptor() {
        Object object;
        ImageDescriptor imageDescriptor = null;
        Object object2 = this.imageDescLock;
        synchronized (object2) {
            if (!this.testImage) {
                return this.imageDesc;
            }
            if (this.imageDesc == null) {
                object = this.getImageFilename();
                String string = this.getFileName();
                if (object != null && this.configurationElement != null) {
                    imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(this.configurationElement.getNamespaceIdentifier(), (String)object);
                } else if (string != null) {
                    imageDescriptor = WorkbenchImages.getImageDescriptorFromProgram(string, 0);
                }
            } else {
                imageDescriptor = this.imageDesc;
            }
            if (imageDescriptor == null) {
                this.imageDesc = WorkbenchImages.getImageDescriptor("IMG_OBJ_FILE");
                this.testImage = false;
                return this.imageDesc;
            }
        }
        object2 = imageDescriptor.createImage(false);
        if (object2 == null) {
            imageDescriptor = WorkbenchImages.getImageDescriptor("IMG_OBJ_FILE");
        } else {
            object2.dispose();
        }
        object = this.imageDescLock;
        synchronized (object) {
            if (!this.testImage) {
                return this.imageDesc;
            }
            this.imageDesc = imageDescriptor;
            this.testImage = false;
            return this.imageDesc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setImageDescriptor(ImageDescriptor imageDescriptor) {
        Object object = this.imageDescLock;
        synchronized (object) {
            this.imageDesc = imageDescriptor;
            this.testImage = true;
        }
    }

    public String getImageFilename() {
        if (this.configurationElement == null) {
            return this.imageFilename;
        }
        return this.configurationElement.getAttribute("icon");
    }

    @Override
    public String getLabel() {
        if (this.program == null) {
            if (this.configurationElement == null) {
                return this.editorName;
            }
            return this.configurationElement.getAttribute("name");
        }
        return this.program.getName();
    }

    public String getLauncher() {
        if (this.configurationElement == null) {
            return this.launcherName;
        }
        return this.configurationElement.getAttribute("launcher");
    }

    public String getPluginID() {
        if (this.configurationElement != null) {
            return this.configurationElement.getNamespace();
        }
        return this.pluginIdentifier;
    }

    public Program getProgram() {
        return this.program;
    }

    @Override
    public boolean isInternal() {
        return this.getOpenMode() == 1;
    }

    @Override
    public boolean isOpenInPlace() {
        return this.getOpenMode() == 2;
    }

    @Override
    public boolean isOpenExternal() {
        return this.getOpenMode() == 4;
    }

    protected boolean loadValues(IMemento iMemento) {
        this.editorName = iMemento.getString("label");
        this.imageFilename = iMemento.getString("image");
        this.className = iMemento.getString("class");
        this.launcherName = iMemento.getString("launcher");
        this.fileName = iMemento.getString("file");
        this.id = Util.safeString(iMemento.getString("id"));
        this.pluginIdentifier = iMemento.getString("plugin");
        Integer n = iMemento.getInteger("openMode");
        if (n != null) {
            this.openMode = n;
        } else {
            boolean bl = new Boolean(iMemento.getString("internal"));
            boolean bl2 = new Boolean(iMemento.getString("open_in_place"));
            this.openMode = bl ? 1 : (bl2 ? 2 : 4);
        }
        if (this.openMode != 4 && this.openMode != 1 && this.openMode != 2) {
            WorkbenchPlugin.log("Ignoring editor descriptor with invalid openMode: " + this);
            return false;
        }
        String string = iMemento.getString("program_name");
        if (string != null) {
            this.program = EditorDescriptor.findProgram(string);
        }
        return true;
    }

    protected void saveValues(IMemento iMemento) {
        iMemento.putString("label", this.getLabel());
        iMemento.putString("image", this.getImageFilename());
        iMemento.putString("class", this.getClassName());
        iMemento.putString("launcher", this.getLauncher());
        iMemento.putString("file", this.getFileName());
        iMemento.putString("id", this.getId());
        iMemento.putString("plugin", this.getPluginId());
        iMemento.putInteger("openMode", this.getOpenMode());
        iMemento.putString("internal", String.valueOf(this.isInternal()));
        iMemento.putString("open_in_place", String.valueOf(this.isOpenInPlace()));
        if (this.program != null) {
            iMemento.putString("program_name", this.program.getName());
        }
    }

    private int getOpenMode() {
        if (this.configurationElement == null) {
            return this.openMode;
        }
        if (this.getLauncher() != null) {
            return 4;
        }
        if (this.getFileName() != null) {
            return 4;
        }
        if (this.getPluginId() != null) {
            return 1;
        }
        return 0;
    }

    void setClassName(String string) {
        this.className = string;
    }

    void setConfigurationElement(IConfigurationElement iConfigurationElement) {
        this.configurationElement = iConfigurationElement;
    }

    void setFileName(String string) {
        this.fileName = string;
    }

    void setID(String string) {
        Assert.isNotNull((Object)string);
        this.id = string;
    }

    void setImageFilename(String string) {
        this.imageFilename = string;
    }

    void setLauncher(String string) {
        this.launcherName = string;
    }

    void setName(String string) {
        this.editorName = string;
    }

    public void setOpenMode(int n) {
        this.openMode = n;
    }

    void setPluginIdentifier(String string) {
        this.pluginIdentifier = string;
    }

    void setProgram(Program program) {
        this.program = program;
        if (this.editorName == null) {
            this.setName(program.getName());
        }
    }

    public String toString() {
        return "EditorDescriptor(id=" + this.getId() + ", label=" + this.getLabel() + ")";
    }

    @Override
    public String getLocalId() {
        return this.getId();
    }

    @Override
    public String getPluginId() {
        return this.getPluginID();
    }

    @Override
    public IEditorMatchingStrategy getEditorMatchingStrategy() {
        if (this.matchingStrategy == null && !this.matchingStrategyChecked) {
            this.matchingStrategyChecked = true;
            if (this.program == null && this.configurationElement != null && this.configurationElement.getAttribute("matchingStrategy") != null) {
                try {
                    this.matchingStrategy = (IEditorMatchingStrategy)WorkbenchPlugin.createExtension(this.configurationElement, "matchingStrategy");
                }
                catch (CoreException coreException) {
                    WorkbenchPlugin.log("Error creating editor management policy for editor id " + this.getId(), coreException);
                }
            }
        }
        return this.matchingStrategy;
    }
}

