/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class Category
implements IWorkbenchAdapter,
IPluginContribution,
IAdaptable {
    public static final String MISC_NAME = WorkbenchMessages.ICategory_other;
    public static final String MISC_ID = "org.eclipse.ui.internal.otherCategory";
    private String id;
    private String name;
    private String[] parentPath;
    private ArrayList elements;
    private IConfigurationElement configurationElement;
    private String pluginId;

    public Category() {
        this.id = MISC_ID;
        this.name = MISC_NAME;
        this.pluginId = MISC_ID;
    }

    public Category(String string, String string2) {
        this.id = string;
        this.name = string2;
    }

    public Category(IConfigurationElement iConfigurationElement) throws WorkbenchException {
        this.id = iConfigurationElement.getAttribute("id");
        this.configurationElement = iConfigurationElement;
        if (this.id == null || this.getLabel() == null) {
            throw new WorkbenchException("Invalid category: " + this.id);
        }
    }

    public void addElement(Object object) {
        if (this.elements == null) {
            this.elements = new ArrayList(5);
        }
        this.elements.add(object);
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IWorkbenchAdapter.class) {
            return this;
        }
        if (clazz == IConfigurationElement.class) {
            return this.configurationElement;
        }
        return null;
    }

    @Override
    public Object[] getChildren(Object object) {
        return this.getElements().toArray();
    }

    @Override
    public ImageDescriptor getImageDescriptor(Object object) {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_FOLDER");
    }

    @Override
    public String getLabel(Object object) {
        return this.getLabel();
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.configurationElement == null ? this.name : this.configurationElement.getAttribute("name");
    }

    public String[] getParentPath() {
        if (this.parentPath != null) {
            return this.parentPath;
        }
        String string = this.getRawParentPath();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            this.parentPath = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.parentPath[n] = stringTokenizer.nextToken();
                ++n;
            }
        }
        return this.parentPath;
    }

    public String getRawParentPath() {
        return this.configurationElement == null ? null : this.configurationElement.getAttribute("parentCategory");
    }

    public String getRootPath() {
        String[] stringArray = this.getParentPath();
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return this.id;
    }

    public ArrayList getElements() {
        return this.elements;
    }

    public boolean hasElement(Object object) {
        if (this.elements == null) {
            return false;
        }
        if (this.elements.isEmpty()) {
            return false;
        }
        return this.elements.contains(object);
    }

    public boolean hasElements() {
        if (this.elements != null) {
            return !this.elements.isEmpty();
        }
        return false;
    }

    @Override
    public Object getParent(Object object) {
        return null;
    }

    @Override
    public String getLocalId() {
        return this.id;
    }

    @Override
    public String getPluginId() {
        return this.configurationElement == null ? this.pluginId : this.configurationElement.getNamespace();
    }

    public void clear() {
        if (this.elements != null) {
            this.elements.clear();
        }
    }
}

