/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.registry.RegistryReader;

public abstract class CategorizedPageRegistryReader
extends RegistryReader {
    public static final String ATT_CATEGORY = "category";
    static final String PREFERENCE_SEPARATOR = "/";
    List topLevelNodes;

    void processNodes() {
        boolean bl;
        ArrayList<CategoryNode> arrayList;
        this.topLevelNodes = new ArrayList();
        CategoryNode[] categoryNodeArray = this.createCategoryNodes(this.getNodes());
        do {
            bl = false;
            arrayList = new ArrayList<CategoryNode>();
            int n = 0;
            while (n < categoryNodeArray.length) {
                CategoryNode categoryNode = categoryNodeArray[n];
                Object object = categoryNode.getNode();
                String string = this.getCategory(object);
                if (string == null) {
                    this.topLevelNodes.add(object);
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, PREFERENCE_SEPARATOR);
                    Object object2 = null;
                    while (stringTokenizer.hasMoreElements()) {
                        String string2 = stringTokenizer.nextToken();
                        Object object3 = null;
                        object3 = object2 == null ? this.findNode(string2) : this.findNode(object2, string2);
                        if (object3 == null) {
                            object2 = null;
                            break;
                        }
                        object2 = object3;
                    }
                    if (object2 != null) {
                        bl = true;
                        this.add(object2, object);
                    } else {
                        arrayList.add(categoryNode);
                    }
                }
                ++n;
            }
        } while ((categoryNodeArray = arrayList.toArray(new CategoryNode[arrayList.size()])).length > 0 && bl);
        int n = 0;
        while (n < categoryNodeArray.length) {
            CategoryNode categoryNode = categoryNodeArray[n];
            WorkbenchPlugin.log(StatusUtil.newStatus(2, this.invalidCategoryNodeMessage(categoryNode), null));
            this.topLevelNodes.add(categoryNode.getNode());
            ++n;
        }
    }

    protected abstract String invalidCategoryNodeMessage(CategoryNode var1);

    abstract String getCategory(Object var1);

    abstract void add(Object var1, Object var2);

    abstract Collection getNodes();

    CategoryNode[] createCategoryNodes(Collection collection) {
        ArrayList<CategoryNode> arrayList = new ArrayList<CategoryNode>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.createCategoryNode(this, iterator.next()));
        }
        return arrayList.toArray(new CategoryNode[arrayList.size()]);
    }

    abstract CategoryNode createCategoryNode(CategorizedPageRegistryReader var1, Object var2);

    abstract Object findNode(String var1);

    abstract Object findNode(Object var1, String var2);

    abstract class CategoryNode {
        private final CategorizedPageRegistryReader reader;
        private String flatCategory;

        public CategoryNode(CategorizedPageRegistryReader categorizedPageRegistryReader2) {
            this.reader = categorizedPageRegistryReader2;
        }

        public String getFlatCategory() {
            if (this.flatCategory == null) {
                this.initialize();
                if (this.flatCategory == null) {
                    this.flatCategory = this.getLabelText();
                }
            }
            return this.flatCategory;
        }

        abstract String getLabelText();

        private void initialize() {
            String string = this.reader.getCategory(this.getNode());
            if (string == null) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, CategorizedPageRegistryReader.PREFERENCE_SEPARATOR);
            Object object = null;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                object = this.reader.findNode(string2);
                if (object == null) {
                    return;
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(CategorizedPageRegistryReader.PREFERENCE_SEPARATOR);
                }
                stringBuffer.append(this.getLabelText(object));
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(CategorizedPageRegistryReader.PREFERENCE_SEPARATOR);
            }
            stringBuffer.append(this.getLabelText());
            this.flatCategory = stringBuffer.toString();
        }

        abstract String getLabelText(Object var1);

        abstract Object getNode();
    }
}

