/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.ActionSetDescriptor;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;

public class ActionSetRegistry
implements IExtensionChangeHandler {
    private ArrayList children = new ArrayList();
    private Map mapPartToActionSetIds = new HashMap();
    private Map mapPartToActionSets = new HashMap();
    private IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);

    public ActionSetRegistry() {
        PlatformUI.getWorkbench().getExtensionTracker().registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint[])new IExtensionPoint[]{this.getActionSetExtensionPoint(), this.getActionSetPartAssociationExtensionPoint()}));
        this.readFromRegistry();
    }

    private IExtensionPoint getActionSetPartAssociationExtensionPoint() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "actionSetPartAssociations");
    }

    private IExtensionPoint getActionSetExtensionPoint() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "actionSets");
    }

    private void addActionSet(ActionSetDescriptor actionSetDescriptor) {
        this.children.add(actionSetDescriptor);
        Context context = this.contextService.getContext(actionSetDescriptor.getId());
        if (!context.isDefined()) {
            context.define(actionSetDescriptor.getLabel(), actionSetDescriptor.getDescription(), "org.eclipse.ui.contexts.actionSet");
        }
    }

    private void removeActionSet(IActionSetDescriptor iActionSetDescriptor) {
        Context context = this.contextService.getContext(iActionSetDescriptor.getId());
        if (context.isDefined()) {
            context.undefine();
        }
        this.children.remove(iActionSetDescriptor);
    }

    private Object addAssociation(String string, String string2) {
        ArrayList<String> arrayList = (ArrayList<String>)this.mapPartToActionSetIds.get(string2);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            this.mapPartToActionSetIds.put(string2, arrayList);
        }
        arrayList.add(string);
        ActionSetPartAssociation actionSetPartAssociation = new ActionSetPartAssociation(string2, string);
        return actionSetPartAssociation;
    }

    public IActionSetDescriptor findActionSet(String string) {
        for (IActionSetDescriptor iActionSetDescriptor : this.children) {
            if (!iActionSetDescriptor.getId().equals(string)) continue;
            return iActionSetDescriptor;
        }
        return null;
    }

    public IActionSetDescriptor[] getActionSets() {
        return this.children.toArray(new IActionSetDescriptor[this.children.size()]);
    }

    public IActionSetDescriptor[] getActionSetsFor(String string) {
        ArrayList<IActionSetDescriptor> arrayList = (ArrayList<IActionSetDescriptor>)this.mapPartToActionSets.get(string);
        if (arrayList != null) {
            return arrayList.toArray(new IActionSetDescriptor[arrayList.size()]);
        }
        ArrayList arrayList2 = (ArrayList)this.mapPartToActionSetIds.get(string);
        if (arrayList2 == null) {
            return new IActionSetDescriptor[0];
        }
        arrayList = new ArrayList<IActionSetDescriptor>(arrayList2.size());
        for (String string2 : arrayList2) {
            IActionSetDescriptor iActionSetDescriptor = this.findActionSet(string2);
            if (iActionSetDescriptor != null) {
                arrayList.add(iActionSetDescriptor);
                continue;
            }
            WorkbenchPlugin.log("Unable to associate action set with part: " + string + ". Action set " + string2 + " not found.");
        }
        this.mapPartToActionSets.put(string, arrayList);
        return arrayList.toArray(new IActionSetDescriptor[arrayList.size()]);
    }

    private void readFromRegistry() {
        IExtension[] iExtensionArray = this.getActionSetExtensionPoint().getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            this.addActionSets(PlatformUI.getWorkbench().getExtensionTracker(), iExtensionArray[n]);
            ++n;
        }
        iExtensionArray = this.getActionSetPartAssociationExtensionPoint().getExtensions();
        n = 0;
        while (n < iExtensionArray.length) {
            this.addActionSetPartAssociations(PlatformUI.getWorkbench().getExtensionTracker(), iExtensionArray[n]);
            ++n;
        }
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        String string = iExtension.getExtensionPointUniqueIdentifier();
        if (string.equals(this.getActionSetExtensionPoint().getUniqueIdentifier())) {
            this.addActionSets(iExtensionTracker, iExtension);
        } else if (string.equals(this.getActionSetPartAssociationExtensionPoint().getUniqueIdentifier())) {
            this.addActionSetPartAssociations(iExtensionTracker, iExtension);
        }
    }

    private void addActionSetPartAssociations(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.getName().equals("actionSetPartAssociation")) {
                String string = iConfigurationElement.getAttribute("targetID");
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElement.getChildren();
                int n2 = 0;
                while (n2 < iConfigurationElementArray2.length) {
                    IConfigurationElement iConfigurationElement2 = iConfigurationElementArray2[n2];
                    if (iConfigurationElement2.getName().equals("part")) {
                        Object object;
                        String string2 = iConfigurationElement2.getAttribute("id");
                        if (string2 != null && (object = this.addAssociation(string, string2)) != null) {
                            iExtensionTracker.registerObject(iExtension, object, 0);
                        }
                    } else {
                        WorkbenchPlugin.log("Unable to process element: " + iConfigurationElement2.getName() + " in action set part associations extension: " + iExtension.getUniqueIdentifier());
                    }
                    ++n2;
                }
            }
            ++n;
        }
        this.mapPartToActionSets.clear();
    }

    private void addActionSets(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.getName().equals("actionSet")) {
                try {
                    ActionSetDescriptor actionSetDescriptor = new ActionSetDescriptor(iConfigurationElement);
                    this.addActionSet(actionSetDescriptor);
                    iExtensionTracker.registerObject(iExtension, (Object)actionSetDescriptor, 2);
                }
                catch (CoreException coreException) {
                    WorkbenchPlugin.log("Unable to create action set descriptor.", coreException.getStatus());
                }
            }
            ++n;
        }
        this.mapPartToActionSets.clear();
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        String string = iExtension.getExtensionPointUniqueIdentifier();
        if (string.equals(this.getActionSetExtensionPoint().getUniqueIdentifier())) {
            this.removeActionSets(objectArray);
        } else if (string.equals(this.getActionSetPartAssociationExtensionPoint().getUniqueIdentifier())) {
            this.removeActionSetPartAssociations(objectArray);
        }
    }

    private void removeActionSetPartAssociations(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof ActionSetPartAssociation) {
                ActionSetPartAssociation actionSetPartAssociation = (ActionSetPartAssociation)object;
                String string = actionSetPartAssociation.actionSetId;
                ArrayList arrayList = (ArrayList)this.mapPartToActionSetIds.get(actionSetPartAssociation.partId);
                if (arrayList == null) {
                    return;
                }
                arrayList.remove(string);
                if (arrayList.isEmpty()) {
                    this.mapPartToActionSetIds.remove(actionSetPartAssociation.partId);
                }
            }
            ++n;
        }
        this.mapPartToActionSets.clear();
    }

    private void removeActionSets(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof IActionSetDescriptor) {
                IActionSetDescriptor iActionSetDescriptor = (IActionSetDescriptor)object;
                this.removeActionSet(iActionSetDescriptor);
                Iterator iterator = this.mapPartToActionSetIds.values().iterator();
                while (iterator.hasNext()) {
                    ArrayList arrayList = (ArrayList)iterator.next();
                    arrayList.remove(iActionSetDescriptor.getId());
                    if (!arrayList.isEmpty()) continue;
                    iterator.remove();
                }
            }
            ++n;
        }
        this.mapPartToActionSets.clear();
    }

    private class ActionSetPartAssociation {
        String partId;
        String actionSetId;

        public ActionSetPartAssociation(String string, String string2) {
            this.partId = string;
            this.actionSetId = string2;
        }
    }
}

