/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.PluginActionSet;
import org.eclipse.ui.internal.PluginActionSetReader;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.IActionSet;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ActionSetDescriptor
implements IActionSetDescriptor,
IAdaptable,
IWorkbenchAdapter,
IPluginContribution {
    private static final Object[] NO_CHILDREN = new Object[0];
    private static final String INITIALLY_HIDDEN_PREF_ID_PREFIX = "actionSet.initiallyHidden.";
    private String id;
    private String pluginId;
    private String label;
    private boolean visible;
    private String description;
    private IConfigurationElement configElement;

    public ActionSetDescriptor(IConfigurationElement iConfigurationElement) throws CoreException {
        this.configElement = iConfigurationElement;
        this.id = iConfigurationElement.getAttribute("id");
        this.pluginId = iConfigurationElement.getNamespace();
        this.label = iConfigurationElement.getAttribute("label");
        this.description = iConfigurationElement.getAttribute("description");
        String string = iConfigurationElement.getAttribute("visible");
        if (string != null && string.equals("true")) {
            this.visible = true;
        }
        if (this.label == null) {
            throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, "Invalid extension (missing label): " + this.id, null));
        }
    }

    @Override
    public IActionSet createActionSet() throws CoreException {
        return new PluginActionSet(this);
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IWorkbenchAdapter.class) {
            return this;
        }
        return null;
    }

    @Override
    public Object[] getChildren(Object object) {
        if (object == this) {
            return new PluginActionSetReader().readActionDescriptors(this);
        }
        return NO_CHILDREN;
    }

    @Override
    public IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getLabel(Object object) {
        if (object == this) {
            return this.getLabel();
        }
        return "Unknown Label";
    }

    @Override
    public boolean isInitiallyVisible() {
        String string;
        if (this.id == null) {
            return this.visible;
        }
        Preferences preferences = WorkbenchPlugin.getDefault().getPluginPreferences();
        if (preferences.getBoolean(string = INITIALLY_HIDDEN_PREF_ID_PREFIX + this.getId())) {
            return false;
        }
        return this.visible;
    }

    @Override
    public void setInitiallyVisible(boolean bl) {
        if (this.id == null) {
            return;
        }
        Preferences preferences = WorkbenchPlugin.getDefault().getPluginPreferences();
        String string = INITIALLY_HIDDEN_PREF_ID_PREFIX + this.getId();
        preferences.setValue(string, !bl);
    }

    @Override
    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    @Override
    public Object getParent(Object object) {
        return null;
    }

    @Override
    public String getLocalId() {
        return this.id;
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ActionSetDescriptor)) {
            return false;
        }
        ActionSetDescriptor actionSetDescriptor = (ActionSetDescriptor)object;
        return this.id.equals(actionSetDescriptor.id) && actionSetDescriptor.pluginId.equals(this.pluginId);
    }

    public int hashCode() {
        return this.id.hashCode() + this.pluginId.hashCode();
    }
}

