/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.internal.quickaccess.WizardElement;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class WizardProvider
extends QuickAccessProvider {
    private QuickAccessElement[] cachedElements;
    private Map idToElement = new HashMap();

    @Override
    public QuickAccessElement getElementForId(String string) {
        this.getElements();
        return (WizardElement)this.idToElement.get(string);
    }

    @Override
    public QuickAccessElement[] getElements() {
        if (this.cachedElements == null) {
            IWizardCategory iWizardCategory = WorkbenchPlugin.getDefault().getNewWizardRegistry().getRootCategory();
            ArrayList arrayList = new ArrayList();
            this.collectWizards(iWizardCategory, arrayList);
            IWizardDescriptor[] iWizardDescriptorArray = arrayList.toArray(new IWizardDescriptor[arrayList.size()]);
            int n = 0;
            while (n < iWizardDescriptorArray.length) {
                if (!WorkbenchActivityHelper.filterItem(iWizardDescriptorArray[n])) {
                    WizardElement wizardElement = new WizardElement(iWizardDescriptorArray[n], this);
                    this.idToElement.put(wizardElement.getId(), wizardElement);
                }
                ++n;
            }
            this.cachedElements = this.idToElement.values().toArray(new QuickAccessElement[this.idToElement.size()]);
        }
        return this.cachedElements;
    }

    private void collectWizards(IWizardCategory iWizardCategory, List list) {
        list.addAll(Arrays.asList(iWizardCategory.getWizards()));
        IWizardCategory[] iWizardCategoryArray = iWizardCategory.getCategories();
        int n = 0;
        while (n < iWizardCategoryArray.length) {
            this.collectWizards(iWizardCategoryArray[n], list);
            ++n;
        }
    }

    @Override
    public String getId() {
        return "org.eclipse.ui.wizards";
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_NODE");
    }

    @Override
    public String getName() {
        return QuickAccessMessages.QuickAccess_New;
    }
}

