/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.actions.NewWizardShortcutAction;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.WizardProvider;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class WizardElement
extends QuickAccessElement {
    private IWizardDescriptor wizardDescriptor;

    WizardElement(IWizardDescriptor iWizardDescriptor, WizardProvider wizardProvider) {
        super(wizardProvider);
        this.wizardDescriptor = iWizardDescriptor;
    }

    @Override
    public void execute() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            NewWizardShortcutAction newWizardShortcutAction = new NewWizardShortcutAction(iWorkbenchWindow, this.wizardDescriptor);
            newWizardShortcutAction.run();
        }
    }

    @Override
    public String getId() {
        return this.wizardDescriptor.getId();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.wizardDescriptor.getImageDescriptor();
    }

    @Override
    public String getLabel() {
        return String.valueOf(this.wizardDescriptor.getLabel()) + " - " + this.wizardDescriptor.getDescription();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.wizardDescriptor == null ? 0 : this.wizardDescriptor.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WizardElement wizardElement = (WizardElement)object;
        return !(this.wizardDescriptor == null ? wizardElement.wizardDescriptor != null : !this.wizardDescriptor.equals(wizardElement.wizardDescriptor));
    }
}

