/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.internal.quickaccess.ViewElement;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ViewProvider
extends QuickAccessProvider {
    private QuickAccessElement[] cachedElements;
    private Map idToElement = new HashMap();
    private Collection multiInstanceViewIds = new HashSet(0);

    @Override
    public String getId() {
        return "org.eclipse.ui.views";
    }

    @Override
    public QuickAccessElement getElementForId(String string) {
        this.getElements();
        return (ViewElement)this.idToElement.get(string);
    }

    @Override
    public QuickAccessElement[] getElements() {
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() == null) {
            this.cachedElements = null;
            return new QuickAccessElement[0];
        }
        if (this.cachedElements == null) {
            IViewDescriptor[] iViewDescriptorArray = PlatformUI.getWorkbench().getViewRegistry().getViews();
            HashSet hashSet = new HashSet(iViewDescriptorArray.length);
            int n = 0;
            while (n < iViewDescriptorArray.length) {
                if (!WorkbenchActivityHelper.filterItem(iViewDescriptorArray[n])) {
                    this.addElement(iViewDescriptorArray[n], hashSet, null, null);
                }
                ++n;
            }
            this.addOpenViews(hashSet);
            this.markMultiInstance(hashSet);
            this.cachedElements = hashSet.toArray(new QuickAccessElement[hashSet.size()]);
        }
        return this.cachedElements;
    }

    private void addElement(IViewDescriptor iViewDescriptor, Collection collection, String string, String string2) {
        ViewElement viewElement = new ViewElement(iViewDescriptor, this);
        viewElement.setSecondaryId(string);
        viewElement.setContentDescription(string2);
        boolean bl = collection.add(viewElement);
        if (bl) {
            this.idToElement.put(viewElement.getId(), viewElement);
        } else {
            this.multiInstanceViewIds.add(iViewDescriptor.getId());
        }
    }

    public void addOpenViews(Collection collection) {
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewRegistry iViewRegistry = PlatformUI.getWorkbench().getViewRegistry();
        IViewReference[] iViewReferenceArray = iWorkbenchPage.getViewReferences();
        int n = 0;
        while (n < iViewReferenceArray.length) {
            IViewDescriptor iViewDescriptor = iViewRegistry.find(iViewReferenceArray[n].getId());
            this.addElement(iViewDescriptor, collection, iViewReferenceArray[n].getSecondaryId(), iViewReferenceArray[n].getContentDescription());
            ++n;
        }
    }

    protected void markMultiInstance(Collection collection) {
        for (String string : this.multiInstanceViewIds) {
            ViewElement viewElement = null;
            for (ViewElement viewElement2 : collection) {
                if (!viewElement2.getPrimaryId().equals(string)) continue;
                if (viewElement == null) {
                    viewElement = viewElement2;
                    continue;
                }
                viewElement.setMultiInstance(true);
                viewElement2.setMultiInstance(true);
            }
        }
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor("IMG_VIEW_DEFAULTVIEW_MISC");
    }

    @Override
    public String getName() {
        return QuickAccessMessages.QuickAccess_Views;
    }
}

