/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.ViewProvider;
import org.eclipse.ui.views.IViewCategory;
import org.eclipse.ui.views.IViewDescriptor;

public class ViewElement
extends QuickAccessElement {
    private final IViewDescriptor viewDescriptor;
    private String secondaryId;
    private boolean multiInstance;
    private String contentDescription;
    private String category;

    ViewElement(IViewDescriptor iViewDescriptor, ViewProvider viewProvider) {
        super(viewProvider);
        this.viewDescriptor = iViewDescriptor;
        IViewCategory[] iViewCategoryArray = PlatformUI.getWorkbench().getViewRegistry().getCategories();
        int n = 0;
        while (n < iViewCategoryArray.length) {
            IViewDescriptor[] iViewDescriptorArray = iViewCategoryArray[n].getViews();
            int n2 = 0;
            while (n2 < iViewDescriptorArray.length) {
                if (iViewDescriptorArray[n2] == iViewDescriptor) {
                    this.category = iViewCategoryArray[n].getLabel();
                    return;
                }
                ++n2;
            }
            ++n;
        }
    }

    public String getPrimaryId() {
        return this.viewDescriptor.getId();
    }

    public void setSecondaryId(String string) {
        this.secondaryId = string;
    }

    public void setMultiInstance(boolean bl) {
        this.multiInstance = bl;
    }

    public void setContentDescription(String string) {
        this.contentDescription = string;
    }

    public boolean isMultiInstance() {
        return this.multiInstance;
    }

    @Override
    public void execute() {
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage != null) {
            try {
                iWorkbenchPage.showView(this.viewDescriptor.getId(), this.secondaryId, 1);
            }
            catch (PartInitException partInitException) {}
        }
    }

    @Override
    public String getId() {
        if (this.secondaryId == null) {
            return this.viewDescriptor.getId();
        }
        return String.valueOf(this.viewDescriptor.getId()) + ':' + this.secondaryId;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.viewDescriptor.getImageDescriptor();
    }

    @Override
    public String getLabel() {
        String string = this.viewDescriptor.getLabel();
        if (this.isMultiInstance() && this.contentDescription != null) {
            string = String.valueOf(string) + " (" + this.contentDescription + ')';
        }
        if (this.category != null) {
            string = String.valueOf(string) + " - " + this.category;
        }
        return string;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.secondaryId == null ? 0 : this.secondaryId.hashCode());
        n = 31 * n + (this.viewDescriptor == null ? 0 : this.viewDescriptor.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ViewElement viewElement = (ViewElement)object;
        if (this.secondaryId == null ? viewElement.secondaryId != null : !this.secondaryId.equals(viewElement.secondaryId)) {
            return false;
        }
        return !(this.viewDescriptor == null ? viewElement.viewDescriptor != null : !this.viewDescriptor.equals(viewElement.viewDescriptor));
    }
}

