/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.quickaccess.CommandElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;

class QuickAccessEntry {
    boolean firstInCategory;
    boolean lastInCategory;
    QuickAccessElement element;
    QuickAccessProvider provider;
    int[][] elementMatchRegions;
    int[][] providerMatchRegions;

    QuickAccessEntry(QuickAccessElement quickAccessElement, QuickAccessProvider quickAccessProvider, int[][] nArray, int[][] nArray2) {
        this.element = quickAccessElement;
        this.provider = quickAccessProvider;
        this.elementMatchRegions = nArray;
        this.providerMatchRegions = nArray2;
    }

    Image getImage(QuickAccessElement quickAccessElement, ResourceManager resourceManager) {
        Image image = this.findOrCreateImage(quickAccessElement.getImageDescriptor(), resourceManager);
        if (image == null) {
            image = WorkbenchImages.getImage("IMG_OBJ_ELEMENT");
        }
        return image;
    }

    private Image findOrCreateImage(ImageDescriptor imageDescriptor, ResourceManager resourceManager) {
        if (imageDescriptor == null) {
            return null;
        }
        Image image = (Image)resourceManager.find((DeviceResourceDescriptor)imageDescriptor);
        if (image == null) {
            try {
                image = resourceManager.createImage(imageDescriptor);
            }
            catch (DeviceResourceException deviceResourceException) {
                WorkbenchPlugin.log(deviceResourceException);
            }
        }
        return image;
    }

    public void measure(Event event, TextLayout textLayout, ResourceManager resourceManager, TextStyle textStyle) {
        Table table = ((TableItem)event.item).getParent();
        textLayout.setFont(table.getFont());
        event.width = 0;
        switch (event.index) {
            case 0: {
                if (this.firstInCategory || this.providerMatchRegions.length > 0) {
                    textLayout.setText(this.provider.getName());
                    if (textStyle == null) break;
                    int n = 0;
                    while (n < this.providerMatchRegions.length) {
                        int[] nArray = this.providerMatchRegions[n];
                        textLayout.setStyle(textStyle, nArray[0], nArray[1]);
                        ++n;
                    }
                    break;
                }
                textLayout.setText("");
                break;
            }
            case 1: {
                Image image = this.getImage(this.element, resourceManager);
                Rectangle rectangle = image.getBounds();
                event.width += rectangle.width + 4;
                event.height = Math.max(event.height, rectangle.height + 2);
                textLayout.setText(this.element.getLabel());
                if (textStyle == null) break;
                int n = 0;
                while (n < this.elementMatchRegions.length) {
                    int[] nArray = this.elementMatchRegions[n];
                    textLayout.setStyle(textStyle, nArray[0], nArray[1]);
                    ++n;
                }
                break;
            }
        }
        Rectangle rectangle = textLayout.getBounds();
        event.width += rectangle.width + 4;
        event.height = Math.max(event.height, rectangle.height + 2);
    }

    public void paint(Event event, TextLayout textLayout, ResourceManager resourceManager, TextStyle textStyle, Color color) {
        String string;
        Table table = ((TableItem)event.item).getParent();
        textLayout.setFont(table.getFont());
        switch (event.index) {
            case 0: {
                Object object;
                if (!this.firstInCategory && this.providerMatchRegions.length <= 0) break;
                textLayout.setText(this.provider.getName());
                if (textStyle != null) {
                    int n = 0;
                    while (n < this.providerMatchRegions.length) {
                        object = this.providerMatchRegions[n];
                        textLayout.setStyle(textStyle, (int)object[0], (int)object[1]);
                        ++n;
                    }
                }
                if (color != null && this.providerMatchRegions.length > 0 && !this.firstInCategory) {
                    event.gc.setForeground(color);
                }
                string = ((TableItem)event.item).getTextBounds(event.index);
                object = textLayout.getBounds();
                textLayout.draw(event.gc, ((Rectangle)string).x + 1, ((Rectangle)string).y + (((Rectangle)string).height - object.height) / 2);
                break;
            }
            case 1: {
                Object object;
                CommandElement commandElement;
                String string2;
                string = this.element.getLabel();
                if (this.element instanceof CommandElement && (string2 = (commandElement = (CommandElement)this.element).getBinding()) != null) {
                    object = StyledCellLabelProvider.styleDecoratedString((String)string, (StyledString.Styler)StyledString.QUALIFIER_STYLER, (StyledString)new StyledString(commandElement.getCommand()));
                    StyleRange[] styleRangeArray = object.getStyleRanges();
                    int n = 0;
                    while (n < styleRangeArray.length) {
                        textLayout.setStyle((TextStyle)styleRangeArray[n], styleRangeArray[n].start, styleRangeArray[n].start + styleRangeArray[n].length);
                        ++n;
                    }
                }
                commandElement = this.getImage(this.element, resourceManager);
                event.gc.drawImage((Image)commandElement, event.x + 1, event.y + 1);
                textLayout.setText(string);
                if (textStyle != null) {
                    int n = 0;
                    while (n < this.elementMatchRegions.length) {
                        object = this.elementMatchRegions[n];
                        textLayout.setStyle(textStyle, (int)object[0], (int)object[1]);
                        ++n;
                    }
                }
                string2 = ((TableItem)event.item).getTextBounds(event.index);
                object = textLayout.getBounds();
                textLayout.draw(event.gc, ((Rectangle)string2).x + 1 + commandElement.getBounds().width, ((Rectangle)string2).y + (((Rectangle)string2).height - object.height) / 2);
            }
        }
        if (this.lastInCategory) {
            if (color != null) {
                event.gc.setForeground(color);
            }
            string = ((TableItem)event.item).getBounds(event.index);
            event.gc.drawLine(Math.max(0, ((Rectangle)string).x - 1), ((Rectangle)string).y + ((Rectangle)string).height - 1, ((Rectangle)string).x + ((Rectangle)string).width, ((Rectangle)string).y + ((Rectangle)string).height - 1);
        }
    }

    public void erase(Event event) {
        event.detail &= 0xFFFFFFEF;
    }
}

