/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.quickaccess.CamelUtil;
import org.eclipse.ui.internal.quickaccess.QuickAccessEntry;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;

public abstract class QuickAccessElement {
    static final String separator = " - ";
    private static final int[][] EMPTY_INDICES = new int[0][0];
    private QuickAccessProvider provider;

    public QuickAccessElement(QuickAccessProvider quickAccessProvider) {
        this.provider = quickAccessProvider;
    }

    public abstract String getLabel();

    public abstract ImageDescriptor getImageDescriptor();

    public abstract String getId();

    public abstract void execute();

    public String getSortLabel() {
        return this.getLabel();
    }

    public QuickAccessProvider getProvider() {
        return this.provider;
    }

    public QuickAccessEntry match(String string, QuickAccessProvider quickAccessProvider) {
        String string2 = this.getLabel();
        int n = string2.toLowerCase().indexOf(string);
        if (n != -1) {
            return new QuickAccessEntry(this, quickAccessProvider, new int[][]{{n, n + string.length() - 1}}, EMPTY_INDICES);
        }
        String string3 = String.valueOf(quickAccessProvider.getName()) + " " + this.getLabel();
        n = string3.toLowerCase().indexOf(string);
        if (n != -1) {
            int n2 = n + string.length() - quickAccessProvider.getName().length() - 1;
            if (n2 > 0) {
                int[][] nArrayArray = new int[1][];
                int[] nArray = new int[2];
                nArray[1] = n2 - 1;
                nArrayArray[0] = nArray;
                return new QuickAccessEntry(this, quickAccessProvider, nArrayArray, new int[][]{{n, n + string.length() - 1}});
            }
            return new QuickAccessEntry(this, quickAccessProvider, EMPTY_INDICES, new int[][]{{n, n + string.length() - 1}});
        }
        String string4 = CamelUtil.getCamelCase(string2);
        n = string4.indexOf(string);
        if (n != -1) {
            int[][] nArray = CamelUtil.getCamelCaseIndices(string2, n, string.length());
            return new QuickAccessEntry(this, quickAccessProvider, nArray, EMPTY_INDICES);
        }
        String string5 = CamelUtil.getCamelCase(string3);
        n = string5.indexOf(string);
        if (n != -1) {
            String string6 = CamelUtil.getCamelCase(quickAccessProvider.getName());
            int n3 = n + string.length() - string6.length();
            if (n3 > 0) {
                return new QuickAccessEntry(this, quickAccessProvider, CamelUtil.getCamelCaseIndices(string2, 0, n3), CamelUtil.getCamelCaseIndices(quickAccessProvider.getName(), n, string.length() - n3));
            }
            return new QuickAccessEntry(this, quickAccessProvider, EMPTY_INDICES, CamelUtil.getCamelCaseIndices(quickAccessProvider.getName(), n, string.length()));
        }
        return null;
    }
}

