/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.quickaccess.ActionProvider;
import org.eclipse.ui.internal.quickaccess.CommandProvider;
import org.eclipse.ui.internal.quickaccess.EditorProvider;
import org.eclipse.ui.internal.quickaccess.PerspectiveProvider;
import org.eclipse.ui.internal.quickaccess.PreferenceProvider;
import org.eclipse.ui.internal.quickaccess.PropertiesProvider;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessEntry;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.internal.quickaccess.ViewProvider;
import org.eclipse.ui.internal.quickaccess.WizardProvider;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.themes.ColorUtil;

public class QuickAccessDialog
extends PopupDialog {
    private static final int INITIAL_COUNT_PER_PROVIDER = 5;
    private static final int MAX_COUNT_TOTAL = 20;
    protected Text filterText;
    private QuickAccessProvider[] providers;
    private IWorkbenchWindow window;
    protected Table table;
    private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private static final String TEXT_ARRAY = "textArray";
    private static final String TEXT_ENTRIES = "textEntries";
    private static final String ORDERED_PROVIDERS = "orderedProviders";
    private static final String ORDERED_ELEMENTS = "orderedElements";
    static final int MAXIMUM_NUMBER_OF_ELEMENTS = 60;
    static final int MAXIMUM_NUMBER_OF_TEXT_ENTRIES_PER_ELEMENT = 3;
    protected String rememberedText;
    protected Map textMap = new HashMap();
    protected Map elementMap = new HashMap();
    private LinkedList previousPicksList = new LinkedList();
    protected Map providerMap;
    private Color grayColor;
    private TextLayout textLayout;
    private TriggerSequence[] invokingCommandKeySequences;
    private Command invokingCommand;
    private KeyAdapter keyAdapter;
    private boolean showAllMatches = false;
    protected boolean resized = false;

    public QuickAccessDialog(IWorkbenchWindow iWorkbenchWindow, final Command command) {
        super(ProgressManagerUtil.getDefaultParent(), 16, true, true, false, true, true, null, QuickAccessMessages.QuickAccess_StartTypingToFindMatches);
        this.window = iWorkbenchWindow;
        BusyIndicator.showWhile((Display)(iWorkbenchWindow.getShell() == null ? null : iWorkbenchWindow.getShell().getDisplay()), (Runnable)new Runnable(){

            @Override
            public void run() {
                QuickAccessDialog.this.providers = new QuickAccessProvider[]{new PreviousPicksProvider(), new EditorProvider(), new ViewProvider(), new PerspectiveProvider(), new CommandProvider(), new ActionProvider(), new WizardProvider(), new PreferenceProvider(), new PropertiesProvider()};
                QuickAccessDialog.this.providerMap = new HashMap();
                int n = 0;
                while (n < QuickAccessDialog.this.providers.length) {
                    QuickAccessDialog.this.providerMap.put(QuickAccessDialog.this.providers[n].getId(), QuickAccessDialog.this.providers[n]);
                    ++n;
                }
                QuickAccessDialog.this.restoreDialog();
                QuickAccessDialog.this.invokingCommand = command;
                if (QuickAccessDialog.this.invokingCommand != null && !QuickAccessDialog.this.invokingCommand.isDefined()) {
                    QuickAccessDialog.this.invokingCommand = null;
                } else {
                    QuickAccessDialog.this.getInvokingCommandKeySequences();
                }
                QuickAccessDialog.this.create();
            }
        });
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = QuickAccessDialog.this.getShell();
                if (shell != null && !shell.isDisposed()) {
                    Point point = shell.getSize();
                    shell.setSize(point.x, point.y + 1);
                }
            }
        });
    }

    protected Control createTitleControl(Composite composite) {
        this.filterText = new Text(composite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.filterText);
        this.filterText.addKeyListener((KeyListener)this.getKeyAdapter());
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.keyCode) {
                    case 13: 
                    case 0x1000050: {
                        QuickAccessDialog.this.handleSelection();
                        break;
                    }
                    case 0x1000002: {
                        int n = QuickAccessDialog.this.table.getSelectionIndex();
                        if (n != -1 && QuickAccessDialog.this.table.getItemCount() > n + 1) {
                            QuickAccessDialog.this.table.setSelection(n + 1);
                        }
                        QuickAccessDialog.this.table.setFocus();
                        break;
                    }
                    case 0x1000001: {
                        int n = QuickAccessDialog.this.table.getSelectionIndex();
                        if (n == -1 || n < 1) break;
                        QuickAccessDialog.this.table.setSelection(n - 1);
                        QuickAccessDialog.this.table.setFocus();
                        break;
                    }
                    case 27: {
                        QuickAccessDialog.this.close();
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = ((Text)modifyEvent.widget).getText().toLowerCase();
                QuickAccessDialog.this.refresh(string);
            }
        });
        return this.filterText;
    }

    protected Control createDialogArea(Composite composite) {
        TextStyle textStyle;
        Object object;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        boolean bl = Util.isWindows();
        GridLayoutFactory.fillDefaults().extendedMargins(bl ? 0 : 3, 3, 2, 2).applyTo(composite2);
        Composite composite3 = new Composite(composite2, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite3);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite3.setLayout((Layout)tableColumnLayout);
        this.table = new Table(composite3, 65540);
        this.textLayout = new TextLayout((Device)this.table.getDisplay());
        this.textLayout.setOrientation(QuickAccessDialog.getDefaultOrientation());
        Font font = this.resourceManager.createFont(FontDescriptor.createFrom((Font)JFaceResources.getDialogFont()).setStyle(1));
        this.textLayout.setFont(this.table.getFont());
        this.textLayout.setText(QuickAccessMessages.QuickAccess_AvailableCategories);
        int n = (int)((double)this.textLayout.getBounds().width * 1.1);
        this.textLayout.setFont(font);
        int n2 = 0;
        while (n2 < this.providers.length) {
            object = this.providers[n2];
            this.textLayout.setText(((QuickAccessProvider)object).getName());
            int n3 = (int)((double)this.textLayout.getBounds().width * 1.1);
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        tableColumnLayout.setColumnData((Widget)new TableColumn(this.table, 0), (ColumnLayoutData)new ColumnWeightData(0, n));
        tableColumnLayout.setColumnData((Widget)new TableColumn(this.table, 0), (ColumnLayoutData)new ColumnWeightData(100, 100));
        this.table.getShell().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                if (!QuickAccessDialog.this.showAllMatches && !QuickAccessDialog.this.resized) {
                    QuickAccessDialog.this.resized = true;
                    controlEvent.display.timerExec(100, new Runnable(){

                        @Override
                        public void run() {
                            if (QuickAccessDialog.this.getShell() != null && !QuickAccessDialog.this.getShell().isDisposed()) {
                                QuickAccessDialog.this.refresh((this).QuickAccessDialog.this.filterText.getText().toLowerCase());
                            }
                            (this).QuickAccessDialog.this.resized = false;
                        }
                    });
                }
            }
        });
        this.table.addKeyListener((KeyListener)this.getKeyAdapter());
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 0x1000001 && QuickAccessDialog.this.table.getSelectionIndex() == 0) {
                    QuickAccessDialog.this.filterText.setFocus();
                } else if (keyEvent.character == '\u001b') {
                    QuickAccessDialog.this.close();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                if (QuickAccessDialog.this.table.getSelectionCount() < 1) {
                    return;
                }
                if (mouseEvent.button != 1) {
                    return;
                }
                if (QuickAccessDialog.this.table.equals(mouseEvent.getSource())) {
                    TableItem tableItem = QuickAccessDialog.this.table.getItem(new Point(mouseEvent.x, mouseEvent.y));
                    TableItem tableItem2 = QuickAccessDialog.this.table.getSelection()[0];
                    if (tableItem2.equals(tableItem)) {
                        QuickAccessDialog.this.handleSelection();
                    }
                }
            }
        });
        this.table.addMouseMoveListener(new MouseMoveListener(){
            TableItem lastItem = null;

            public void mouseMove(MouseEvent mouseEvent) {
                if (QuickAccessDialog.this.table.equals(mouseEvent.getSource())) {
                    TableItem tableItem;
                    if (this.lastItem == null ^ (tableItem = QuickAccessDialog.this.table.getItem(new Point(mouseEvent.x, mouseEvent.y))) == null) {
                        QuickAccessDialog.this.table.setCursor(tableItem == null ? null : QuickAccessDialog.this.table.getDisplay().getSystemCursor(21));
                    }
                    if (tableItem instanceof TableItem) {
                        if (!tableItem.equals(this.lastItem)) {
                            this.lastItem = tableItem;
                            QuickAccessDialog.this.table.setSelection(new TableItem[]{this.lastItem});
                        }
                    } else if (tableItem == null) {
                        this.lastItem = null;
                    }
                }
            }
        });
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                QuickAccessDialog.this.handleSelection();
            }
        });
        if (PlatformUI.getPreferenceStore().getBoolean("USE_COLORED_LABELS")) {
            textStyle = new TextStyle(font, null, null);
            this.grayColor = this.resourceManager.createColor(ColorUtil.blend(this.table.getBackground().getRGB(), this.table.getForeground().getRGB()));
        } else {
            textStyle = null;
        }
        object = new Listener(){

            public void handleEvent(Event event) {
                QuickAccessEntry quickAccessEntry = (QuickAccessEntry)event.item.getData();
                if (quickAccessEntry != null) {
                    switch (event.type) {
                        case 41: {
                            quickAccessEntry.measure(event, QuickAccessDialog.this.textLayout, (ResourceManager)QuickAccessDialog.this.resourceManager, textStyle);
                            break;
                        }
                        case 42: {
                            quickAccessEntry.paint(event, QuickAccessDialog.this.textLayout, (ResourceManager)QuickAccessDialog.this.resourceManager, textStyle, QuickAccessDialog.this.grayColor);
                            break;
                        }
                        case 40: {
                            quickAccessEntry.erase(event);
                        }
                    }
                }
            }
        };
        this.table.addListener(41, (Listener)object);
        this.table.addListener(40, (Listener)object);
        this.table.addListener(42, (Listener)object);
        return composite2;
    }

    private int computeNumberOfItems() {
        Rectangle rectangle = this.table.getClientArea();
        int n = this.table.getItemHeight();
        int n2 = this.table.getHeaderHeight();
        return (rectangle.height - n2 + n - 1) / (n + this.table.getGridLineWidth());
    }

    private void refresh(String string) {
        int n = this.computeNumberOfItems();
        QuickAccessElement quickAccessElement = (QuickAccessElement)this.elementMap.get(string);
        List[] listArray = this.computeMatchingEntries(string, quickAccessElement, n);
        int n2 = this.refreshTable(quickAccessElement, listArray);
        if (this.table.getItemCount() > 0) {
            this.table.setSelection(n2);
        } else if (string.length() == 0) {
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, QuickAccessMessages.QuickAccess_AvailableCategories);
            tableItem.setForeground(0, this.grayColor);
            int n3 = 0;
            while (n3 < this.providers.length) {
                QuickAccessProvider quickAccessProvider = this.providers[n3];
                TableItem tableItem2 = new TableItem(this.table, 0);
                tableItem2.setText(1, quickAccessProvider.getName());
                tableItem2.setForeground(1, this.grayColor);
                ++n3;
            }
        }
        if (string.length() == 0) {
            this.setInfoText(QuickAccessMessages.QuickAccess_StartTypingToFindMatches);
        } else {
            TriggerSequence[] triggerSequenceArray = this.getInvokingCommandKeySequences();
            if (triggerSequenceArray != null && triggerSequenceArray.length != 0) {
                if (this.showAllMatches) {
                    this.setInfoText(NLS.bind((String)QuickAccessMessages.QuickAccess_PressKeyToShowInitialMatches, (Object)triggerSequenceArray[0].format()));
                } else {
                    this.setInfoText(NLS.bind((String)QuickAccessMessages.QuickAccess_PressKeyToShowAllMatches, (Object)triggerSequenceArray[0].format()));
                }
            } else {
                this.setInfoText("");
            }
        }
    }

    protected final TriggerSequence[] getInvokingCommandKeySequences() {
        if (this.invokingCommandKeySequences == null && this.invokingCommand != null) {
            IBindingService iBindingService = (IBindingService)this.window.getWorkbench().getAdapter(IBindingService.class);
            this.invokingCommandKeySequences = iBindingService.getActiveBindingsFor(this.invokingCommand.getId());
        }
        return this.invokingCommandKeySequences;
    }

    private KeyAdapter getKeyAdapter() {
        if (this.keyAdapter == null) {
            this.keyAdapter = new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    int n = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)keyEvent);
                    KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)n));
                    TriggerSequence[] triggerSequenceArray = QuickAccessDialog.this.getInvokingCommandKeySequences();
                    if (triggerSequenceArray == null) {
                        return;
                    }
                    int n2 = 0;
                    while (n2 < triggerSequenceArray.length) {
                        if (triggerSequenceArray[n2].equals((Object)keySequence)) {
                            keyEvent.doit = false;
                            QuickAccessDialog.this.toggleShowAllMatches();
                            return;
                        }
                        ++n2;
                    }
                }
            };
        }
        return this.keyAdapter;
    }

    protected void toggleShowAllMatches() {
        this.showAllMatches = !this.showAllMatches;
        this.refresh(this.filterText.getText().toLowerCase());
    }

    private int refreshTable(QuickAccessElement quickAccessElement, List[] listArray) {
        if (this.table.getItemCount() > listArray.length && this.table.getItemCount() - listArray.length > 20) {
            this.table.removeAll();
        }
        TableItem[] tableItemArray = this.table.getItems();
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.providers.length) {
            if (listArray[n3] != null) {
                boolean bl = true;
                Iterator iterator = listArray[n3].iterator();
                while (iterator.hasNext()) {
                    TableItem tableItem;
                    QuickAccessEntry quickAccessEntry = (QuickAccessEntry)iterator.next();
                    quickAccessEntry.firstInCategory = bl;
                    bl = false;
                    if (!iterator.hasNext()) {
                        quickAccessEntry.lastInCategory = true;
                    }
                    if (n2 < tableItemArray.length) {
                        tableItem = tableItemArray[n2];
                        this.table.clear(n2);
                    } else {
                        tableItem = new TableItem(this.table, 0);
                    }
                    if (quickAccessElement == quickAccessEntry.element && n == -1) {
                        n = n2;
                    }
                    tableItem.setData((Object)quickAccessEntry);
                    tableItem.setText(0, quickAccessEntry.provider.getName());
                    tableItem.setText(1, quickAccessEntry.element.getLabel());
                    if (Util.isWpf()) {
                        tableItem.setImage(1, quickAccessEntry.getImage(quickAccessEntry.element, (ResourceManager)this.resourceManager));
                    }
                    ++n2;
                }
            }
            ++n3;
        }
        if (n2 < tableItemArray.length) {
            this.table.remove(n2, tableItemArray.length - 1);
        }
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    private List[] computeMatchingEntries(String string, QuickAccessElement quickAccessElement, int n) {
        QuickAccessEntry quickAccessEntry;
        boolean bl;
        List[] listArray = new ArrayList[this.providers.length];
        int[] nArray = new int[this.providers.length];
        int n2 = Math.min(n / 4, 5);
        int n3 = 0;
        boolean bl2 = true;
        if (quickAccessElement != null) {
            --n;
            bl2 = false;
        }
        do {
            bl = true;
            int n4 = 0;
            while (n4 < this.providers.length && (this.showAllMatches || n3 < n)) {
                if (listArray[n4] == null) {
                    listArray[n4] = new ArrayList();
                    nArray[n4] = 0;
                }
                int n5 = 0;
                QuickAccessProvider quickAccessProvider = this.providers[n4];
                if (string.length() > 0 || quickAccessProvider instanceof PreviousPicksProvider || this.showAllMatches) {
                    QuickAccessElement[] quickAccessElementArray = quickAccessProvider.getElementsSorted();
                    int n6 = nArray[n4];
                    while (n6 < quickAccessElementArray.length && (this.showAllMatches || n5 < n2 && n3 < n)) {
                        QuickAccessElement quickAccessElement2 = quickAccessElementArray[n6];
                        QuickAccessEntry quickAccessEntry2 = string.length() == 0 ? (n4 == 0 || this.showAllMatches ? new QuickAccessEntry(quickAccessElement2, quickAccessProvider, new int[0][0], new int[0][0]) : null) : quickAccessElement2.match(string, quickAccessProvider);
                        if (quickAccessEntry2 != null) {
                            listArray[n4].add(quickAccessEntry2);
                            ++n5;
                            ++n3;
                            if (n4 == 0 && quickAccessEntry2.element == quickAccessElement) {
                                bl2 = true;
                                n = 20;
                            }
                        }
                        ++n6;
                    }
                    nArray[n4] = n6;
                    if (n6 < quickAccessElementArray.length) {
                        bl = false;
                    }
                }
                ++n4;
            }
            n2 = 1;
        } while ((this.showAllMatches || n3 < n) && !bl);
        if (!bl2 && (quickAccessEntry = quickAccessElement.match(string, this.providers[0])) != null) {
            if (listArray[0] == null) {
                listArray[0] = new ArrayList();
                nArray[0] = 0;
            }
            listArray[0].add(quickAccessEntry);
        }
        return listArray;
    }

    protected Control getFocusControl() {
        return this.filterText;
    }

    public boolean close() {
        this.storeDialog(this.getDialogSettings());
        if (this.textLayout != null && !this.textLayout.isDisposed()) {
            this.textLayout.dispose();
        }
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
        return super.close();
    }

    protected Point getDefaultSize() {
        int n;
        GC gC = new GC((Drawable)this.table);
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        int n2 = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)300);
        if (n2 < 350) {
            n2 = 350;
        }
        if ((n = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)270)) < 420) {
            n = 420;
        }
        return new Point(n2, n);
    }

    protected Point getDefaultLocation(Point point) {
        Point point2 = new Point(400, 400);
        Rectangle rectangle = this.getParentShell().getBounds();
        int n = rectangle.x + rectangle.width / 2 - point2.x / 2;
        int n2 = rectangle.y + rectangle.height / 2 - point2.y / 2;
        return new Point(n, n2);
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(this.getId());
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(this.getId());
        }
        return iDialogSettings2;
    }

    protected String getId() {
        return "org.eclipse.ui.internal.QuickAccess";
    }

    private void storeDialog(IDialogSettings iDialogSettings) {
        String[] stringArray = new String[this.previousPicksList.size()];
        String[] stringArray2 = new String[this.previousPicksList.size()];
        String[] stringArray3 = new String[this.previousPicksList.size()];
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < stringArray.length) {
            QuickAccessElement quickAccessElement = (QuickAccessElement)this.previousPicksList.get(n);
            ArrayList arrayList2 = (ArrayList)this.textMap.get(quickAccessElement);
            Assert.isNotNull((Object)arrayList2);
            stringArray[n] = quickAccessElement.getId();
            stringArray2[n] = quickAccessElement.getProvider().getId();
            arrayList.addAll(arrayList2);
            stringArray3[n] = String.valueOf(arrayList2.size());
            ++n;
        }
        String[] stringArray4 = arrayList.toArray(new String[arrayList.size()]);
        iDialogSettings.put(ORDERED_ELEMENTS, stringArray);
        iDialogSettings.put(ORDERED_PROVIDERS, stringArray2);
        iDialogSettings.put(TEXT_ENTRIES, stringArray3);
        iDialogSettings.put(TEXT_ARRAY, stringArray4);
    }

    private void restoreDialog() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            String[] stringArray = iDialogSettings.getArray(ORDERED_ELEMENTS);
            String[] stringArray2 = iDialogSettings.getArray(ORDERED_PROVIDERS);
            String[] stringArray3 = iDialogSettings.getArray(TEXT_ENTRIES);
            String[] stringArray4 = iDialogSettings.getArray(TEXT_ARRAY);
            this.elementMap = new HashMap();
            this.textMap = new HashMap();
            this.previousPicksList = new LinkedList();
            if (stringArray != null && stringArray2 != null && stringArray3 != null && stringArray4 != null) {
                int n = 0;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    QuickAccessElement quickAccessElement;
                    QuickAccessProvider quickAccessProvider = (QuickAccessProvider)this.providerMap.get(stringArray2[n2]);
                    int n3 = Integer.parseInt(stringArray3[n2]);
                    if (quickAccessProvider != null && (quickAccessElement = quickAccessProvider.getElementForId(stringArray[n2])) != null) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        int n4 = n;
                        while (n4 < n + n3) {
                            String string = stringArray4[n4];
                            if (string.length() > 0) {
                                arrayList.add(string);
                                this.elementMap.put(string, quickAccessElement);
                            }
                            ++n4;
                        }
                        this.textMap.put(quickAccessElement, arrayList);
                        this.previousPicksList.add(quickAccessElement);
                    }
                    n += n3;
                    ++n2;
                }
            }
        }
    }

    protected void handleElementSelected(String string, Object object) {
        if (object instanceof QuickAccessElement) {
            this.addPreviousPick(string, object);
            this.storeDialog(this.getDialogSettings());
            QuickAccessElement quickAccessElement = (QuickAccessElement)object;
            quickAccessElement.execute();
        }
    }

    private void addPreviousPick(String string, Object object) {
        Object object2;
        Object object3;
        this.previousPicksList.remove(object);
        if (this.previousPicksList.size() == 60) {
            object3 = this.previousPicksList.removeLast();
            object2 = (ArrayList)this.textMap.remove(object3);
            int n = 0;
            while (n < ((ArrayList)object2).size()) {
                this.elementMap.remove(((ArrayList)object2).get(n));
                ++n;
            }
        }
        this.previousPicksList.addFirst(object);
        object3 = (ArrayList)this.textMap.get(object);
        if (object3 == null) {
            object3 = new ArrayList();
            this.textMap.put(object, object3);
        }
        ((ArrayList)object3).remove(string);
        if (((ArrayList)object3).size() == 3) {
            object2 = ((ArrayList)object3).remove(0);
            this.elementMap.remove(object2);
        }
        if (string.length() > 0) {
            ((ArrayList)object3).add(string);
            object2 = this.elementMap.put(string, object);
            if (object2 != null && !object2.equals(object) && (object3 = (ArrayList)this.textMap.get(object2)) != null) {
                ((ArrayList)object3).remove(string);
                if (((ArrayList)object3).isEmpty()) {
                    this.textMap.remove(object2);
                    this.previousPicksList.remove(object2);
                }
            }
        }
    }

    private void handleSelection() {
        QuickAccessElement quickAccessElement = null;
        String string = this.filterText.getText().toLowerCase();
        if (this.table.getSelectionCount() == 1) {
            QuickAccessEntry quickAccessEntry = (QuickAccessEntry)this.table.getSelection()[0].getData();
            quickAccessElement = quickAccessEntry == null ? null : quickAccessEntry.element;
        }
        this.close();
        if (quickAccessElement != null) {
            this.handleElementSelected(string, quickAccessElement);
        }
    }

    private class PreviousPicksProvider
    extends QuickAccessProvider {
        private PreviousPicksProvider() {
        }

        @Override
        public QuickAccessElement getElementForId(String string) {
            return null;
        }

        @Override
        public QuickAccessElement[] getElements() {
            return QuickAccessDialog.this.previousPicksList.toArray(new QuickAccessElement[QuickAccessDialog.this.previousPicksList.size()]);
        }

        @Override
        public QuickAccessElement[] getElementsSorted() {
            return this.getElements();
        }

        @Override
        public String getId() {
            return "org.eclipse.ui.previousPicks";
        }

        @Override
        public ImageDescriptor getImageDescriptor() {
            return WorkbenchImages.getImageDescriptor("IMG_OBJ_NODE");
        }

        @Override
        public String getName() {
            return QuickAccessMessages.QuickAccess_Previous;
        }
    }
}

