/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.quickaccess.PropertiesProvider;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;

public class PropertiesElement
extends QuickAccessElement {
    private Object selectedElement;
    private IPreferenceNode preferenceNode;

    PropertiesElement(Object object, IPreferenceNode iPreferenceNode, PropertiesProvider propertiesProvider) {
        super(propertiesProvider);
        this.selectedElement = object;
        this.preferenceNode = iPreferenceNode;
    }

    @Override
    public void execute() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            PropertyDialog propertyDialog = PropertyDialog.createDialogOn(iWorkbenchWindow.getShell(), this.preferenceNode.getId(), this.selectedElement);
            propertyDialog.open();
        }
    }

    @Override
    public String getId() {
        return this.preferenceNode.getId();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        Image image = this.preferenceNode.getLabelImage();
        if (image != null) {
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromImage((Image)image);
            return imageDescriptor;
        }
        return null;
    }

    @Override
    public String getLabel() {
        return this.preferenceNode.getLabelText();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.preferenceNode == null ? 0 : this.preferenceNode.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PropertiesElement propertiesElement = (PropertiesElement)object;
        return !(this.preferenceNode == null ? propertiesElement.preferenceNode != null : !this.preferenceNode.equals(propertiesElement.preferenceNode));
    }
}

