/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.quickaccess.PreferenceElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;

public class PreferenceProvider
extends QuickAccessProvider {
    private QuickAccessElement[] cachedElements;
    private Map idToElement = new HashMap();

    @Override
    public String getId() {
        return "org.eclipse.ui.preferences";
    }

    @Override
    public QuickAccessElement getElementForId(String string) {
        this.getElements();
        return (PreferenceElement)this.idToElement.get(string);
    }

    @Override
    public QuickAccessElement[] getElements() {
        if (this.cachedElements == null) {
            ArrayList arrayList = new ArrayList();
            this.collectElements("", PlatformUI.getWorkbench().getPreferenceManager().getRootSubNodes(), arrayList);
            this.cachedElements = new PreferenceElement[arrayList.size()];
            int n = 0;
            while (n < arrayList.size()) {
                PreferenceElement preferenceElement = (PreferenceElement)arrayList.get(n);
                this.cachedElements[n] = preferenceElement;
                this.idToElement.put(preferenceElement.getId(), preferenceElement);
                ++n;
            }
        }
        return this.cachedElements;
    }

    private void collectElements(String string, IPreferenceNode[] iPreferenceNodeArray, List list) {
        int n = 0;
        while (n < iPreferenceNodeArray.length) {
            if (!WorkbenchActivityHelper.filterItem(iPreferenceNodeArray[n])) {
                PreferenceElement preferenceElement = new PreferenceElement(iPreferenceNodeArray[n], string, this);
                list.add(preferenceElement);
                String string2 = string.length() == 0 ? iPreferenceNodeArray[n].getLabelText() : String.valueOf(string) + "/" + iPreferenceNodeArray[n].getLabelText();
                this.collectElements(string2, iPreferenceNodeArray[n].getSubNodes(), list);
            }
            ++n;
        }
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_NODE");
    }

    @Override
    public String getName() {
        return QuickAccessMessages.QuickAccess_Preferences;
    }
}

