/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceDialog;
import org.eclipse.ui.internal.quickaccess.PreferenceProvider;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;

public class PreferenceElement
extends QuickAccessElement {
    private IPreferenceNode preferenceNode;
    private String prefix;

    PreferenceElement(IPreferenceNode iPreferenceNode, String string, PreferenceProvider preferenceProvider) {
        super(preferenceProvider);
        this.preferenceNode = iPreferenceNode;
        this.prefix = string;
    }

    @Override
    public void execute() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            WorkbenchPreferenceDialog workbenchPreferenceDialog = WorkbenchPreferenceDialog.createDialogOn(iWorkbenchWindow.getShell(), this.preferenceNode.getId());
            workbenchPreferenceDialog.open();
        }
    }

    @Override
    public String getId() {
        return this.preferenceNode.getId();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        Image image = this.preferenceNode.getLabelImage();
        if (image != null) {
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromImage((Image)image);
            return imageDescriptor;
        }
        return null;
    }

    @Override
    public String getLabel() {
        if (this.prefix != null && this.prefix.length() > 0) {
            return String.valueOf(this.preferenceNode.getLabelText()) + " - " + this.prefix;
        }
        return this.preferenceNode.getLabelText();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.preferenceNode == null ? 0 : this.preferenceNode.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PreferenceElement preferenceElement = (PreferenceElement)object;
        return !(this.preferenceNode == null ? preferenceElement.preferenceNode != null : !this.preferenceNode.equals(preferenceElement.preferenceNode));
    }
}

