/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.quickaccess.PerspectiveProvider;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.statushandlers.StatusManager;

public class PerspectiveElement
extends QuickAccessElement {
    private final IPerspectiveDescriptor descriptor;

    PerspectiveElement(IPerspectiveDescriptor iPerspectiveDescriptor, PerspectiveProvider perspectiveProvider) {
        super(perspectiveProvider);
        this.descriptor = iPerspectiveDescriptor;
    }

    @Override
    public void execute() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage != null) {
            iWorkbenchPage.setPerspective(this.descriptor);
        } else {
            try {
                iWorkbenchWindow.openPage(this.descriptor.getId(), ((Workbench)iWorkbench).getDefaultPageInput());
            }
            catch (WorkbenchException workbenchException) {
                IStatus iStatus = WorkbenchPlugin.newError(NLS.bind((String)WorkbenchMessages.Workbench_showPerspectiveError, (Object)this.descriptor.getLabel()), (Throwable)((Object)workbenchException));
                StatusManager.getManager().handle(iStatus, 2);
            }
        }
    }

    @Override
    public String getId() {
        return this.descriptor.getId();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.descriptor.getImageDescriptor();
    }

    @Override
    public String getLabel() {
        return this.descriptor.getLabel();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.descriptor == null ? 0 : this.descriptor.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PerspectiveElement perspectiveElement = (PerspectiveElement)object;
        return !(this.descriptor == null ? perspectiveElement.descriptor != null : !this.descriptor.equals(perspectiveElement.descriptor));
    }
}

