/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.quickaccess.EditorProvider;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;

public class EditorElement
extends QuickAccessElement {
    private static final String DIRTY_MARK = "*";
    private IEditorReference editorReference;

    EditorElement(IEditorReference iEditorReference, EditorProvider editorProvider) {
        super(editorProvider);
        this.editorReference = iEditorReference;
    }

    @Override
    public void execute() {
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchPart iWorkbenchPart = this.editorReference.getPart(true);
        if (iWorkbenchPart != null && (iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
            iWorkbenchPage.activate(iWorkbenchPart);
        }
    }

    @Override
    public String getId() {
        return String.valueOf(this.editorReference.getId()) + this.editorReference.getTitleToolTip();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.createFromImage((Image)this.editorReference.getTitleImage());
    }

    @Override
    public String getLabel() {
        boolean bl = this.editorReference.isDirty();
        return String.valueOf(bl ? DIRTY_MARK : "") + this.editorReference.getTitle() + " - " + this.editorReference.getTitleToolTip();
    }

    @Override
    public String getSortLabel() {
        return this.editorReference.getTitle();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.editorReference == null ? 0 : this.editorReference.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EditorElement editorElement = (EditorElement)object;
        return !(this.editorReference == null ? editorElement.editorReference != null : !this.editorReference.equals(editorElement.editorReference));
    }
}

