/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.quickaccess.CommandElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;

public class CommandProvider
extends QuickAccessProvider {
    private Map idToElement;
    private IEvaluationContext contextSnapshot;
    private IHandlerService handlerService;

    public CommandProvider() {
        this.saveApplicationContext();
        this.getElements();
    }

    @Override
    public String getId() {
        return "org.eclipse.ui.commands";
    }

    @Override
    public QuickAccessElement getElementForId(String string) {
        this.getElements();
        return (CommandElement)this.idToElement.get(string);
    }

    @Override
    public QuickAccessElement[] getElements() {
        if (this.idToElement == null) {
            this.idToElement = new HashMap();
            ICommandService iCommandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Collection collection = iCommandService.getDefinedCommandIds();
            for (String string : collection) {
                Command command = iCommandService.getCommand(string);
                if (command == null || !command.isHandled() || !command.isEnabled()) continue;
                try {
                    Collection collection2 = ParameterizedCommand.generateCombinations((Command)command);
                    for (ParameterizedCommand parameterizedCommand : collection2) {
                        String string2 = parameterizedCommand.serialize();
                        this.idToElement.put(string2, new CommandElement(parameterizedCommand, string2, this));
                    }
                }
                catch (NotDefinedException notDefinedException) {}
            }
        }
        return this.idToElement.values().toArray(new QuickAccessElement[this.idToElement.values().size()]);
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_NODE");
    }

    @Override
    public String getName() {
        return QuickAccessMessages.QuickAccess_Commands;
    }

    private void saveApplicationContext() {
        this.handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        this.contextSnapshot = this.handlerService.createContextSnapshot(true);
    }

    IHandlerService getHandlerService() {
        return this.handlerService;
    }

    IEvaluationContext getContextSnapshot() {
        return this.contextSnapshot;
    }
}

