/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.keys.BindingService;
import org.eclipse.ui.internal.menus.CommandMessages;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.quickaccess.CommandProvider;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.keys.IBindingService;

public class CommandElement
extends QuickAccessElement {
    private ParameterizedCommand command;
    private String id;

    CommandElement(ParameterizedCommand parameterizedCommand, String string, CommandProvider commandProvider) {
        super(commandProvider);
        this.id = string;
        this.command = parameterizedCommand;
    }

    @Override
    public void execute() {
        Object object;
        QuickAccessProvider quickAccessProvider = this.getProvider();
        if (quickAccessProvider instanceof CommandProvider && ((CommandProvider)(object = (CommandProvider)quickAccessProvider)).getHandlerService() != null) {
            try {
                ((CommandProvider)object).getHandlerService().executeCommandInContext(this.command, null, ((CommandProvider)object).getContextSnapshot());
            }
            catch (Exception exception) {
                StatusUtil.handleStatus(exception, 3);
            }
            return;
        }
        object = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (object != null) {
            IHandlerService iHandlerService = (IHandlerService)object.getWorkbench().getService(IHandlerService.class);
            try {
                iHandlerService.executeCommand(this.command, null);
            }
            catch (Exception exception) {
                StatusUtil.handleStatus(exception, 3);
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getCommand() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Command command = this.command.getCommand();
            stringBuffer.append(this.command.getName());
            if (command != null && command.getDescription() != null && command.getDescription().length() != 0) {
                stringBuffer.append(" - ").append(command.getDescription());
            }
        }
        catch (NotDefinedException notDefinedException) {
            stringBuffer.append(this.command.toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getLabel() {
        String string = this.getCommand();
        String string2 = this.getBinding();
        if (string2 != null) {
            return NLS.bind((String)CommandMessages.Tooltip_Accelerator, (Object)string, (Object)string2);
        }
        return string;
    }

    public String getBinding() {
        BindingService bindingService = (BindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        TriggerSequence[] triggerSequenceArray = bindingService.getBindingManager().getActiveBindingsDisregardingContextFor(this.command);
        if (triggerSequenceArray != null && triggerSequenceArray.length > 0) {
            return triggerSequenceArray[0].format();
        }
        return null;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.command == null ? 0 : this.command.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CommandElement commandElement = (CommandElement)object;
        return !(this.command == null ? commandElement.command != null : !this.command.equals((Object)commandElement.command));
    }
}

