/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.quickaccess.ActionElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;

public class ActionProvider
extends QuickAccessProvider {
    private Map idToElement;

    @Override
    public String getId() {
        return "org.eclipse.ui.actions";
    }

    @Override
    public QuickAccessElement getElementForId(String string) {
        this.getElements();
        return (ActionElement)this.idToElement.get(string);
    }

    @Override
    public QuickAccessElement[] getElements() {
        if (this.idToElement == null) {
            this.idToElement = new HashMap();
            IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (iWorkbenchWindow instanceof WorkbenchWindow) {
                MenuManager menuManager = ((WorkbenchWindow)iWorkbenchWindow).getMenuManager();
                HashSet hashSet = new HashSet();
                this.collectContributions(menuManager, hashSet);
                ActionContributionItem[] actionContributionItemArray = hashSet.toArray(new ActionContributionItem[hashSet.size()]);
                int n = 0;
                while (n < actionContributionItemArray.length) {
                    ActionElement actionElement = new ActionElement(actionContributionItemArray[n], this);
                    this.idToElement.put(actionElement.getId(), actionElement);
                    ++n;
                }
            }
        }
        return this.idToElement.values().toArray(new ActionElement[this.idToElement.values().size()]);
    }

    private void collectContributions(MenuManager menuManager, Set set) {
        IContributionItem[] iContributionItemArray = menuManager.getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            IContributionItem iContributionItem = iContributionItemArray[n];
            if (iContributionItem instanceof SubContributionItem) {
                iContributionItem = ((SubContributionItem)iContributionItem).getInnerItem();
            }
            if (iContributionItem instanceof MenuManager) {
                this.collectContributions((MenuManager)iContributionItem, set);
            } else if (iContributionItem instanceof ActionContributionItem && iContributionItem.isEnabled()) {
                set.add(iContributionItem);
            }
            ++n;
        }
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_NODE");
    }

    @Override
    public String getName() {
        return QuickAccessMessages.QuickAccess_Menus;
    }
}

