/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.quickaccess.ActionProvider;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;

public class ActionElement
extends QuickAccessElement {
    private ActionContributionItem item;

    ActionElement(ActionContributionItem actionContributionItem, ActionProvider actionProvider) {
        super(actionProvider);
        this.item = actionContributionItem;
    }

    @Override
    public void execute() {
        this.item.getAction().run();
    }

    @Override
    public String getId() {
        return this.item.getId();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.item.getAction().getImageDescriptor();
    }

    @Override
    public String getLabel() {
        IAction iAction = this.item.getAction();
        if (iAction.getToolTipText() != null && iAction.getToolTipText().length() != 0) {
            return LegacyActionTools.removeMnemonics((String)(String.valueOf(iAction.getText()) + " - " + iAction.getToolTipText()));
        }
        return LegacyActionTools.removeMnemonics((String)iAction.getText());
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.item == null ? 0 : this.item.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ActionElement actionElement = (ActionElement)object;
        return !(this.item == null ? actionElement.item != null : !this.item.equals((Object)actionElement.item));
    }
}

