/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.progress.IJobBusyListener;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.WorkbenchJob;

public class WorkbenchSiteProgressService
implements IWorkbenchSiteProgressService,
IJobBusyListener {
    PartSite site;
    private Map busyJobs = new HashMap();
    private Object busyLock = new Object();
    IPropertyChangeListener[] changeListeners = new IPropertyChangeListener[0];
    private Cursor waitCursor;
    private int waitCursorJobCount;
    private Object waitCursorLock = new Object();
    private SiteUpdateJob updateJob;
    private int busyCount = 0;

    public WorkbenchSiteProgressService(PartSite partSite) {
        this.site = partSite;
        this.updateJob = new SiteUpdateJob();
        this.updateJob.setSystem(true);
    }

    public void dispose() {
        if (this.updateJob != null) {
            this.updateJob.cancel();
        }
        ProgressManager.getInstance().removeListener(this);
        if (this.waitCursor == null) {
            return;
        }
        this.waitCursor.dispose();
        this.waitCursor = null;
    }

    @Override
    public void busyCursorWhile(IRunnableWithProgress iRunnableWithProgress) throws InvocationTargetException, InterruptedException {
        this.getWorkbenchProgressService().busyCursorWhile(iRunnableWithProgress);
    }

    @Override
    public void schedule(Job job, long l, boolean bl) {
        job.addJobChangeListener(this.getJobChangeListener(bl));
        job.schedule(l);
    }

    @Override
    public void schedule(Job job, long l) {
        this.schedule(job, l, false);
    }

    @Override
    public void schedule(Job job) {
        this.schedule(job, 0L, false);
    }

    @Override
    public void showBusyForFamily(Object object) {
        ProgressManager.getInstance().addListenerToFamily(object, this);
    }

    public IJobChangeListener getJobChangeListener(final boolean bl) {
        return new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent iJobChangeEvent) {
                WorkbenchSiteProgressService.this.incrementBusy(iJobChangeEvent.getJob(), bl);
            }

            public void done(IJobChangeEvent iJobChangeEvent) {
                Job job = iJobChangeEvent.getJob();
                WorkbenchSiteProgressService.this.decrementBusy(job);
                job.removeJobChangeListener((IJobChangeListener)this);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrementBusy(Job job) {
        Object v;
        Object object = this.busyLock;
        synchronized (object) {
            v = this.busyJobs.remove(job);
            if (v == null) {
                return;
            }
        }
        if (v == Boolean.TRUE) {
            object = this.waitCursorLock;
            synchronized (object) {
                --this.waitCursorJobCount;
            }
        }
        try {
            this.decrementBusy();
        }
        catch (Exception exception) {
            WorkbenchPlugin.log(exception);
        }
    }

    @Override
    public void incrementBusy(Job job) {
        this.incrementBusy(job, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementBusy(Job job, boolean bl) {
        Object v;
        Object object = this.busyLock;
        synchronized (object) {
            v = this.busyJobs.get(job);
            if (bl || v != Boolean.TRUE) {
                this.busyJobs.put(job, bl);
            }
        }
        if (bl && v != Boolean.TRUE) {
            object = this.waitCursorLock;
            synchronized (object) {
                ++this.waitCursorJobCount;
            }
        }
        if (v != null) {
            if (bl && v == Boolean.FALSE) {
                object = this.busyLock;
                synchronized (object) {
                    this.updateJob.setBusy(true);
                }
                if (PlatformUI.isWorkbenchRunning()) {
                    this.updateJob.schedule(100L);
                } else {
                    this.updateJob.cancel();
                }
            }
            return;
        }
        this.incrementBusy();
    }

    @Override
    public void warnOfContentChange() {
        this.site.getPane().showHighlight();
    }

    @Override
    public void showInDialog(Shell shell, Job job) {
        this.getWorkbenchProgressService().showInDialog(shell, job);
    }

    private IProgressService getWorkbenchProgressService() {
        return this.site.getWorkbenchWindow().getWorkbench().getProgressService();
    }

    @Override
    public void run(boolean bl, boolean bl2, IRunnableWithProgress iRunnableWithProgress) throws InvocationTargetException, InterruptedException {
        this.getWorkbenchProgressService().run(bl, bl2, iRunnableWithProgress);
    }

    @Override
    public void runInUI(IRunnableContext iRunnableContext, IRunnableWithProgress iRunnableWithProgress, ISchedulingRule iSchedulingRule) throws InvocationTargetException, InterruptedException {
        this.getWorkbenchProgressService().runInUI(iRunnableContext, iRunnableWithProgress, iSchedulingRule);
    }

    @Override
    public int getLongOperationTime() {
        return this.getWorkbenchProgressService().getLongOperationTime();
    }

    @Override
    public void registerIconForFamily(ImageDescriptor imageDescriptor, Object object) {
        this.getWorkbenchProgressService().registerIconForFamily(imageDescriptor, object);
    }

    @Override
    public Image getIconFor(Job job) {
        return this.getWorkbenchProgressService().getIconFor(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementBusy() {
        Object object = this.busyLock;
        synchronized (object) {
            ++this.busyCount;
            if (this.busyCount != 1) {
                return;
            }
            this.updateJob.setBusy(true);
        }
        if (PlatformUI.isWorkbenchRunning()) {
            this.updateJob.schedule(100L);
        } else {
            this.updateJob.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrementBusy() {
        Object object = this.busyLock;
        synchronized (object) {
            Assert.isTrue((this.busyCount > 0 ? 1 : 0) != 0, (String)"Ignoring unexpected call to IWorkbenchSiteProgressService.decrementBusy().  This might be due to an earlier call to this method.");
            --this.busyCount;
            if (this.busyCount != 0) {
                return;
            }
            this.updateJob.setBusy(false);
        }
        if (PlatformUI.isWorkbenchRunning()) {
            this.updateJob.schedule(100L);
        } else {
            this.updateJob.cancel();
        }
    }

    public SiteUpdateJob getUpdateJob() {
        return this.updateJob;
    }

    public class SiteUpdateJob
    extends WorkbenchJob {
        private boolean busy;
        Object lock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setBusy(boolean bl) {
            Object object = this.lock;
            synchronized (object) {
                this.busy = bl;
            }
        }

        private SiteUpdateJob() {
            super(ProgressMessages.WorkbenchSiteProgressService_CursorJob);
            this.lock = new Object();
        }

        private Cursor getWaitCursor(Display display) {
            if (WorkbenchSiteProgressService.this.waitCursor == null) {
                WorkbenchSiteProgressService.this.waitCursor = new Cursor((Device)display, 3);
            }
            return WorkbenchSiteProgressService.this.waitCursor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            Control control = WorkbenchSiteProgressService.this.site.getPane().getControl();
            if (control == null || control.isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            Object object = this.lock;
            synchronized (object) {
                Cursor cursor = null;
                if (WorkbenchSiteProgressService.this.waitCursorJobCount != 0) {
                    cursor = this.getWaitCursor(control.getDisplay());
                }
                control.setCursor(cursor);
                WorkbenchSiteProgressService.this.site.getPane().setBusy(this.busy);
                IWorkbenchPart iWorkbenchPart = WorkbenchSiteProgressService.this.site.getPart();
                if (iWorkbenchPart instanceof WorkbenchPart) {
                    ((WorkbenchPart)iWorkbenchPart).showBusy(this.busy);
                }
            }
            return Status.OK_STATUS;
        }

        void clearCursors() {
            if (WorkbenchSiteProgressService.this.waitCursor != null) {
                WorkbenchSiteProgressService.this.waitCursor.dispose();
                WorkbenchSiteProgressService.this.waitCursor = null;
            }
        }
    }
}

