/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.SubTaskInfo;

public class TaskInfo
extends SubTaskInfo {
    double preWork = 0.0;
    int totalWork = 0;

    TaskInfo(JobInfo jobInfo, String string, int n) {
        super(jobInfo, string);
        this.totalWork = n;
    }

    void addWork(double d) {
        if (this.totalWork == -1) {
            return;
        }
        this.preWork += d;
    }

    void addWork(double d, IProgressMonitor iProgressMonitor, int n) {
        if (this.totalWork == -1) {
            return;
        }
        this.addWork(d);
        iProgressMonitor.internalWorked(d * (double)n / (double)this.totalWork);
    }

    @Override
    String getDisplayString(boolean bl) {
        if (this.totalWork == -1) {
            return this.unknownProgress();
        }
        if (this.taskName == null) {
            return this.getDisplayStringWithoutTask(bl);
        }
        if (bl) {
            Object[] objectArray = new String[]{String.valueOf(this.getPercentDone()), this.jobInfo.getJob().getName(), this.taskName};
            return NLS.bind((String)ProgressMessages.JobInfo_DoneMessage, (Object[])objectArray);
        }
        Object[] objectArray = new String[]{this.jobInfo.getJob().getName(), this.taskName};
        return NLS.bind((String)ProgressMessages.JobInfo_DoneNoProgressMessage, (Object[])objectArray);
    }

    String getDisplayStringWithoutTask(boolean bl) {
        if (!bl || this.totalWork == -1) {
            return this.jobInfo.getJob().getName();
        }
        return NLS.bind((String)ProgressMessages.JobInfo_NoTaskNameDoneMessage, (Object)this.jobInfo.getJob().getName(), (Object)String.valueOf(this.getPercentDone()));
    }

    int getPercentDone() {
        if (this.totalWork == -1) {
            return -1;
        }
        return Math.min((int)(this.preWork * 100.0 / (double)this.totalWork), 100);
    }

    private String unknownProgress() {
        if (this.taskName == null) {
            return this.jobInfo.getJob().getName();
        }
        Object[] objectArray = new String[]{this.jobInfo.getJob().getName(), this.taskName};
        return NLS.bind((String)ProgressMessages.JobInfo_UnknownProgress, (Object[])objectArray);
    }
}

