/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.IJobProgressManagerListener;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.TaskInfo;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.IProgressConstants2;
import org.eclipse.ui.progress.WorkbenchJob;

public class TaskBarProgressManager {
    private IJobProgressManagerListener listener;
    private WorkbenchJob animationUpdateJob;
    private boolean isAnimated = false;
    private List jobs = Collections.synchronizedList(new ArrayList());
    private Map jobInfoMap = Collections.synchronizedMap(new HashMap());
    private final TaskItem taskItem;
    private ImageDescriptor overlayDescriptor;
    private Image overlayImage;

    public TaskBarProgressManager(TaskItem taskItem) {
        Assert.isNotNull((Object)taskItem);
        this.taskItem = taskItem;
        this.animationUpdateJob = this.getAnimationUpdateJob();
        this.animationUpdateJob.setSystem(true);
        this.listener = this.getProgressListener();
        ProgressManager.getInstance().addListener(this.listener);
        taskItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                TaskBarProgressManager.this.dispose();
            }
        });
    }

    public void dispose() {
        ProgressManager.getInstance().removeListener(this.listener);
        this.setAnimated(false);
        this.disposeOverlay();
    }

    private WorkbenchJob getAnimationUpdateJob() {
        return new WorkbenchJob(ProgressMessages.AnimationManager_AnimationStart){

            @Override
            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                if (TaskBarProgressManager.this.isAnimated) {
                    if (!TaskBarProgressManager.this.taskItem.isDisposed() && !TaskBarProgressManager.this.jobs.isEmpty()) {
                        Job job = (Job)TaskBarProgressManager.this.jobs.get(0);
                        JobInfo jobInfo = (JobInfo)TaskBarProgressManager.this.jobInfoMap.get(job);
                        if (job != null && jobInfo != null) {
                            int n = this.getPercentDone(jobInfo);
                            if (n == -1 || jobInfo.hasTaskInfo() && jobInfo.getTaskInfo().totalWork == -1) {
                                this.setProgressState(2);
                            } else {
                                this.setProgressState(0);
                                if (!TaskBarProgressManager.this.taskItem.isDisposed()) {
                                    TaskBarProgressManager.this.taskItem.setProgress(n);
                                }
                            }
                        } else {
                            this.setProgressState(-1);
                        }
                        TaskBarProgressManager.this.updateImage(job);
                    } else {
                        TaskBarProgressManager.this.updateImage(null);
                    }
                } else {
                    this.setProgressState(-1);
                    TaskBarProgressManager.this.updateImage(null);
                }
                if (TaskBarProgressManager.this.isAnimated && TaskBarProgressManager.this.taskItem != null && !TaskBarProgressManager.this.taskItem.isDisposed()) {
                    this.schedule(400L);
                }
                return Status.OK_STATUS;
            }

            private void setProgressState(int n) {
                if (!TaskBarProgressManager.this.taskItem.isDisposed() && TaskBarProgressManager.this.taskItem.getProgressState() != n) {
                    TaskBarProgressManager.this.taskItem.setProgressState(-1);
                    TaskBarProgressManager.this.taskItem.setProgressState(n);
                }
            }

            private int getPercentDone(JobTreeElement jobTreeElement) {
                if (jobTreeElement.isJobInfo()) {
                    return ((JobInfo)jobTreeElement).getPercentDone();
                }
                if (jobTreeElement.hasChildren()) {
                    TaskInfo taskInfo;
                    Object[] objectArray = ((GroupInfo)jobTreeElement).getChildren();
                    if (objectArray.length == 1 && objectArray[0] instanceof JobTreeElement && (taskInfo = ((JobInfo)objectArray[0]).getTaskInfo()) != null) {
                        return taskInfo.getPercentDone();
                    }
                    return ((GroupInfo)jobTreeElement).getPercentDone();
                }
                return 0;
            }
        };
    }

    private void updateImage(Job job) {
        if (this.taskItem == null || this.taskItem.isDisposed()) {
            return;
        }
        if (job == null) {
            this.disposeOverlay();
            this.taskItem.setOverlayImage(null);
            return;
        }
        ImageDescriptor imageDescriptor = (ImageDescriptor)job.getProperty(IProgressConstants.ICON_PROPERTY);
        if (imageDescriptor != null) {
            if (!imageDescriptor.equals(this.overlayDescriptor)) {
                this.disposeOverlay();
                this.setOverlay(imageDescriptor);
            }
        } else if (ProgressManager.getInstance().getIconFor(job) != null) {
            this.disposeOverlay();
            Image image = ProgressManager.getInstance().getIconFor(job);
            this.taskItem.setOverlayImage(image);
        } else {
            this.disposeOverlay();
            this.taskItem.setOverlayImage(null);
        }
    }

    private void setOverlay(ImageDescriptor imageDescriptor) {
        this.overlayDescriptor = imageDescriptor;
        this.overlayImage = imageDescriptor.createImage();
        this.taskItem.setOverlayImage(this.overlayImage);
    }

    private void disposeOverlay() {
        this.overlayDescriptor = null;
        if (this.overlayImage != null) {
            this.overlayImage.dispose();
            this.overlayImage = null;
        }
    }

    private IJobProgressManagerListener getProgressListener() {
        return new IJobProgressManagerListener(){

            @Override
            public void addJob(JobInfo jobInfo) {
                if (this.isNotTracked(jobInfo)) {
                    return;
                }
                if (TaskBarProgressManager.this.jobs.isEmpty()) {
                    TaskBarProgressManager.this.setAnimated(true);
                }
                if (!TaskBarProgressManager.this.jobs.contains(jobInfo.getJob())) {
                    TaskBarProgressManager.this.jobs.add(jobInfo.getJob());
                }
                TaskBarProgressManager.this.jobInfoMap.put(jobInfo.getJob(), jobInfo);
            }

            @Override
            public void refreshJobInfo(JobInfo jobInfo) {
                int n = jobInfo.getJob().getState();
                if (n == 4) {
                    this.addJob(jobInfo);
                } else {
                    this.removeJob(jobInfo);
                }
            }

            @Override
            public void refreshAll() {
                ProgressManager progressManager = ProgressManager.getInstance();
                TaskBarProgressManager.this.jobs.clear();
                TaskBarProgressManager.this.jobInfoMap.clear();
                TaskBarProgressManager.this.setAnimated(false);
                JobInfo[] jobInfoArray = progressManager.getJobInfos(this.showsDebug());
                int n = 0;
                while (n < jobInfoArray.length) {
                    this.addJob(jobInfoArray[n]);
                    ++n;
                }
            }

            @Override
            public void removeJob(JobInfo jobInfo) {
                TaskBarProgressManager.this.jobs.remove(jobInfo.getJob());
                TaskBarProgressManager.this.jobInfoMap.remove(jobInfo.getJob());
                if (TaskBarProgressManager.this.jobs.isEmpty()) {
                    TaskBarProgressManager.this.setAnimated(false);
                }
            }

            @Override
            public boolean showsDebug() {
                return false;
            }

            private boolean isNotTracked(JobInfo jobInfo) {
                Job job = jobInfo.getJob();
                return job.getState() != 4 || !this.shouldShowSystemProgress(jobInfo);
            }

            private boolean shouldShowSystemProgress(JobInfo jobInfo) {
                Boolean bl = Boolean.FALSE;
                Object object = jobInfo.getJob().getProperty(IProgressConstants2.SHOW_IN_TASKBAR_ICON_PROPERTY);
                if (object instanceof Boolean) {
                    bl = (Boolean)object;
                }
                return bl;
            }

            @Override
            public void addGroup(GroupInfo groupInfo) {
            }

            @Override
            public void removeGroup(GroupInfo groupInfo) {
            }

            @Override
            public void refreshGroup(GroupInfo groupInfo) {
            }
        };
    }

    private synchronized void setAnimated(boolean bl) {
        this.isAnimated = bl;
        this.animationUpdateJob.schedule();
    }
}

