/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.progress.AbstractProgressViewer;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressContentProvider;
import org.eclipse.ui.progress.WorkbenchJob;

public class ProgressViewerContentProvider
extends ProgressContentProvider {
    protected AbstractProgressViewer progressViewer;
    private FinishedJobs.KeptJobsListener keptJobListener;
    private boolean showFinished;

    public ProgressViewerContentProvider(AbstractProgressViewer abstractProgressViewer, boolean bl, boolean bl2) {
        super(bl);
        this.progressViewer = abstractProgressViewer;
        this.showFinished = bl2;
        if (bl2) {
            FinishedJobs.getInstance().addListener(this.getKeptJobListener());
        }
    }

    private FinishedJobs.KeptJobsListener getKeptJobListener() {
        this.keptJobListener = new FinishedJobs.KeptJobsListener(){

            @Override
            public void finished(JobTreeElement jobTreeElement) {
                final JobTreeElement jobTreeElement2 = jobTreeElement;
                WorkbenchJob workbenchJob = new WorkbenchJob("Refresh finished"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                        ProgressViewerContentProvider.this.refresh(new Object[]{jobTreeElement2});
                        return Status.OK_STATUS;
                    }

                    @Override
                    public boolean shouldSchedule() {
                        return !(this).ProgressViewerContentProvider.this.progressViewer.getControl().isDisposed();
                    }

                    @Override
                    public boolean shouldRun() {
                        return !(this).ProgressViewerContentProvider.this.progressViewer.getControl().isDisposed();
                    }
                };
                workbenchJob.setSystem(true);
                workbenchJob.schedule();
            }

            @Override
            public void removed(JobTreeElement jobTreeElement) {
                final JobTreeElement jobTreeElement2 = jobTreeElement;
                WorkbenchJob workbenchJob = new WorkbenchJob("Remove finished"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                        if (jobTreeElement2 == null) {
                            ProgressViewerContentProvider.this.refresh();
                        } else {
                            ProgressViewerContentProvider.this.remove(new Object[]{jobTreeElement2});
                        }
                        return Status.OK_STATUS;
                    }
                };
                workbenchJob.setSystem(true);
                workbenchJob.schedule();
            }
        };
        return this.keptJobListener;
    }

    @Override
    public void refresh() {
        this.progressViewer.refresh(true);
    }

    @Override
    public void refresh(Object[] objectArray) {
        Object[] objectArray2 = this.getRoots(objectArray, true);
        int n = 0;
        while (n < objectArray2.length) {
            this.progressViewer.refresh(objectArray2[n], true);
            ++n;
        }
    }

    @Override
    public Object[] getElements(Object object) {
        Object[] objectArray = super.getElements(object);
        if (!this.showFinished) {
            return objectArray;
        }
        Set set = FinishedJobs.getInstance().getKeptAsSet();
        if (set.size() == 0) {
            return objectArray;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        int n = 0;
        while (n < objectArray.length) {
            Object object2 = objectArray[n];
            hashSet.add(object2);
            ++n;
        }
        for (Object object2 : set) {
            if (((JobTreeElement)object2).getParent() != null && hashSet.contains(((JobTreeElement)object2).getParent())) continue;
            hashSet.add(object2);
        }
        return hashSet.toArray();
    }

    private Object[] getRoots(Object[] objectArray, boolean bl) {
        if (objectArray.length == 0) {
            return objectArray;
        }
        HashSet<JobTreeElement> hashSet = new HashSet<JobTreeElement>();
        int n = 0;
        while (n < objectArray.length) {
            JobTreeElement jobTreeElement = (JobTreeElement)objectArray[n];
            if (jobTreeElement.isJobInfo()) {
                GroupInfo groupInfo = ((JobInfo)jobTreeElement).getGroupInfo();
                if (groupInfo == null) {
                    hashSet.add(jobTreeElement);
                } else if (bl) {
                    hashSet.add(groupInfo);
                }
            } else {
                hashSet.add(jobTreeElement);
            }
            ++n;
        }
        return hashSet.toArray();
    }

    @Override
    public void add(Object[] objectArray) {
        this.progressViewer.add(objectArray);
    }

    @Override
    public void remove(Object[] objectArray) {
        this.progressViewer.remove(objectArray);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.keptJobListener != null) {
            FinishedJobs.getInstance().removeListener(this.keptJobListener);
        }
    }
}

