/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.IJobProgressManagerListener;
import org.eclipse.ui.internal.progress.IProgressUpdateCollector;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.progress.WorkbenchJob;

class ProgressViewUpdater
implements IJobProgressManagerListener {
    private static ProgressViewUpdater singleton;
    private IProgressUpdateCollector[] collectors;
    Job updateJob;
    UpdatesInfo currentInfo = new UpdatesInfo();
    Object updateLock = new Object();
    boolean debug;
    private long lastUpdateJobScheduleRequest = 0L;

    static ProgressViewUpdater getSingleton() {
        if (singleton == null) {
            singleton = new ProgressViewUpdater();
        }
        return singleton;
    }

    static boolean hasSingleton() {
        return singleton != null;
    }

    static void clearSingleton() {
        if (singleton != null) {
            ProgressManager.getInstance().removeListener(singleton);
        }
        singleton = null;
    }

    private ProgressViewUpdater() {
        this.createUpdateJob();
        this.collectors = new IProgressUpdateCollector[0];
        ProgressManager.getInstance().addListener(this);
        this.debug = PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_SYSTEM_JOBS");
    }

    void addCollector(IProgressUpdateCollector iProgressUpdateCollector) {
        IProgressUpdateCollector[] iProgressUpdateCollectorArray = new IProgressUpdateCollector[this.collectors.length + 1];
        System.arraycopy(this.collectors, 0, iProgressUpdateCollectorArray, 0, this.collectors.length);
        iProgressUpdateCollectorArray[this.collectors.length] = iProgressUpdateCollector;
        this.collectors = iProgressUpdateCollectorArray;
    }

    void removeCollector(IProgressUpdateCollector iProgressUpdateCollector) {
        HashSet<IProgressUpdateCollector> hashSet = new HashSet<IProgressUpdateCollector>();
        int n = 0;
        while (n < this.collectors.length) {
            if (!this.collectors[n].equals(iProgressUpdateCollector)) {
                hashSet.add(this.collectors[n]);
            }
            ++n;
        }
        IProgressUpdateCollector[] iProgressUpdateCollectorArray = new IProgressUpdateCollector[hashSet.size()];
        hashSet.toArray(iProgressUpdateCollectorArray);
        this.collectors = iProgressUpdateCollectorArray;
        if (this.collectors.length == 0) {
            ProgressViewUpdater.clearSingleton();
        }
    }

    void scheduleUpdate() {
        long l;
        if (PlatformUI.isWorkbenchRunning() && (l = System.currentTimeMillis()) - this.lastUpdateJobScheduleRequest >= 100L) {
            this.updateJob.schedule(100L);
            this.lastUpdateJobScheduleRequest = l;
        }
    }

    private void createUpdateJob() {
        this.updateJob = new WorkbenchJob(ProgressMessages.ProgressContentProvider_UpdateProgressJob){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                if (ProgressViewUpdater.this.collectors.length == 0) {
                    return Status.CANCEL_STATUS;
                }
                if (ProgressViewUpdater.this.currentInfo.updateAll) {
                    Object object = ProgressViewUpdater.this.updateLock;
                    synchronized (object) {
                        ProgressViewUpdater.this.currentInfo.reset();
                    }
                    int n = 0;
                    while (n < ProgressViewUpdater.this.collectors.length) {
                        ProgressViewUpdater.this.collectors[n].refresh();
                        ++n;
                    }
                } else {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3;
                    Object object = ProgressViewUpdater.this.updateLock;
                    synchronized (object) {
                        ProgressViewUpdater.this.currentInfo.processForUpdate();
                        objectArray3 = ProgressViewUpdater.this.currentInfo.refreshes.toArray();
                        objectArray2 = ProgressViewUpdater.this.currentInfo.additions.toArray();
                        objectArray = ProgressViewUpdater.this.currentInfo.deletions.toArray();
                        ProgressViewUpdater.this.currentInfo.reset();
                    }
                    int n = 0;
                    while (n < ProgressViewUpdater.this.collectors.length) {
                        IProgressUpdateCollector iProgressUpdateCollector = ProgressViewUpdater.this.collectors[n];
                        if (objectArray3.length > 0) {
                            iProgressUpdateCollector.refresh(objectArray3);
                        }
                        if (objectArray2.length > 0) {
                            iProgressUpdateCollector.add(objectArray2);
                        }
                        if (objectArray.length > 0) {
                            iProgressUpdateCollector.remove(objectArray);
                        }
                        ++n;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        this.updateJob.setSystem(true);
        this.updateJob.setPriority(50);
        this.updateJob.setProperty(ProgressManagerUtil.INFRASTRUCTURE_PROPERTY, new Object());
    }

    UpdatesInfo getCurrentInfo() {
        return this.currentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(JobInfo jobInfo) {
        if (this.isUpdateJob(jobInfo.getJob())) {
            return;
        }
        Object object = this.updateLock;
        synchronized (object) {
            this.currentInfo.refresh(jobInfo);
            GroupInfo groupInfo = jobInfo.getGroupInfo();
            if (groupInfo != null) {
                this.currentInfo.refresh(groupInfo);
            }
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshJobInfo(JobInfo jobInfo) {
        if (this.isUpdateJob(jobInfo.getJob())) {
            return;
        }
        Object object = this.updateLock;
        synchronized (object) {
            this.currentInfo.refresh(jobInfo);
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshGroup(GroupInfo groupInfo) {
        Object object = this.updateLock;
        synchronized (object) {
            this.currentInfo.refresh(groupInfo);
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGroup(GroupInfo groupInfo) {
        Object object = this.updateLock;
        synchronized (object) {
            this.currentInfo.add(groupInfo);
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshAll() {
        Object object = this.updateLock;
        synchronized (object) {
            this.currentInfo.updateAll = true;
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJob(JobInfo jobInfo) {
        if (this.isUpdateJob(jobInfo.getJob())) {
            return;
        }
        Object object = this.updateLock;
        synchronized (object) {
            GroupInfo groupInfo = jobInfo.getGroupInfo();
            if (groupInfo == null) {
                this.currentInfo.add(jobInfo);
            } else {
                this.currentInfo.refresh(groupInfo);
            }
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJob(JobInfo jobInfo) {
        if (this.isUpdateJob(jobInfo.getJob())) {
            return;
        }
        Object object = this.updateLock;
        synchronized (object) {
            GroupInfo groupInfo = jobInfo.getGroupInfo();
            if (groupInfo == null) {
                this.currentInfo.remove(jobInfo);
            } else {
                this.currentInfo.refresh(groupInfo);
            }
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroup(GroupInfo groupInfo) {
        Object object = this.updateLock;
        synchronized (object) {
            this.currentInfo.remove(groupInfo);
        }
        this.scheduleUpdate();
    }

    @Override
    public boolean showsDebug() {
        return this.debug;
    }

    boolean isUpdateJob(Job job) {
        return job.equals(this.updateJob);
    }

    class UpdatesInfo {
        Collection additions = new HashSet();
        Collection deletions = new HashSet();
        Collection refreshes = new HashSet();
        boolean updateAll = false;

        private UpdatesInfo() {
        }

        void add(JobTreeElement jobTreeElement) {
            this.additions.add(jobTreeElement);
        }

        void remove(JobTreeElement jobTreeElement) {
            this.deletions.add(jobTreeElement);
        }

        void refresh(JobTreeElement jobTreeElement) {
            this.refreshes.add(jobTreeElement);
        }

        void reset() {
            this.additions.clear();
            this.deletions.clear();
            this.refreshes.clear();
            this.updateAll = false;
        }

        void processForUpdate() {
            Object object2;
            HashSet<Object> hashSet = new HashSet<Object>();
            for (Object object2 : this.additions) {
                if (((JobTreeElement)object2).isActive() || !this.deletions.contains(object2)) continue;
                hashSet.add(object2);
            }
            this.additions.removeAll(hashSet);
            object2 = new HashSet();
            for (JobTreeElement jobTreeElement : this.refreshes) {
                Object object3;
                if (this.deletions.contains(jobTreeElement) || this.additions.contains(jobTreeElement)) {
                    ((HashSet)object2).add(jobTreeElement);
                }
                if ((object3 = jobTreeElement.getParent()) != null && (this.deletions.contains(object3) || this.additions.contains(object3))) {
                    ((HashSet)object2).add(jobTreeElement);
                }
                if (jobTreeElement.isActive()) continue;
                ((HashSet)object2).add(jobTreeElement);
                this.deletions.add(jobTreeElement);
            }
            this.refreshes.removeAll((Collection<?>)object2);
        }
    }
}

