/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.TrimUtil;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.internal.progress.AnimationItem;
import org.eclipse.ui.internal.progress.AnimationManager;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.ProgressAnimationItem;
import org.eclipse.ui.internal.progress.ProgressCanvasViewer;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressViewerContentProvider;
import org.eclipse.ui.internal.progress.ProgressViewerLabelProvider;

public class ProgressRegion
implements IWindowTrim {
    ProgressCanvasViewer viewer;
    ProgressAnimationItem animationItem;
    Composite region;
    WorkbenchWindow workbenchWindow;
    private int fWidthHint = -1;
    private int fHeightHint = -1;
    private int side = 1024;
    private boolean forceHorizontal;

    public Control createContents(Composite composite, WorkbenchWindow workbenchWindow) {
        this.workbenchWindow = workbenchWindow;
        GC gC = new GC((Drawable)composite);
        gC.setAdvanced(true);
        this.forceHorizontal = !gC.getAdvanced();
        gC.dispose();
        this.region = new Composite(composite, 0){

            public Point computeSize(int n, int n2, boolean bl) {
                Point point = super.computeSize(n, n2, bl);
                if (ProgressRegion.this.isHorizontal(ProgressRegion.this.side)) {
                    point.y = TrimUtil.TRIM_DEFAULT_HEIGHT;
                } else {
                    point.x = TrimUtil.TRIM_DEFAULT_HEIGHT;
                }
                return point;
            }
        };
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        if (this.isHorizontal(this.side)) {
            gridLayout.numColumns = 3;
        }
        this.region.setLayout((Layout)gridLayout);
        this.viewer = new ProgressCanvasViewer(this.region, 524288, 1, 36, this.isHorizontal(this.side) ? 256 : 512);
        this.viewer.setUseHashlookup(true);
        Control control = this.viewer.getControl();
        GridData gridData = new GridData(4, 4, true, true);
        Point point = this.viewer.getSizeHints();
        if (this.isHorizontal(this.side)) {
            gridData.widthHint = point.x;
            gridData.heightHint = point.y;
        } else {
            gridData.widthHint = point.y;
            gridData.heightHint = point.x;
        }
        control.setLayoutData((Object)gridData);
        int n = AnimationManager.getInstance().getPreferredWidth() + 25;
        this.animationItem = new ProgressAnimationItem(this, this.isHorizontal(this.side) ? 256 : 512);
        this.animationItem.createControl(this.region);
        this.animationItem.setAnimationContainer(new AnimationItem.IAnimationContainer(){

            @Override
            public void animationDone() {
                if (ProgressRegion.this.viewer.getControl().isDisposed()) {
                    return;
                }
                ProgressRegion.this.viewer.refresh();
            }

            @Override
            public void animationStart() {
            }
        });
        if (this.isHorizontal(this.side)) {
            gridData = new GridData(1040);
            gridData.widthHint = n;
        } else {
            gridData = new GridData(768);
            gridData.heightHint = n;
        }
        this.animationItem.getControl().setLayoutData((Object)gridData);
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                ProgressRegion.this.processDoubleClick();
            }
        });
        ProgressViewerContentProvider progressViewerContentProvider = new ProgressViewerContentProvider(this.viewer, false, false);
        this.viewer.setContentProvider((IContentProvider)progressViewerContentProvider);
        this.viewer.setInput(progressViewerContentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProgressViewerLabelProvider(control));
        this.viewer.setComparator(ProgressManagerUtil.getProgressViewerComparator());
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                JobInfo jobInfo;
                return !(object2 instanceof JobInfo) || !(jobInfo = (JobInfo)object2).isBlocked() && jobInfo.getJob().getState() != 2;
            }
        });
        return this.region;
    }

    public AnimationItem getAnimationItem() {
        return this.animationItem;
    }

    @Override
    public Control getControl() {
        return this.region;
    }

    public void processDoubleClick() {
        ProgressManagerUtil.openProgressView(this.workbenchWindow);
    }

    @Override
    public void dock(int n) {
        int n2 = this.side;
        this.side = n;
        if (n2 == n || this.isVertical(n2) && this.isVertical(n) || this.isHorizontal(n2) && this.isHorizontal(n)) {
            return;
        }
        this.recreate();
    }

    private boolean isHorizontal(int n) {
        if (this.forceHorizontal) {
            return true;
        }
        return n == 128 || n == 1024;
    }

    private boolean isVertical(int n) {
        if (this.forceHorizontal) {
            return false;
        }
        return n == 16384 || n == 131072;
    }

    private void recreate() {
        if (this.region != null && !this.region.isDisposed()) {
            Composite composite = this.region.getParent();
            boolean bl = this.animationItem.animationRunning();
            AnimationManager.getInstance().removeItem(this.animationItem);
            this.region.dispose();
            this.createContents(composite, this.workbenchWindow);
            if (bl) {
                this.animationItem.animationStart();
            }
        }
    }

    @Override
    public String getId() {
        return "org.eclipse.ui.internal.progress.ProgressRegion";
    }

    @Override
    public String getDisplayName() {
        return WorkbenchMessages.TrimCommon_Progress_TrimName;
    }

    @Override
    public int getValidSides() {
        return 148608;
    }

    @Override
    public boolean isCloseable() {
        return false;
    }

    @Override
    public void handleClose() {
    }

    @Override
    public int getWidthHint() {
        return this.fWidthHint;
    }

    public void setWidthHint(int n) {
        this.fWidthHint = n;
    }

    @Override
    public int getHeightHint() {
        return this.fHeightHint;
    }

    public void setHeightHint(int n) {
        this.fHeightHint = n;
    }

    @Override
    public boolean isResizeable() {
        return false;
    }
}

