/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.progress.DetailedProgressViewer;
import org.eclipse.ui.internal.progress.ProgressLabelProvider;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressViewerContentProvider;

public class ProgressMonitorJobsDialog
extends ProgressMonitorDialog {
    private DetailedProgressViewer viewer;
    private int viewerHeight = -1;
    Composite viewerComposite;
    private Button detailsButton;
    private long watchTime = -1L;
    protected boolean alreadyClosed = false;
    private IProgressMonitor wrapperedMonitor;
    protected boolean enableDetailsButton = false;

    public ProgressMonitorJobsDialog(Shell shell) {
        super(shell);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createExtendedDialogArea(composite);
        return composite2;
    }

    protected void createExtendedDialogArea(Composite composite) {
        this.viewerComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.viewerComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 0;
        this.viewerComposite.setLayoutData((Object)gridData);
    }

    void handleDetailsButtonSelect() {
        Shell shell = this.getShell();
        Point point = shell.getSize();
        Composite composite = (Composite)this.getDialogArea();
        if (this.viewer != null) {
            this.viewer.getControl().dispose();
            this.viewer = null;
            composite.layout();
            shell.setSize(point.x, point.y - this.viewerHeight);
            this.detailsButton.setText(ProgressMessages.ProgressMonitorJobsDialog_DetailsTitle);
        } else {
            if (ProgressManager.getInstance().getRootElements(Policy.DEBUG_SHOW_ALL_JOBS).length == 0) {
                this.detailsButton.setEnabled(false);
                return;
            }
            this.viewer = new DetailedProgressViewer(this.viewerComposite, 2818);
            this.viewer.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object object, Object object2) {
                    return ((Comparable)object).compareTo(object2);
                }
            });
            this.viewer.setContentProvider((IContentProvider)new ProgressViewerContentProvider(this.viewer, true, false){

                @Override
                public Object[] getElements(Object object) {
                    return super.getElements(object);
                }
            });
            this.viewer.setLabelProvider((IBaseLabelProvider)new ProgressLabelProvider());
            this.viewer.setInput((Object)this);
            GridData gridData = new GridData(1808);
            this.viewer.getControl().setLayoutData((Object)gridData);
            GridData gridData2 = (GridData)this.viewerComposite.getLayoutData();
            gridData2.heightHint = this.convertHeightInCharsToPixels(10);
            this.viewerComposite.layout(true);
            this.viewer.getControl().setVisible(true);
            this.viewerHeight = this.viewerComposite.computeTrim((int)0, (int)0, (int)0, (int)gridData2.heightHint).height;
            this.detailsButton.setText(ProgressMessages.ProgressMonitorJobsDialog_HideTitle);
            shell.setSize(point.x, point.y + this.viewerHeight);
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
        this.createDetailsButton(composite);
    }

    protected void createSpacer(Composite composite) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(768));
    }

    protected void createDetailsButton(Composite composite) {
        this.detailsButton = this.createButton(composite, 13, ProgressMessages.ProgressMonitorJobsDialog_DetailsTitle, false);
        this.detailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProgressMonitorJobsDialog.this.handleDetailsButtonSelect();
            }
        });
        this.detailsButton.setCursor(this.arrowCursor);
        this.detailsButton.setEnabled(this.enableDetailsButton);
    }

    protected Control createButtonBar(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 3;
        gridData.grabExcessHorizontalSpace = true;
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(composite.getFont());
        if (this.arrowCursor == null) {
            this.arrowCursor = new Cursor((Device)composite.getDisplay(), 0);
        }
        this.createButtonsForButtonBar(composite2);
        return composite2;
    }

    protected void clearCursors() {
        if (this.detailsButton != null && !this.detailsButton.isDisposed()) {
            this.detailsButton.setCursor(null);
        }
        super.clearCursors();
    }

    protected void updateForSetBlocked(IStatus iStatus) {
        if (this.alreadyClosed) {
            return;
        }
        super.updateForSetBlocked(iStatus);
        this.enableDetails(true);
        if (this.viewer == null) {
            this.handleDetailsButtonSelect();
        }
    }

    public void run(boolean bl, boolean bl2, IRunnableWithProgress iRunnableWithProgress) throws InvocationTargetException, InterruptedException {
        if (!bl) {
            this.enableDetails(false);
        }
        super.run(bl, bl2, iRunnableWithProgress);
    }

    protected void enableDetails(boolean bl) {
        if (this.detailsButton == null) {
            this.enableDetailsButton = bl;
        } else {
            this.detailsButton.setEnabled(bl);
        }
    }

    public void watchTicks() {
        this.watchTime = System.currentTimeMillis();
    }

    public void createWrapperedMonitor() {
        this.wrapperedMonitor = new IProgressMonitorWithBlocking(){
            IProgressMonitor superMonitor;
            {
                this.superMonitor = ProgressMonitorJobsDialog.super.getProgressMonitor();
            }

            public void beginTask(String string, int n) {
                this.superMonitor.beginTask(string, n);
                this.checkTicking();
            }

            private void checkTicking() {
                if (ProgressMonitorJobsDialog.this.watchTime < 0L) {
                    return;
                }
                if (System.currentTimeMillis() - ProgressMonitorJobsDialog.this.watchTime > (long)ProgressManager.getInstance().getLongOperationTime()) {
                    ProgressMonitorJobsDialog.this.watchTime = -1L;
                    this.openDialog();
                }
            }

            private void openDialog() {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!ProgressManagerUtil.safeToOpen(ProgressMonitorJobsDialog.this, null)) {
                            ProgressMonitorJobsDialog.this.watchTicks();
                            return;
                        }
                        if (!(this).ProgressMonitorJobsDialog.this.alreadyClosed) {
                            ProgressMonitorJobsDialog.this.open();
                        }
                    }
                });
            }

            public void done() {
                this.superMonitor.done();
                this.checkTicking();
            }

            public void internalWorked(double d) {
                this.superMonitor.internalWorked(d);
                this.checkTicking();
            }

            public boolean isCanceled() {
                return this.superMonitor.isCanceled();
            }

            public void setCanceled(boolean bl) {
                this.superMonitor.setCanceled(bl);
            }

            public void setTaskName(String string) {
                this.superMonitor.setTaskName(string);
                this.checkTicking();
            }

            public void subTask(String string) {
                this.superMonitor.subTask(string);
                this.checkTicking();
            }

            public void worked(int n) {
                this.superMonitor.worked(n);
                this.checkTicking();
            }

            public void clearBlocked() {
                if (this.superMonitor instanceof IProgressMonitorWithBlocking) {
                    ((IProgressMonitorWithBlocking)this.superMonitor).clearBlocked();
                }
            }

            public void setBlocked(IStatus iStatus) {
                this.openDialog();
                if (this.superMonitor instanceof IProgressMonitorWithBlocking) {
                    ((IProgressMonitorWithBlocking)this.superMonitor).setBlocked(iStatus);
                }
            }
        };
    }

    public IProgressMonitor getProgressMonitor() {
        if (this.wrapperedMonitor == null) {
            this.createWrapperedMonitor();
        }
        return this.wrapperedMonitor;
    }

    public boolean close() {
        this.alreadyClosed = true;
        boolean bl = super.close();
        if (!bl) {
            this.alreadyClosed = false;
        }
        return bl;
    }

    protected boolean isResizable() {
        return true;
    }
}

