/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.WorkbenchJob;

class ProgressMonitorFocusJobDialog
extends ProgressMonitorJobsDialog {
    Job job;
    private boolean showDialog;

    public ProgressMonitorFocusJobDialog(Shell shell) {
        super(shell == null ? ProgressManagerUtil.getNonModalShell() : shell);
        this.setShellStyle(ProgressMonitorFocusJobDialog.getDefaultOrientation() | 0x800 | 0x20 | 0x10 | 0x400);
        this.setCancelable(true);
        this.enableDetailsButton = true;
    }

    protected void cancelPressed() {
        this.job.cancel();
        super.cancelPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.job.getName());
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        Button button = this.createButton(composite, 12, ProgressMessages.ProgressMonitorFocusJobDialog_RunInBackgroundButton, true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Rectangle rectangle = ProgressMonitorFocusJobDialog.this.getShell().getBounds();
                ProgressMonitorFocusJobDialog.this.job.setProperty(IProgressConstants.PROPERTY_IN_DIALOG, (Object)Boolean.FALSE);
                ProgressMonitorFocusJobDialog.this.finishedRun();
                ProgressManagerUtil.animateDown(rectangle);
            }
        });
        button.setCursor(this.arrowCursor);
        this.cancel = this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.cancel.setCursor(this.arrowCursor);
        this.createDetailsButton(composite);
    }

    private IJobChangeListener createCloseListener() {
        return new JobChangeAdapter(){

            public void done(IJobChangeEvent iJobChangeEvent) {
                iJobChangeEvent.getJob().removeJobChangeListener((IJobChangeListener)this);
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                if (ProgressMonitorFocusJobDialog.this.getShell() == null) {
                    return;
                }
                WorkbenchJob workbenchJob = new WorkbenchJob(ProgressMessages.ProgressMonitorFocusJobDialog_CLoseDialogJob){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                        Shell shell = ProgressMonitorFocusJobDialog.this.getShell();
                        if (shell == null || shell.isDisposed()) {
                            return Status.CANCEL_STATUS;
                        }
                        ProgressMonitorFocusJobDialog.this.finishedRun();
                        return Status.OK_STATUS;
                    }
                };
                workbenchJob.setSystem(true);
                workbenchJob.schedule();
            }
        };
    }

    private IProgressMonitorWithBlocking getBlockingProgressMonitor() {
        return new IProgressMonitorWithBlocking(){

            public void beginTask(String string, int n) {
                final String string2 = string;
                final int n2 = n;
                this.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitorFocusJobDialog.this.getProgressMonitor().beginTask(string2, n2);
                    }
                });
            }

            public void clearBlocked() {
                this.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        ((IProgressMonitorWithBlocking)ProgressMonitorFocusJobDialog.this.getProgressMonitor()).clearBlocked();
                    }
                });
            }

            public void done() {
                this.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitorFocusJobDialog.this.getProgressMonitor().done();
                    }
                });
            }

            public void internalWorked(double d) {
                final double d2 = d;
                this.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitorFocusJobDialog.this.getProgressMonitor().internalWorked(d2);
                    }
                });
            }

            public boolean isCanceled() {
                return ProgressMonitorFocusJobDialog.this.getProgressMonitor().isCanceled();
            }

            private void runAsync(final Runnable runnable) {
                Display display;
                if (ProgressMonitorFocusJobDialog.this.alreadyClosed) {
                    return;
                }
                Shell shell = ProgressMonitorFocusJobDialog.this.getShell();
                if (shell == null) {
                    display = Display.getDefault();
                } else {
                    if (shell.isDisposed()) {
                        return;
                    }
                    display = shell.getDisplay();
                }
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).ProgressMonitorFocusJobDialog.this.alreadyClosed) {
                            return;
                        }
                        Shell shell = ProgressMonitorFocusJobDialog.this.getShell();
                        if (shell != null && shell.isDisposed()) {
                            return;
                        }
                        runnable.run();
                    }
                });
            }

            public void setBlocked(IStatus iStatus) {
                final IStatus iStatus2 = iStatus;
                this.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        ((IProgressMonitorWithBlocking)ProgressMonitorFocusJobDialog.this.getProgressMonitor()).setBlocked(iStatus2);
                    }
                });
            }

            public void setCanceled(boolean bl) {
            }

            public void setTaskName(String string) {
                final String string2 = string;
                this.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitorFocusJobDialog.this.getProgressMonitor().setTaskName(string2);
                    }
                });
            }

            public void subTask(String string) {
                final String string2 = string;
                this.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitorFocusJobDialog.this.getProgressMonitor().subTask(string2);
                    }
                });
            }

            public void worked(int n) {
                this.internalWorked(n);
            }
        };
    }

    public int open() {
        int n = super.open();
        IJobChangeListener iJobChangeListener = this.createCloseListener();
        this.job.addJobChangeListener(iJobChangeListener);
        if (this.job.getState() == 0) {
            this.job.removeJobChangeListener(iJobChangeListener);
            this.finishedRun();
            this.cleanUpFinishedJob();
        }
        return n;
    }

    public void show(Job job, final Shell shell) {
        this.job = job;
        this.job.setProperty(IProgressConstants.PROPERTY_IN_DIALOG, (Object)Boolean.TRUE);
        ProgressManager.getInstance().progressFor(this.job).addProgressListener(this.getBlockingProgressMonitor());
        this.setOpenOnRun(false);
        this.aboutToRun();
        final Object object = new Object();
        JobChangeAdapter jobChangeAdapter = new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent iJobChangeEvent) {
                Object object2 = object;
                synchronized (object2) {
                    object.notify();
                }
            }
        };
        this.job.addJobChangeListener((IJobChangeListener)jobChangeAdapter);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object2 = object;
                    synchronized (object2) {
                        if (ProgressMonitorFocusJobDialog.this.job.getState() != 0) {
                            object.wait(ProgressManagerUtil.SHORT_OPERATION_TIME);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        this.job.removeJobChangeListener((IJobChangeListener)jobChangeAdapter);
        WorkbenchJob workbenchJob = new WorkbenchJob(ProgressMessages.ProgressMonitorFocusJobDialog_UserDialogJob){

            @Override
            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                if (ProgressMonitorFocusJobDialog.this.job.getState() == 0) {
                    ProgressMonitorFocusJobDialog.this.finishedRun();
                    ProgressMonitorFocusJobDialog.this.cleanUpFinishedJob();
                    return Status.CANCEL_STATUS;
                }
                if (!ProgressManagerUtil.safeToOpen(ProgressMonitorFocusJobDialog.this, shell)) {
                    return Status.CANCEL_STATUS;
                }
                if (ProgressMonitorFocusJobDialog.this.getParentShell() != null && ProgressMonitorFocusJobDialog.this.getParentShell().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                ProgressMonitorFocusJobDialog.this.open();
                return Status.OK_STATUS;
            }
        };
        workbenchJob.setSystem(true);
        workbenchJob.schedule();
    }

    private void cleanUpFinishedJob() {
        ProgressManager.getInstance().checkForStaleness(this.job);
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Control control = super.createDialogArea(composite);
        this.getProgressMonitor().setTaskName(ProgressManager.getInstance().getJobInfo(this.job).getDisplayString());
        return control;
    }

    @Override
    protected void createExtendedDialogArea(Composite composite) {
        this.showDialog = WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("RUN_IN_BACKGROUND");
        final Button button = new Button(composite, 32);
        button.setText(WorkbenchMessages.WorkbenchPreference_RunInBackgroundButton);
        button.setToolTipText(WorkbenchMessages.WorkbenchPreference_RunInBackgroundToolTip);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProgressMonitorFocusJobDialog.this.showDialog = button.getSelection();
            }
        });
        super.createExtendedDialogArea(composite);
    }

    @Override
    public boolean close() {
        if (this.getReturnCode() != 1) {
            WorkbenchPlugin.getDefault().getPreferenceStore().setValue("RUN_IN_BACKGROUND", this.showDialog);
        }
        return super.close();
    }
}

