/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.AnimationEngine;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.internal.progress.ProgressRegion;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.views.IViewDescriptor;

public class ProgressManagerUtil {
    public static long SHORT_OPERATION_TIME = 250L;
    static final QualifiedName KEEP_PROPERTY = IProgressConstants.KEEP_PROPERTY;
    static final QualifiedName KEEPONE_PROPERTY = IProgressConstants.KEEPONE_PROPERTY;
    static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    static final QualifiedName INFRASTRUCTURE_PROPERTY = new QualifiedName(WorkbenchPlugin.PI_WORKBENCH, "INFRASTRUCTURE_PROPERTY");
    private static String ellipsis = ProgressMessages.ProgressFloatingWindow_EllipsisValue;

    static IStatus exceptionStatus(Throwable throwable) {
        return StatusUtil.newStatus(4, throwable.getMessage() == null ? "" : throwable.getMessage(), throwable);
    }

    static void logException(Throwable throwable) {
        BundleUtility.log("org.eclipse.ui", throwable);
    }

    static ViewerComparator getProgressViewerComparator() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object object, Object object2) {
                return ((Comparable)object).compareTo(object2);
            }
        };
    }

    static void openProgressView(WorkbenchWindow workbenchWindow) {
        IWorkbenchPage iWorkbenchPage = workbenchWindow.getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        try {
            IViewDescriptor iViewDescriptor = WorkbenchPlugin.getDefault().getViewRegistry().find("org.eclipse.ui.views.ProgressView");
            if (iViewDescriptor == null) {
                return;
            }
            iWorkbenchPage.showView("org.eclipse.ui.views.ProgressView");
        }
        catch (PartInitException partInitException) {
            ProgressManagerUtil.logException((Throwable)((Object)partInitException));
        }
    }

    static String shortenText(String string, Control control) {
        if (string == null) {
            return null;
        }
        GC gC = new GC((Drawable)control);
        int n = gC.textExtent((String)string).x;
        int n2 = control.getBounds().width - 5;
        if (n < n2) {
            gC.dispose();
            return string;
        }
        int n3 = string.length();
        int n4 = Math.round(0.95f * (float)n3 * (1.0f - (float)n2 / (float)n));
        int n5 = ProgressManagerUtil.findSecondWhitespace(string, gC, n2);
        int n6 = (n3 - n5) / 2 + n5;
        int n7 = n6 - n4 / 2;
        int n8 = n6 + n4 / 2 + 1;
        while (n7 >= 0 && n8 < n3) {
            String string2 = string.substring(0, n7);
            String string3 = string.substring(n8, n3);
            String string4 = String.valueOf(string2) + ellipsis + string3;
            int n9 = gC.textExtent((String)string4).x;
            if (n9 < n2) {
                gC.dispose();
                return string4;
            }
            --n7;
            ++n8;
        }
        gC.dispose();
        return string;
    }

    private static int findSecondWhitespace(String string, GC gC, int n) {
        int n2 = 0;
        char[] cArray = string.toCharArray();
        int n3 = 0;
        while (n3 < cArray.length) {
            if (Character.isWhitespace(cArray[n3])) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 == 0) {
            return 0;
        }
        n3 = n2;
        int n4 = n2;
        while (n4 < cArray.length) {
            if (Character.isWhitespace(cArray[n4])) {
                n3 = n4;
                break;
            }
            ++n4;
        }
        if (gC.textExtent((String)string.substring((int)0, (int)n3)).x > n) {
            if (gC.textExtent((String)string.substring((int)0, (int)n2)).x > n) {
                return 0;
            }
            return n2;
        }
        return n3;
    }

    public static boolean rescheduleIfModalShellOpen(Job job) {
        Shell shell = ProgressManagerUtil.getModalShellExcluding(null);
        if (shell == null) {
            return false;
        }
        job.schedule((long)PlatformUI.getWorkbench().getProgressService().getLongOperationTime());
        return true;
    }

    public static boolean safeToOpen(ProgressMonitorJobsDialog progressMonitorJobsDialog, Shell shell) {
        Shell shell2 = ProgressManagerUtil.getModalShellExcluding(shell);
        if (shell2 == null) {
            return true;
        }
        progressMonitorJobsDialog.watchTicks();
        return false;
    }

    public static Shell getModalShellExcluding(Shell shell) {
        if (shell == null || shell.isDisposed()) {
            return ProgressManagerUtil.getModalChildExcluding(PlatformUI.getWorkbench().getDisplay().getShells(), shell);
        }
        return ProgressManagerUtil.getModalChildExcluding(shell.getShells(), shell);
    }

    private static Shell getModalChildExcluding(Shell[] shellArray, Shell shell) {
        int n = 229376;
        int n2 = shellArray.length - 1;
        while (n2 >= 0) {
            Shell shell2 = shellArray[n2];
            if (!shell2.equals(shell)) {
                Shell[] shellArray2 = shell2.getShells();
                Shell shell3 = ProgressManagerUtil.getModalChildExcluding(shellArray2, shell);
                if (shell3 != null) {
                    return shell3;
                }
                if (shell2.isVisible() && (shell2.getStyle() & n) != 0) {
                    return shell2;
                }
            }
            --n2;
        }
        return null;
    }

    public static Shell getDefaultParent() {
        Shell shell = ProgressManagerUtil.getModalShellExcluding(null);
        if (shell != null) {
            return shell;
        }
        return ProgressManagerUtil.getNonModalShell();
    }

    public static Shell getNonModalShell() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (iWorkbenchWindowArray.length > 0) {
                return iWorkbenchWindowArray[0].getShell();
            }
        } else {
            return iWorkbenchWindow.getShell();
        }
        return null;
    }

    public static void animateDown(Rectangle rectangle) {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return;
        }
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchWindow;
        ProgressRegion progressRegion = workbenchWindow.getProgressRegion();
        if (progressRegion == null) {
            return;
        }
        Rectangle rectangle2 = progressRegion.getControl().getBounds();
        Point point = workbenchWindow.getShell().getLocation();
        rectangle2.x += point.x;
        rectangle2.y += point.y;
        AnimationEngine.createTweakedAnimation(workbenchWindow.getShell(), 400, rectangle, rectangle2);
    }

    public static void animateUp(Rectangle rectangle) {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return;
        }
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchWindow;
        Point point = workbenchWindow.getShell().getLocation();
        ProgressRegion progressRegion = workbenchWindow.getProgressRegion();
        if (progressRegion == null) {
            return;
        }
        Rectangle rectangle2 = progressRegion.getControl().getBounds();
        rectangle2.x += point.x;
        rectangle2.y += point.y;
        AnimationEngine.createTweakedAnimation(workbenchWindow.getShell(), 400, rectangle2, rectangle);
    }

    static IShellProvider getShellProvider() {
        return new IShellProvider(){

            public Shell getShell() {
                return ProgressManagerUtil.getDefaultParent();
            }
        };
    }

    public static URL getIconsRoot() {
        return BundleUtility.find("org.eclipse.ui", "$nl$/icons/full/progress/");
    }

    public static URL getProgressSpinnerLocation() {
        try {
            return new URL(ProgressManagerUtil.getIconsRoot(), "progress_spinner.gif");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

