/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogBlockedHandler;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.EventLoopProgressMonitor;
import org.eclipse.ui.internal.dialogs.WorkbenchDialogBlockedHandler;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.IJobBusyListener;
import org.eclipse.ui.internal.progress.IJobProgressManagerListener;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressMonitorFocusJobDialog;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.internal.progress.ProgressViewUpdater;
import org.eclipse.ui.internal.progress.StatusAdapterHelper;
import org.eclipse.ui.internal.progress.TaskInfo;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class ProgressManager
extends ProgressProvider
implements IProgressService {
    public static final QualifiedName PROPERTY_IN_DIALOG = IProgressConstants.PROPERTY_IN_DIALOG;
    private static final String ERROR_JOB = "errorstate.gif";
    static final String ERROR_JOB_KEY = "ERROR_JOB";
    private static ProgressManager singleton;
    private final Map jobs = Collections.synchronizedMap(new HashMap());
    private final Map familyListeners = Collections.synchronizedMap(new HashMap());
    private ListenerList listeners = new ListenerList();
    final IJobChangeListener changeListener;
    static final String PROGRESS_VIEW_NAME = "org.eclipse.ui.views.ProgressView";
    static final String PROGRESS_FOLDER = "$nl$/icons/full/progress/";
    private static final String SLEEPING_JOB = "sleeping.gif";
    private static final String WAITING_JOB = "waiting.gif";
    private static final String BLOCKED_JOB = "lockedstate.gif";
    public static final String SLEEPING_JOB_KEY = "SLEEPING_JOB";
    public static final String WAITING_JOB_KEY = "WAITING_JOB";
    public static final String BLOCKED_JOB_KEY = "LOCKED_JOB";
    final Map runnableMonitors = Collections.synchronizedMap(new HashMap());
    private Hashtable imageKeyTable = new Hashtable();
    private final StatusManager.INotificationListener notificationListener;
    private static final String IMAGE_KEY = "org.eclipse.ui.progress.images";

    public static ProgressManager getInstance() {
        if (singleton == null) {
            singleton = new ProgressManager();
        }
        return singleton;
    }

    public static void shutdownProgressManager() {
        if (singleton == null) {
            return;
        }
        StatusManager.getManager().removeListener(ProgressManager.singleton.notificationListener);
        singleton.shutdown();
    }

    ProgressManager() {
        Dialog.setBlockedHandler((IDialogBlockedHandler)new WorkbenchDialogBlockedHandler());
        this.setUpImages();
        this.changeListener = this.createChangeListener();
        this.notificationListener = this.createNotificationListener();
        Job.getJobManager().setProgressProvider((ProgressProvider)this);
        Job.getJobManager().addJobChangeListener(this.changeListener);
        StatusManager.getManager().addListener(this.notificationListener);
    }

    private void setUpImages() {
        URL uRL = ProgressManagerUtil.getIconsRoot();
        try {
            this.setUpImage(uRL, SLEEPING_JOB, SLEEPING_JOB_KEY);
            this.setUpImage(uRL, WAITING_JOB, WAITING_JOB_KEY);
            this.setUpImage(uRL, BLOCKED_JOB, BLOCKED_JOB_KEY);
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)new URL(uRL, ERROR_JOB));
            JFaceResources.getImageRegistry().put(ERROR_JOB_KEY, imageDescriptor);
        }
        catch (MalformedURLException malformedURLException) {
            ProgressManagerUtil.logException(malformedURLException);
        }
    }

    private StatusManager.INotificationListener createNotificationListener() {
        return new StatusManager.INotificationListener(){

            @Override
            public void statusManagerNotified(int n, StatusAdapter[] statusAdapterArray) {
                if (n == 1) {
                    FinishedJobs.getInstance().removeErrorJobs();
                    StatusAdapterHelper.getInstance().clear();
                }
            }
        };
    }

    private IJobChangeListener createChangeListener() {
        return new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent iJobChangeEvent) {
                JobInfo jobInfo = ProgressManager.this.getJobInfo(iJobChangeEvent.getJob());
                ProgressManager.this.refreshJobInfo(jobInfo);
                for (IJobBusyListener iJobBusyListener : ProgressManager.this.busyListenersForJob(iJobChangeEvent.getJob())) {
                    iJobBusyListener.incrementBusy(iJobChangeEvent.getJob());
                }
            }

            public void done(IJobChangeEvent iJobChangeEvent) {
                Object object2;
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                for (Object object2 : ProgressManager.this.busyListenersForJob(iJobChangeEvent.getJob())) {
                    object2.decrementBusy(iJobChangeEvent.getJob());
                }
                object2 = ProgressManager.this.getJobInfo(iJobChangeEvent.getJob());
                ProgressManager.this.removeJobInfo((JobInfo)object2);
                if (iJobChangeEvent.getResult() != null && iJobChangeEvent.getResult().getSeverity() == 4) {
                    StatusAdapter statusAdapter = new StatusAdapter(iJobChangeEvent.getResult());
                    statusAdapter.addAdapter(Job.class, iJobChangeEvent.getJob());
                    if (iJobChangeEvent.getJob().getProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY) == Boolean.TRUE) {
                        statusAdapter.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
                        StatusAdapterHelper.getInstance().putStatusAdapter((JobInfo)object2, statusAdapter);
                    }
                    StatusManager.getManager().handle(statusAdapter, 2);
                }
            }

            public void scheduled(IJobChangeEvent iJobChangeEvent) {
                boolean bl;
                this.updateFor(iJobChangeEvent);
                if (iJobChangeEvent.getJob().isUser() && !(bl = ProgressManager.this.shouldRunInBackground())) {
                    final IJobChangeEvent iJobChangeEvent2 = iJobChangeEvent;
                    WorkbenchJob workbenchJob = new WorkbenchJob(ProgressMessages.ProgressManager_showInDialogName){

                        @Override
                        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                            ProgressManager.this.showInDialog(null, iJobChangeEvent2.getJob());
                            return Status.OK_STATUS;
                        }
                    };
                    workbenchJob.setSystem(true);
                    workbenchJob.schedule();
                    return;
                }
            }

            private void updateFor(IJobChangeEvent iJobChangeEvent) {
                if (ProgressManager.this.isInfrastructureJob(iJobChangeEvent.getJob())) {
                    return;
                }
                if (ProgressManager.this.jobs.containsKey(iJobChangeEvent.getJob())) {
                    ProgressManager.this.refreshJobInfo(ProgressManager.this.getJobInfo(iJobChangeEvent.getJob()));
                } else {
                    ProgressManager.this.addJobInfo(new JobInfo(iJobChangeEvent.getJob()));
                }
            }

            public void awake(IJobChangeEvent iJobChangeEvent) {
                this.updateFor(iJobChangeEvent);
            }

            public void sleeping(IJobChangeEvent iJobChangeEvent) {
                if (ProgressManager.this.jobs.containsKey(iJobChangeEvent.getJob())) {
                    ProgressManager.this.sleepJobInfo(ProgressManager.this.getJobInfo(iJobChangeEvent.getJob()));
                }
            }
        };
    }

    protected void sleepJobInfo(JobInfo jobInfo) {
        if (this.isInfrastructureJob(jobInfo.getJob())) {
            return;
        }
        GroupInfo groupInfo = jobInfo.getGroupInfo();
        if (groupInfo != null) {
            this.sleepGroup(groupInfo, jobInfo);
        }
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            IJobProgressManagerListener iJobProgressManagerListener = (IJobProgressManagerListener)objectArray[n];
            if (!this.isNeverDisplaying(jobInfo.getJob(), iJobProgressManagerListener.showsDebug())) {
                if (iJobProgressManagerListener.showsDebug()) {
                    iJobProgressManagerListener.refreshJobInfo(jobInfo);
                } else {
                    iJobProgressManagerListener.removeJob(jobInfo);
                }
            }
            ++n;
        }
    }

    private void sleepGroup(GroupInfo groupInfo, JobInfo jobInfo) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            IJobProgressManagerListener iJobProgressManagerListener = (IJobProgressManagerListener)objectArray[n];
            if (!this.isNeverDisplaying(jobInfo.getJob(), iJobProgressManagerListener.showsDebug())) {
                if (iJobProgressManagerListener.showsDebug() || groupInfo.isActive()) {
                    iJobProgressManagerListener.refreshGroup(groupInfo);
                } else {
                    iJobProgressManagerListener.removeGroup(groupInfo);
                }
            }
            ++n;
        }
    }

    private void setUpImage(URL uRL, String string, String string2) throws MalformedURLException {
        JFaceResources.getImageRegistry().put(string2, ImageDescriptor.createFromURL((URL)new URL(uRL, string)));
    }

    public IProgressMonitor createMonitor(Job job) {
        return this.progressFor(job);
    }

    public IProgressMonitor getDefaultMonitor() {
        Display display;
        if (PlatformUI.isWorkbenchRunning() && !PlatformUI.getWorkbench().isStarting() && !(display = PlatformUI.getWorkbench().getDisplay()).isDisposed() && display.getThread() == Thread.currentThread()) {
            return new EventLoopProgressMonitor((IProgressMonitor)new NullProgressMonitor());
        }
        return super.getDefaultMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobMonitor progressFor(Job job) {
        Map map = this.runnableMonitors;
        synchronized (map) {
            JobMonitor jobMonitor = (JobMonitor)this.runnableMonitors.get(job);
            if (jobMonitor == null) {
                jobMonitor = new JobMonitor(job);
                this.runnableMonitors.put(job, jobMonitor);
            }
            return jobMonitor;
        }
    }

    void addListener(IJobProgressManagerListener iJobProgressManagerListener) {
        this.listeners.add((Object)iJobProgressManagerListener);
    }

    void removeListener(IJobProgressManagerListener iJobProgressManagerListener) {
        this.listeners.remove((Object)iJobProgressManagerListener);
    }

    JobInfo getJobInfo(Job job) {
        JobInfo jobInfo = this.internalGetJobInfo(job);
        if (jobInfo == null) {
            jobInfo = new JobInfo(job);
            this.jobs.put(job, jobInfo);
        }
        return jobInfo;
    }

    JobInfo internalGetJobInfo(Job job) {
        return (JobInfo)this.jobs.get(job);
    }

    public void refreshJobInfo(JobInfo jobInfo) {
        GroupInfo groupInfo = jobInfo.getGroupInfo();
        if (groupInfo != null) {
            this.refreshGroup(groupInfo);
        }
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            IJobProgressManagerListener iJobProgressManagerListener = (IJobProgressManagerListener)objectArray[n];
            if (!this.isCurrentDisplaying(jobInfo.getJob(), iJobProgressManagerListener.showsDebug())) {
                iJobProgressManagerListener.refreshJobInfo(jobInfo);
            }
            ++n;
        }
    }

    public void refreshGroup(GroupInfo groupInfo) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IJobProgressManagerListener)objectArray[n]).refreshGroup(groupInfo);
            ++n;
        }
    }

    public void refreshAll() {
        this.pruneStaleJobs();
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IJobProgressManagerListener)objectArray[n]).refreshAll();
            ++n;
        }
    }

    public void removeJobInfo(JobInfo jobInfo) {
        Job job = jobInfo.getJob();
        this.jobs.remove(job);
        this.runnableMonitors.remove(job);
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            IJobProgressManagerListener iJobProgressManagerListener = (IJobProgressManagerListener)objectArray[n];
            if (!this.isCurrentDisplaying(jobInfo.getJob(), iJobProgressManagerListener.showsDebug())) {
                iJobProgressManagerListener.removeJob(jobInfo);
            }
            ++n;
        }
    }

    public void removeGroup(GroupInfo groupInfo) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IJobProgressManagerListener)objectArray[n]).removeGroup(groupInfo);
            ++n;
        }
    }

    public void addJobInfo(JobInfo jobInfo) {
        GroupInfo groupInfo = jobInfo.getGroupInfo();
        if (groupInfo != null) {
            this.refreshGroup(groupInfo);
        }
        this.jobs.put(jobInfo.getJob(), jobInfo);
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            IJobProgressManagerListener iJobProgressManagerListener = (IJobProgressManagerListener)objectArray[n];
            if (!this.isCurrentDisplaying(jobInfo.getJob(), iJobProgressManagerListener.showsDebug())) {
                iJobProgressManagerListener.addJob(jobInfo);
            }
            ++n;
        }
    }

    boolean isCurrentDisplaying(Job job, boolean bl) {
        return this.isNeverDisplaying(job, bl) || job.getState() == 1;
    }

    boolean isNeverDisplaying(Job job, boolean bl) {
        if (this.isInfrastructureJob(job)) {
            return true;
        }
        if (bl) {
            return false;
        }
        return job.isSystem();
    }

    private boolean isInfrastructureJob(Job job) {
        if (Policy.DEBUG_SHOW_ALL_JOBS) {
            return false;
        }
        return job.getProperty(ProgressManagerUtil.INFRASTRUCTURE_PROPERTY) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo[] getJobInfos(boolean bl) {
        Map map = this.jobs;
        synchronized (map) {
            Job job;
            Iterator iterator = this.jobs.keySet().iterator();
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                job = (Job)iterator.next();
                if (this.isCurrentDisplaying(job, bl)) continue;
                arrayList.add(this.jobs.get(job));
            }
            job = new JobInfo[arrayList.size()];
            arrayList.toArray((T[])job);
            return job;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobTreeElement[] getRootElements(boolean bl) {
        Map map = this.jobs;
        synchronized (map) {
            Job job;
            Iterator iterator = this.jobs.keySet().iterator();
            HashSet<JobTreeElement> hashSet = new HashSet<JobTreeElement>();
            while (iterator.hasNext()) {
                job = (Job)iterator.next();
                if (this.isCurrentDisplaying(job, bl)) continue;
                JobInfo jobInfo = (JobInfo)this.jobs.get(job);
                GroupInfo groupInfo = jobInfo.getGroupInfo();
                if (groupInfo == null) {
                    hashSet.add(jobInfo);
                    continue;
                }
                hashSet.add(groupInfo);
            }
            job = new JobTreeElement[hashSet.size()];
            hashSet.toArray((T[])job);
            return job;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasJobInfos() {
        Map map = this.jobs;
        synchronized (map) {
            block4: {
                Iterator iterator = this.jobs.keySet().iterator();
                if (!iterator.hasNext()) break block4;
                return true;
            }
            return false;
        }
    }

    Image getImage(ImageData imageData) {
        ImageData imageData2 = imageData.getTransparencyMask();
        return new Image(null, imageData, imageData2);
    }

    ImageData[] getImageData(URL uRL, ImageLoader imageLoader) {
        try {
            InputStream inputStream = uRL.openStream();
            ImageData[] imageDataArray = imageLoader.load(inputStream);
            inputStream.close();
            return imageDataArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
            ProgressManagerUtil.logException(fileNotFoundException);
            return null;
        }
        catch (IOException iOException) {
            ProgressManagerUtil.logException(iOException);
            return null;
        }
    }

    @Override
    public void busyCursorWhile(final IRunnableWithProgress iRunnableWithProgress) throws InvocationTargetException, InterruptedException {
        final ProgressMonitorJobsDialog progressMonitorJobsDialog = new ProgressMonitorJobsDialog(ProgressManagerUtil.getDefaultParent());
        progressMonitorJobsDialog.setOpenOnRun(false);
        final InvocationTargetException[] invocationTargetExceptionArray = new InvocationTargetException[1];
        final InterruptedException[] interruptedExceptionArray = new InterruptedException[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        progressMonitorJobsDialog.setOpenOnRun(false);
                        ProgressManager.this.setUserInterfaceActive(false);
                        progressMonitorJobsDialog.run(true, true, iRunnableWithProgress);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetExceptionArray[0] = invocationTargetException;
                        ProgressManager.this.setUserInterfaceActive(true);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedExceptionArray[0] = interruptedException;
                        ProgressManager.this.setUserInterfaceActive(true);
                    }
                }
                finally {
                    ProgressManager.this.setUserInterfaceActive(true);
                }
            }
        };
        this.busyCursorWhile(runnable, progressMonitorJobsDialog);
        if (invocationTargetExceptionArray[0] != null) {
            throw invocationTargetExceptionArray[0];
        }
        if (interruptedExceptionArray[0] != null) {
            throw interruptedExceptionArray[0];
        }
    }

    private void busyCursorWhile(Runnable runnable, ProgressMonitorJobsDialog progressMonitorJobsDialog) {
        this.scheduleProgressMonitorJob(progressMonitorJobsDialog);
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null) {
            return;
        }
        BusyIndicator.showWhile((Display)display, (Runnable)runnable);
    }

    private void scheduleProgressMonitorJob(final ProgressMonitorJobsDialog progressMonitorJobsDialog) {
        WorkbenchJob workbenchJob = new WorkbenchJob(ProgressMessages.ProgressManager_openJobName){

            @Override
            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                ProgressManager.this.setUserInterfaceActive(true);
                if (ProgressManagerUtil.safeToOpen(progressMonitorJobsDialog, null)) {
                    progressMonitorJobsDialog.open();
                }
                return Status.OK_STATUS;
            }
        };
        workbenchJob.setSystem(true);
        workbenchJob.schedule(this.getLongOperationTime());
    }

    private void shutdown() {
        this.listeners.clear();
        Job.getJobManager().setProgressProvider(null);
        Job.getJobManager().removeJobChangeListener(this.changeListener);
    }

    public IProgressMonitor createProgressGroup() {
        return new GroupInfo();
    }

    public IProgressMonitor createMonitor(Job job, IProgressMonitor iProgressMonitor, int n) {
        JobMonitor jobMonitor = this.progressFor(job);
        if (iProgressMonitor instanceof GroupInfo) {
            GroupInfo groupInfo = (GroupInfo)iProgressMonitor;
            JobInfo jobInfo = this.getJobInfo(job);
            jobInfo.setGroupInfo(groupInfo);
            jobInfo.setTicks(n);
            groupInfo.addJobInfo(jobInfo);
        }
        return jobMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListenerToFamily(Object object, IJobBusyListener iJobBusyListener) {
        Map map = this.familyListeners;
        synchronized (map) {
            HashSet<IJobBusyListener> hashSet = (HashSet<IJobBusyListener>)this.familyListeners.get(object);
            if (hashSet == null) {
                hashSet = new HashSet<IJobBusyListener>();
                this.familyListeners.put(object, hashSet);
            }
            hashSet.add(iJobBusyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(IJobBusyListener iJobBusyListener) {
        Map map = this.familyListeners;
        synchronized (map) {
            Iterator iterator = this.familyListeners.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Collection collection = (Collection)this.familyListeners.get(k);
                collection.remove(iJobBusyListener);
                if (!collection.isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection busyListenersForJob(Job job) {
        if (job.isSystem()) {
            return Collections.EMPTY_LIST;
        }
        Map map = this.familyListeners;
        synchronized (map) {
            if (this.familyListeners.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            Iterator iterator = this.familyListeners.keySet().iterator();
            HashSet hashSet = new HashSet();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (!job.belongsTo(k)) continue;
                Collection collection = (Collection)this.familyListeners.get(k);
                hashSet.addAll(collection);
            }
            return hashSet;
        }
    }

    @Override
    public void showInDialog(Shell shell, Job job) {
        if (this.shouldRunInBackground()) {
            return;
        }
        ProgressMonitorFocusJobDialog progressMonitorFocusJobDialog = new ProgressMonitorFocusJobDialog(shell);
        progressMonitorFocusJobDialog.show(job, shell);
    }

    @Override
    public void run(boolean bl, boolean bl2, IRunnableWithProgress iRunnableWithProgress) throws InvocationTargetException, InterruptedException {
        if (!bl || !bl2) {
            ProgressMonitorJobsDialog progressMonitorJobsDialog = new ProgressMonitorJobsDialog(null);
            progressMonitorJobsDialog.run(bl, bl2, iRunnableWithProgress);
            return;
        }
        this.busyCursorWhile(iRunnableWithProgress);
    }

    @Override
    public void runInUI(IRunnableContext iRunnableContext, IRunnableWithProgress iRunnableWithProgress, ISchedulingRule iSchedulingRule) throws InvocationTargetException, InterruptedException {
        final RunnableWithStatus runnableWithStatus = new RunnableWithStatus(iRunnableContext, iRunnableWithProgress, iSchedulingRule);
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                BusyIndicator.showWhile((Display)display, (Runnable)runnableWithStatus);
            }
        });
        IStatus iStatus = runnableWithStatus.getStatus();
        if (!iStatus.isOK()) {
            Throwable throwable = iStatus.getException();
            if (throwable instanceof InvocationTargetException) {
                throw (InvocationTargetException)throwable;
            }
            if (throwable instanceof InterruptedException) {
                throw (InterruptedException)throwable;
            }
            throw new InterruptedException(throwable.getMessage());
        }
    }

    @Override
    public int getLongOperationTime() {
        return 800;
    }

    @Override
    public void registerIconForFamily(ImageDescriptor imageDescriptor, Object object) {
        String string = IMAGE_KEY + String.valueOf(this.imageKeyTable.size());
        this.imageKeyTable.put(object, string);
        ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
        if (imageRegistry.getDescriptor(string) == null) {
            imageRegistry.put(string, imageDescriptor);
        }
    }

    @Override
    public Image getIconFor(Job job) {
        Enumeration enumeration = this.imageKeyTable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!job.belongsTo(k)) continue;
            return JFaceResources.getImageRegistry().get((String)this.imageKeyTable.get(k));
        }
        return null;
    }

    private void setUserInterfaceActive(boolean bl) {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Shell[] shellArray = iWorkbench.getDisplay().getShells();
        if (bl) {
            int n = 0;
            while (n < shellArray.length) {
                if (!shellArray[n].isDisposed()) {
                    shellArray[n].setEnabled(bl);
                }
                ++n;
            }
        } else {
            int n = shellArray.length - 1;
            while (n >= 0) {
                if (!shellArray[n].isDisposed()) {
                    shellArray[n].setEnabled(bl);
                }
                --n;
            }
        }
    }

    private boolean pruneStaleJobs() {
        Object[] objectArray = this.jobs.keySet().toArray();
        boolean bl = false;
        int n = 0;
        while (n < objectArray.length) {
            Job job = (Job)objectArray[n];
            if (this.checkForStaleness(job)) {
                if (Policy.DEBUG_STALE_JOBS) {
                    WorkbenchPlugin.log("Stale Job " + job.getName());
                }
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    boolean checkForStaleness(Job job) {
        if (job.getState() == 0) {
            this.removeJobInfo(this.getJobInfo(job));
            return true;
        }
        return false;
    }

    private boolean shouldRunInBackground() {
        return WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("RUN_IN_BACKGROUND");
    }

    public void setShowSystemJobs(boolean bl) {
        ProgressViewUpdater progressViewUpdater = ProgressViewUpdater.getSingleton();
        progressViewUpdater.debug = bl;
        progressViewUpdater.refreshAll();
    }

    class JobMonitor
    implements IProgressMonitorWithBlocking {
        Job job;
        String currentTaskName;
        IProgressMonitorWithBlocking listener;

        JobMonitor(Job job) {
            this.job = job;
        }

        void addProgressListener(IProgressMonitorWithBlocking iProgressMonitorWithBlocking) {
            this.listener = iProgressMonitorWithBlocking;
            JobInfo jobInfo = ProgressManager.this.getJobInfo(this.job);
            TaskInfo taskInfo = jobInfo.getTaskInfo();
            if (taskInfo != null) {
                this.listener.beginTask(this.currentTaskName, taskInfo.totalWork);
                this.listener.internalWorked(taskInfo.preWork);
            }
        }

        public void beginTask(String string, int n) {
            JobInfo jobInfo = ProgressManager.this.getJobInfo(this.job);
            jobInfo.beginTask(string, n);
            ProgressManager.this.refreshJobInfo(jobInfo);
            this.currentTaskName = string;
            if (this.listener != null) {
                this.listener.beginTask(string, n);
            }
        }

        public void done() {
            JobInfo jobInfo = ProgressManager.this.getJobInfo(this.job);
            jobInfo.clearTaskInfo();
            jobInfo.clearChildren();
            ProgressManager.this.runnableMonitors.remove(this.job);
            if (this.listener != null) {
                this.listener.done();
            }
        }

        public void internalWorked(double d) {
            JobInfo jobInfo = ProgressManager.this.getJobInfo(this.job);
            if (jobInfo.hasTaskInfo()) {
                jobInfo.addWork(d);
                ProgressManager.this.refreshJobInfo(jobInfo);
            }
            if (this.listener != null) {
                this.listener.internalWorked(d);
            }
        }

        public boolean isCanceled() {
            JobInfo jobInfo = ProgressManager.this.internalGetJobInfo(this.job);
            if (jobInfo == null) {
                return false;
            }
            return jobInfo.isCanceled();
        }

        public void setCanceled(boolean bl) {
            JobInfo jobInfo = ProgressManager.this.getJobInfo(this.job);
            if (bl && !jobInfo.isCanceled()) {
                jobInfo.cancel();
                if (this.listener != null) {
                    this.listener.setCanceled(bl);
                }
            }
        }

        public void setTaskName(String string) {
            JobInfo jobInfo = ProgressManager.this.getJobInfo(this.job);
            if (!jobInfo.hasTaskInfo()) {
                this.beginTask(string, 100);
                return;
            }
            jobInfo.setTaskName(string);
            jobInfo.clearChildren();
            ProgressManager.this.refreshJobInfo(jobInfo);
            this.currentTaskName = string;
            if (this.listener != null) {
                this.listener.setTaskName(string);
            }
        }

        public void subTask(String string) {
            if (string == null) {
                return;
            }
            JobInfo jobInfo = ProgressManager.this.getJobInfo(this.job);
            jobInfo.clearChildren();
            jobInfo.addSubTask(string);
            ProgressManager.this.refreshJobInfo(jobInfo);
            if (this.listener != null) {
                this.listener.subTask(string);
            }
        }

        public void worked(int n) {
            this.internalWorked(n);
        }

        public void clearBlocked() {
            JobInfo jobInfo = ProgressManager.this.getJobInfo(this.job);
            jobInfo.setBlockedStatus(null);
            ProgressManager.this.refreshJobInfo(jobInfo);
            if (this.listener != null) {
                this.listener.clearBlocked();
            }
        }

        public void setBlocked(IStatus iStatus) {
            JobInfo jobInfo = ProgressManager.this.getJobInfo(this.job);
            jobInfo.setBlockedStatus(iStatus);
            ProgressManager.this.refreshJobInfo(jobInfo);
            if (this.listener != null) {
                this.listener.setBlocked(iStatus);
            }
        }
    }

    private class RunnableWithStatus
    implements Runnable {
        IStatus status = Status.OK_STATUS;
        private final IRunnableContext context;
        private final IRunnableWithProgress runnable;
        private final ISchedulingRule rule;

        public RunnableWithStatus(IRunnableContext iRunnableContext, IRunnableWithProgress iRunnableWithProgress, ISchedulingRule iSchedulingRule) {
            this.context = iRunnableContext;
            this.runnable = iRunnableWithProgress;
            this.rule = iSchedulingRule;
        }

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            IJobManager iJobManager = Job.getJobManager();
            try {
                try {
                    iJobManager.beginRule(this.rule, this.getEventLoopMonitor());
                    this.context.run(false, false, this.runnable);
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.status = new Status(4, "org.eclipse.ui", invocationTargetException.getMessage(), (Throwable)invocationTargetException);
                    iJobManager.endRule(this.rule);
                }
                catch (InterruptedException interruptedException) {
                    this.status = new Status(4, "org.eclipse.ui", interruptedException.getMessage(), (Throwable)interruptedException);
                    iJobManager.endRule(this.rule);
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.status = new Status(4, "org.eclipse.ui", operationCanceledException.getMessage(), (Throwable)operationCanceledException);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    iJobManager.endRule(this.rule);
                }
            }
            finally {
                iJobManager.endRule(this.rule);
            }
        }

        private IProgressMonitor getEventLoopMonitor() {
            if (PlatformUI.getWorkbench().isStarting()) {
                return new NullProgressMonitor();
            }
            return new EventLoopProgressMonitor((IProgressMonitor)new NullProgressMonitor()){

                @Override
                public void setBlocked(IStatus iStatus) {
                    Dialog.getBlockedHandler().showBlocked(ProgressManagerUtil.getDefaultParent(), (IProgressMonitor)this, iStatus, this.getTaskName());
                }
            };
        }

        public IStatus getStatus() {
            return this.status;
        }
    }
}

