/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import com.ibm.icu.text.DateFormat;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Util;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.TaskInfo;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.IProgressConstants2;
import org.eclipse.ui.statushandlers.StatusManager;

public class ProgressInfoItem
extends Composite {
    static String STOP_IMAGE_KEY = "org.eclipse.ui.internal.progress.PROGRESS_STOP";
    static String DISABLED_STOP_IMAGE_KEY = "org.eclipse.ui.internal.progress.DISABLED_PROGRESS_STOP";
    static String CLEAR_FINISHED_JOB_KEY = "org.eclipse.ui.internal.progress.CLEAR_FINISHED_JOB";
    static String DISABLED_CLEAR_FINISHED_JOB_KEY = "org.eclipse.ui.internal.progress.DISABLED_CLEAR_FINISHED_JOB";
    static String DEFAULT_JOB_KEY = "org.eclipse.ui.internal.progress.PROGRESS_DEFAULT";
    static String DARK_COLOR_KEY = "org.eclipse.ui.internal.progress.PROGRESS_DARK_COLOR";
    JobTreeElement info;
    Label progressLabel;
    ToolBar actionBar;
    ToolItem actionButton;
    List taskEntries = new ArrayList(0);
    private ProgressBar progressBar;
    private Label jobImageLabel;
    static final int MAX_PROGRESS_HEIGHT = 12;
    static final int MIN_ICON_SIZE = 16;
    private static final String TEXT_KEY = "Text";
    private static final String TRIGGER_KEY = "Trigger";
    IndexListener indexListener;
    private int currentIndex;
    private boolean selected;
    private MouseAdapter mouseListener;
    private boolean isShowing = true;
    private ResourceManager resourceManager;
    private Link link;

    static {
        JFaceResources.getImageRegistry().put(STOP_IMAGE_KEY, WorkbenchImages.getWorkbenchImageDescriptor("elcl16/progress_stop.gif"));
        JFaceResources.getImageRegistry().put(DISABLED_STOP_IMAGE_KEY, WorkbenchImages.getWorkbenchImageDescriptor("dlcl16/progress_stop.gif"));
        JFaceResources.getImageRegistry().put(DEFAULT_JOB_KEY, WorkbenchImages.getWorkbenchImageDescriptor("progress/progress_task.gif"));
        JFaceResources.getImageRegistry().put(CLEAR_FINISHED_JOB_KEY, WorkbenchImages.getWorkbenchImageDescriptor("elcl16/progress_rem.gif"));
        JFaceResources.getImageRegistry().put(DISABLED_CLEAR_FINISHED_JOB_KEY, WorkbenchImages.getWorkbenchImageDescriptor("dlcl16/progress_rem.gif"));
        int n = Util.isMac() ? -25 : -10;
        Color color = PlatformUI.getWorkbench().getDisplay().getSystemColor(25);
        RGB rGB = new RGB(Math.max(0, color.getRed() + n), Math.max(0, color.getGreen() + n), Math.max(0, color.getBlue() + n));
        JFaceResources.getColorRegistry().put(DARK_COLOR_KEY, rGB);
    }

    public ProgressInfoItem(Composite composite, int n, JobTreeElement jobTreeElement) {
        super(composite, n);
        this.info = jobTreeElement;
        this.createChildren();
        this.setData(this.info);
        this.setLayoutData(new GridData(4, 0, true, false));
    }

    protected void createChildren() {
        FormLayout formLayout = new FormLayout();
        this.setLayout((Layout)formLayout);
        this.jobImageLabel = new Label((Composite)this, 0);
        Image image = this.getInfoImage();
        this.jobImageLabel.setImage(image);
        FormData formData = new FormData();
        formData.top = image != null ? new FormAttachment(50, -image.getBounds().height / 2) : new FormAttachment(0, 4);
        formData.left = new FormAttachment(0, 2);
        this.jobImageLabel.setLayoutData((Object)formData);
        this.progressLabel = new Label((Composite)this, 0);
        this.setMainText();
        this.actionBar = new ToolBar((Composite)this, 0x800000);
        this.actionBar.setCursor(this.getDisplay().getSystemCursor(0));
        this.actionButton = new ToolItem(this.actionBar, 0);
        this.actionButton.setToolTipText(ProgressMessages.NewProgressView_CancelJobToolTip);
        this.actionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProgressInfoItem.this.actionButton.setEnabled(false);
                ProgressInfoItem.this.cancelOrRemove();
            }
        });
        this.actionBar.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (ProgressInfoItem.this.indexListener == null) {
                    return;
                }
                int n = event.detail;
                if (n == 64) {
                    ProgressInfoItem.this.indexListener.selectNext();
                }
                if (n == 32) {
                    ProgressInfoItem.this.indexListener.selectPrevious();
                }
            }
        });
        this.updateToolBarValues();
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment(0, 4);
        formData2.left = new FormAttachment((Control)this.jobImageLabel, 2);
        formData2.right = new FormAttachment((Control)this.actionBar, -4);
        this.progressLabel.setLayoutData((Object)formData2);
        this.mouseListener = new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                if (ProgressInfoItem.this.indexListener != null) {
                    ProgressInfoItem.this.indexListener.select();
                }
            }
        };
        this.addMouseListener((MouseListener)this.mouseListener);
        this.jobImageLabel.addMouseListener((MouseListener)this.mouseListener);
        this.progressLabel.addMouseListener((MouseListener)this.mouseListener);
        this.setLayoutsForNoProgress();
        this.refresh();
    }

    private void setMainText() {
        this.progressLabel.setText(Dialog.shortenText((String)this.getMainTitle(), (Control)this.progressLabel));
    }

    private void setLayoutsForNoProgress() {
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.progressLabel, 0, 128);
        formData.right = new FormAttachment(100, -4);
        this.actionBar.setLayoutData((Object)formData);
        if (this.taskEntries.size() > 0) {
            FormData formData2 = new FormData();
            formData2.top = new FormAttachment((Control)this.progressLabel, 4);
            formData2.left = new FormAttachment((Control)this.progressLabel, 0, 16384);
            formData2.right = new FormAttachment((Control)this.actionBar, 0, 16384);
            ((Link)this.taskEntries.get(0)).setLayoutData((Object)formData2);
        }
    }

    protected void cancelOrRemove() {
        if (FinishedJobs.getInstance().isKept(this.info) && this.isCompleted()) {
            FinishedJobs.getInstance().remove(this.info);
        } else {
            this.info.cancel();
        }
    }

    private Image getInfoImage() {
        if (!this.info.isJobInfo()) {
            return JFaceResources.getImage((String)DEFAULT_JOB_KEY);
        }
        JobInfo jobInfo = (JobInfo)this.info;
        ImageDescriptor imageDescriptor = null;
        Object object = jobInfo.getJob().getProperty(IProgressConstants.ICON_PROPERTY);
        if (object instanceof ImageDescriptor) {
            imageDescriptor = (ImageDescriptor)object;
        } else if (object instanceof URL) {
            imageDescriptor = ImageDescriptor.createFromURL((URL)((URL)object));
        }
        Image image = null;
        image = imageDescriptor == null ? ProgressManager.getInstance().getIconFor(jobInfo.getJob()) : this.getResourceManager().createImageWithDefault(imageDescriptor);
        if (image == null) {
            image = jobInfo.getDisplayImage();
        }
        return image;
    }

    private ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resourceManager;
    }

    private String getMainTitle() {
        if (this.info.isJobInfo()) {
            return this.getJobNameAndStatus((JobInfo)this.info);
        }
        if (this.info.hasChildren()) {
            return ((GroupInfo)this.info).getTaskName();
        }
        return this.info.getDisplayString();
    }

    public String getJobNameAndStatus(JobInfo jobInfo) {
        Job job = jobInfo.getJob();
        String string = job.getName();
        if (job.isSystem()) {
            string = NLS.bind((String)ProgressMessages.JobInfo_System, (Object)string);
        }
        if (jobInfo.isCanceled()) {
            if (job.getState() == 4) {
                return NLS.bind((String)ProgressMessages.JobInfo_Cancel_Requested, (Object)string);
            }
            return NLS.bind((String)ProgressMessages.JobInfo_Cancelled, (Object)string);
        }
        if (jobInfo.isBlocked()) {
            IStatus iStatus = jobInfo.getBlockedStatus();
            return NLS.bind((String)ProgressMessages.JobInfo_Blocked, (Object)string, (Object)iStatus.getMessage());
        }
        switch (job.getState()) {
            case 4: {
                return string;
            }
            case 1: {
                return NLS.bind((String)ProgressMessages.JobInfo_Sleeping, (Object)string);
            }
            case 0: {
                return this.getJobInfoFinishedString(job, true);
            }
        }
        return NLS.bind((String)ProgressMessages.JobInfo_Waiting, (Object)string);
    }

    String getJobInfoFinishedString(Job job, boolean bl) {
        String string = null;
        if (bl) {
            string = this.getTimeString();
        }
        if (string != null) {
            return NLS.bind((String)ProgressMessages.JobInfo_FinishedAt, (Object)job.getName(), (Object)string);
        }
        return NLS.bind((String)ProgressMessages.JobInfo_Finished, (Object)job.getName());
    }

    private String getTimeString() {
        Date date = FinishedJobs.getInstance().getFinishDate(this.info);
        if (date != null) {
            return DateFormat.getTimeInstance((int)3).format(date);
        }
        return null;
    }

    void refresh() {
        int n;
        if (this.isDisposed() || !this.isShowing) {
            return;
        }
        this.jobImageLabel.setImage(this.getInfoImage());
        int n2 = this.getPercentDone();
        ProgressBar progressBar = this.progressBar;
        JobInfo[] jobInfoArray = this.getJobInfos();
        if (this.isRunning()) {
            if (this.progressBar == null) {
                if (n2 == -1) {
                    n = 0;
                    while (n < jobInfoArray.length) {
                        if (jobInfoArray[n].hasTaskInfo() && jobInfoArray[n].getTaskInfo().totalWork == -1) {
                            this.createProgressBar(2);
                            break;
                        }
                        ++n;
                    }
                } else {
                    this.createProgressBar(0);
                    this.progressBar.setMinimum(0);
                    this.progressBar.setMaximum(100);
                }
            }
            if (n2 >= 0 && n2 <= 100 && n2 != this.progressBar.getSelection()) {
                this.progressBar.setSelection(n2);
            }
        } else if (this.isCompleted()) {
            if (this.progressBar != null) {
                this.progressBar.dispose();
                this.progressBar = null;
            }
            this.setLayoutsForNoProgress();
        }
        n = 0;
        while (n < jobInfoArray.length) {
            Object object;
            String string;
            JobInfo jobInfo = jobInfoArray[n];
            TaskInfo taskInfo = jobInfo.getTaskInfo();
            if (taskInfo != null) {
                string = taskInfo.getTaskName();
                object = null;
                Object[] objectArray = jobInfo.getChildren();
                if (objectArray.length > 0) {
                    object = ((JobTreeElement)objectArray[0]).getDisplayString();
                }
                if (object != null) {
                    string = string == null || string.length() == 0 ? object : NLS.bind((String)ProgressMessages.JobInfo_DoneNoProgressMessage, (Object)string, (Object)object);
                }
                if (string != null) {
                    this.setLinkText(jobInfoArray[n].getJob(), string, n);
                }
            } else {
                string = jobInfo.getJob();
                object = string.getResult();
                if (object == null || object.getMessage().length() == 0 && !this.info.isJobInfo()) {
                    this.setLinkText((Job)string, this.getJobNameAndStatus(jobInfo), n);
                } else {
                    this.setLinkText((Job)string, object.getMessage(), n);
                }
            }
            this.setColor(this.currentIndex);
            ++n;
        }
        if (jobInfoArray.length < this.taskEntries.size()) {
            n = jobInfoArray.length;
            while (n < this.taskEntries.size()) {
                ((Link)this.taskEntries.get(n)).dispose();
                ++n;
            }
            if (jobInfoArray.length > 1) {
                this.taskEntries = this.taskEntries.subList(0, jobInfoArray.length - 1);
            } else {
                this.taskEntries.clear();
            }
        }
        this.updateToolBarValues();
        this.setMainText();
        if (progressBar != this.progressBar) {
            this.getParent().layout(new Control[]{this});
        }
    }

    private boolean isCompleted() {
        JobInfo[] jobInfoArray = this.getJobInfos();
        int n = 0;
        while (n < jobInfoArray.length) {
            if (jobInfoArray[n].getJob().getState() != 0) {
                return false;
            }
            ++n;
        }
        return jobInfoArray.length > 0;
    }

    public JobInfo[] getJobInfos() {
        if (this.info.isJobInfo()) {
            return new JobInfo[]{(JobInfo)this.info};
        }
        Object[] objectArray = this.info.getChildren();
        JobInfo[] jobInfoArray = new JobInfo[objectArray.length];
        System.arraycopy(objectArray, 0, jobInfoArray, 0, objectArray.length);
        return jobInfoArray;
    }

    private boolean isRunning() {
        JobInfo[] jobInfoArray = this.getJobInfos();
        int n = 0;
        while (n < jobInfoArray.length) {
            int n2 = jobInfoArray[n].getJob().getState();
            if (n2 == 2 || n2 == 4) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private int getPercentDone() {
        if (this.info.isJobInfo()) {
            return ((JobInfo)this.info).getPercentDone();
        }
        if (this.info.hasChildren()) {
            TaskInfo taskInfo;
            Object[] objectArray = ((GroupInfo)this.info).getChildren();
            if (objectArray.length == 1 && objectArray[0] instanceof JobTreeElement && (taskInfo = ((JobInfo)objectArray[0]).getTaskInfo()) != null) {
                return taskInfo.getPercentDone();
            }
            return ((GroupInfo)this.info).getPercentDone();
        }
        return 0;
    }

    private void updateToolBarValues() {
        if (this.isCompleted()) {
            this.actionButton.setImage(JFaceResources.getImage((String)CLEAR_FINISHED_JOB_KEY));
            this.actionButton.setDisabledImage(JFaceResources.getImage((String)DISABLED_CLEAR_FINISHED_JOB_KEY));
            this.actionButton.setToolTipText(ProgressMessages.NewProgressView_ClearJobToolTip);
        } else {
            this.actionButton.setImage(JFaceResources.getImage((String)STOP_IMAGE_KEY));
            this.actionButton.setDisabledImage(JFaceResources.getImage((String)DISABLED_STOP_IMAGE_KEY));
        }
        JobInfo[] jobInfoArray = this.getJobInfos();
        int n = 0;
        while (n < jobInfoArray.length) {
            if (jobInfoArray[n].isCanceled() && !this.isCompleted()) {
                this.actionButton.setEnabled(false);
                return;
            }
            ++n;
        }
        this.actionButton.setEnabled(true);
    }

    void createProgressBar(int n) {
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.progressLabel, 0);
        formData.right = new FormAttachment(100, -4);
        this.actionBar.setLayoutData((Object)formData);
        this.progressBar = new ProgressBar((Composite)this, 0x100 | n);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment((Control)this.actionBar, 4, 128);
        formData2.left = new FormAttachment((Control)this.progressLabel, 0, 16384);
        formData2.right = new FormAttachment((Control)this.actionBar, -4);
        formData2.height = 12;
        formData2.width = 0;
        this.progressBar.setLayoutData((Object)formData2);
        if (this.taskEntries.size() > 0) {
            FormData formData3 = new FormData();
            formData3.top = new FormAttachment((Control)this.progressBar, 4);
            formData3.left = new FormAttachment((Control)this.progressBar, 0, 16384);
            formData3.right = new FormAttachment((Control)this.progressBar, 0, 131072);
            formData3.width = 21;
            ((Link)this.taskEntries.get(0)).setLayoutData((Object)formData3);
        }
    }

    void setLinkText(Job job, String string, int n) {
        Object object;
        Object object2;
        if (n >= this.taskEntries.size()) {
            this.link = new Link((Composite)this, 0);
            object2 = new FormData();
            if (n == 0 || this.taskEntries.size() == 0) {
                object = this.progressBar;
                if (object == null) {
                    object = this.progressLabel;
                }
                object2.top = new FormAttachment((Control)object, 4);
                object2.left = new FormAttachment((Control)object, 0, 16384);
                object2.right = new FormAttachment((Control)object, 0, 131072);
                object2.width = 21;
            } else {
                object = (Link)this.taskEntries.get(n - 1);
                object2.top = new FormAttachment((Control)object, 4);
                object2.left = new FormAttachment((Control)object, 0, 16384);
                object2.right = new FormAttachment((Control)object, 0, 131072);
                object2.width = 21;
            }
            this.link.setLayoutData(object2);
            this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ProgressInfoItem.this.executeTrigger();
                }
            });
            this.link.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    Object object = ProgressInfoItem.this.link.getData(ProgressInfoItem.TEXT_KEY);
                    if (object == null) {
                        return;
                    }
                    ProgressInfoItem.this.updateText((String)object, ProgressInfoItem.this.link);
                }
            });
            this.taskEntries.add(this.link);
        } else {
            this.link = (Link)this.taskEntries.get(n);
        }
        object2 = job.getProperty(IProgressConstants.ACTION_PROPERTY);
        object = job.getProperty(IProgressConstants2.COMMAND_PROPERTY);
        if (object2 != null && object != null) {
            this.updateTrigger(null, this.link);
        } else {
            Object object3 = object2 != null ? object2 : object;
            this.updateTrigger(object3, this.link);
        }
        if (this.link.getData(TRIGGER_KEY) == null && (string == null || string.equals(this.getMainTitle()))) {
            string = "";
        }
        this.link.setToolTipText(string);
        this.link.setData(TEXT_KEY, (Object)string);
        this.updateText(string, this.link);
    }

    public void executeTrigger() {
        Object object;
        Object object2 = this.link.getData(TRIGGER_KEY);
        if (object2 instanceof IAction) {
            object = (IAction)object2;
            if (object.isEnabled()) {
                object.run();
            }
            this.updateTrigger(object, this.link);
        } else if (object2 instanceof ParameterizedCommand) {
            object = PlatformUI.getWorkbench();
            IHandlerService iHandlerService = (IHandlerService)object.getService(IHandlerService.class);
            IStatus iStatus = Status.OK_STATUS;
            try {
                iHandlerService.executeCommand((ParameterizedCommand)object2, null);
            }
            catch (ExecutionException executionException) {
                iStatus = new Status(4, "org.eclipse.ui", executionException.getMessage(), (Throwable)executionException);
            }
            catch (NotDefinedException notDefinedException) {
                iStatus = new Status(4, "org.eclipse.ui", notDefinedException.getMessage(), (Throwable)notDefinedException);
            }
            catch (NotEnabledException notEnabledException) {
                iStatus = new Status(2, "org.eclipse.ui", notEnabledException.getMessage(), (Throwable)notEnabledException);
            }
            catch (NotHandledException notHandledException) {
                iStatus = new Status(4, "org.eclipse.ui", notHandledException.getMessage(), (Throwable)notHandledException);
            }
            if (!iStatus.isOK()) {
                StatusManager.getManager().handle(iStatus, 3);
            }
        }
        object = this.link.getData(TEXT_KEY);
        if (object == null) {
            return;
        }
        this.updateText((String)object, this.link);
    }

    private void updateTrigger(Object object, Link link) {
        if (object instanceof IAction && ((IAction)object).isEnabled()) {
            link.setData(TRIGGER_KEY, object);
        } else if (object instanceof ParameterizedCommand) {
            link.setData(TRIGGER_KEY, object);
        } else {
            link.setData(TRIGGER_KEY, null);
        }
    }

    private void updateText(String string, Link link) {
        string = Dialog.shortenText((String)string, (Control)link);
        link.setText(link.getData(TRIGGER_KEY) == null ? string : NLS.bind((String)"<a>{0}</a>", (Object)string));
    }

    public void setColor(int n) {
        this.currentIndex = n;
        if (this.selected) {
            this.setAllBackgrounds(this.getDisplay().getSystemColor(26));
            this.setAllForegrounds(this.getDisplay().getSystemColor(27));
            return;
        }
        if (n % 2 == 0) {
            this.setAllBackgrounds(JFaceResources.getColorRegistry().get(DARK_COLOR_KEY));
        } else {
            this.setAllBackgrounds(this.getDisplay().getSystemColor(25));
        }
        this.setAllForegrounds(this.getDisplay().getSystemColor(24));
    }

    private void setAllForegrounds(Color color) {
        this.setForeground(color);
        this.progressLabel.setForeground(color);
        Iterator iterator = this.taskEntries.iterator();
        while (iterator.hasNext()) {
            ((Link)iterator.next()).setForeground(color);
        }
    }

    private void setAllBackgrounds(Color color) {
        this.setBackground(color);
        this.progressLabel.setBackground(color);
        this.actionBar.setBackground(color);
        this.jobImageLabel.setBackground(color);
        Iterator iterator = this.taskEntries.iterator();
        while (iterator.hasNext()) {
            ((Link)iterator.next()).setBackground(color);
        }
    }

    void setButtonFocus() {
        this.actionBar.setFocus();
    }

    void selectWidgets(boolean bl) {
        if (bl) {
            this.setButtonFocus();
        }
        this.selected = bl;
        this.setColor(this.currentIndex);
    }

    void setIndexListener(IndexListener indexListener) {
        this.indexListener = indexListener;
    }

    boolean isSelected() {
        return this.selected;
    }

    void setDisplayed(int n, int n2) {
        int n3 = this.getLocation().y;
        int n4 = n3 + this.getBounds().height;
        this.setDisplayed(n3 <= n2 && n4 > n);
    }

    private void setDisplayed(boolean bl) {
        boolean bl2 = !this.isShowing && bl;
        this.isShowing = bl;
        if (bl2) {
            this.refresh();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
        }
    }

    public JobTreeElement getInfo() {
        return this.info;
    }

    static interface IndexListener {
        public void selectPrevious();

        public void selectNext();

        public void select();
    }
}

