/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.TrimUtil;
import org.eclipse.ui.internal.progress.AbstractProgressViewer;

public class ProgressCanvasViewer
extends AbstractProgressViewer {
    Canvas canvas;
    Object[] displayedItems = new Object[0];
    private static final List EMPTY_LIST = new ArrayList();
    private FontMetrics fontMetrics;
    private int numShowItems = 1;
    private int maxCharacterWidth;
    private int orientation = 256;

    ProgressCanvasViewer(Composite composite, int n, int n2, int n3, int n4) {
        this.orientation = n4;
        this.numShowItems = n2;
        this.maxCharacterWidth = n3;
        this.canvas = new Canvas(composite, n);
        this.hookControl((Control)this.canvas);
        GC gC = new GC((Drawable)this.canvas);
        gC.setFont(JFaceResources.getDefaultFont());
        this.fontMetrics = gC.getFontMetrics();
        gC.dispose();
        this.initializeListeners();
    }

    protected void hookControl(Control control) {
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ProgressCanvasViewer.this.handleDispose(disposeEvent);
            }
        });
    }

    protected Widget doFindInputItem(Object object) {
        return null;
    }

    protected Widget doFindItem(Object object) {
        return null;
    }

    protected void doUpdateItem(Widget widget, Object object, boolean bl) {
        this.canvas.redraw();
    }

    protected List getSelectionFromWidget() {
        return EMPTY_LIST;
    }

    protected void internalRefresh(Object object) {
        this.displayedItems = this.getSortedChildren(this.getRoot());
        this.canvas.redraw();
    }

    public void reveal(Object object) {
    }

    protected void setSelectionToWidget(List list, boolean bl) {
    }

    public Control getControl() {
        return this.canvas;
    }

    private void initializeListeners() {
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                GC gC = paintEvent.gc;
                Transform transform = null;
                if (ProgressCanvasViewer.this.orientation == 512) {
                    transform = new Transform((Device)paintEvent.display);
                    transform.translate((float)TrimUtil.TRIM_DEFAULT_HEIGHT, 0.0f);
                    transform.rotate(90.0f);
                }
                ILabelProvider iLabelProvider = (ILabelProvider)ProgressCanvasViewer.this.getLabelProvider();
                int n = Math.min(ProgressCanvasViewer.this.displayedItems.length, ProgressCanvasViewer.this.numShowItems);
                int n2 = 0;
                int n3 = 0;
                if (ProgressCanvasViewer.this.numShowItems == 1) {
                    int n4;
                    Rectangle rectangle = ProgressCanvasViewer.this.canvas.getParent().getClientArea();
                    if (ProgressCanvasViewer.this.orientation == 256) {
                        n4 = rectangle.height;
                        n2 = n4 - ProgressCanvasViewer.this.fontMetrics.getHeight();
                        n2 /= 2;
                    } else {
                        n4 = rectangle.width;
                        n3 = n4 - ProgressCanvasViewer.this.fontMetrics.getHeight();
                        n3 /= 2;
                    }
                }
                int n5 = 0;
                while (n5 < n) {
                    String string = iLabelProvider.getText(ProgressCanvasViewer.this.displayedItems[n5]);
                    if (string == null) {
                        string = "";
                    }
                    if (ProgressCanvasViewer.this.orientation == 256) {
                        gC.drawString(string, 2, n2 + n5 * ProgressCanvasViewer.this.fontMetrics.getHeight(), true);
                    } else {
                        gC.setTransform(transform);
                        gC.drawString(string, n3 + n5 * ProgressCanvasViewer.this.fontMetrics.getHeight(), 2, true);
                    }
                    ++n5;
                }
                if (transform != null) {
                    transform.dispose();
                }
            }
        });
    }

    public void setLabelProvider(IBaseLabelProvider iBaseLabelProvider) {
        Assert.isTrue((boolean)(iBaseLabelProvider instanceof ILabelProvider));
        super.setLabelProvider(iBaseLabelProvider);
    }

    public Point getSizeHints() {
        Display display = this.canvas.getDisplay();
        GC gC = new GC((Drawable)this.canvas);
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n = fontMetrics.getAverageCharWidth();
        int n2 = fontMetrics.getHeight();
        int n3 = display.getBounds().width / 2;
        int n4 = display.getBounds().height / 6;
        int n5 = n * this.maxCharacterWidth;
        int n6 = n2 * this.numShowItems;
        if (n3 < n5) {
            n5 = n3;
        }
        if (n4 < n6) {
            n6 = n4;
        }
        gC.dispose();
        return new Point(n5, n6);
    }

    @Override
    public void add(Object[] objectArray) {
        this.refresh(true);
    }

    @Override
    public void remove(Object[] objectArray) {
        this.refresh(true);
    }
}

