/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.progress.AnimationItem;
import org.eclipse.ui.internal.progress.AnimationManager;
import org.eclipse.ui.internal.progress.IAnimationProcessor;
import org.eclipse.ui.internal.progress.ProgressAnimationItem;

class ProgressAnimationProcessor
implements IAnimationProcessor {
    AnimationManager manager;
    List items = Collections.synchronizedList(new ArrayList());

    ProgressAnimationProcessor(AnimationManager animationManager) {
        this.manager = animationManager;
    }

    public void startAnimationLoop(IProgressMonitor iProgressMonitor) {
        if (this.items.size() == 0) {
            return;
        }
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        while (this.manager.isAnimated() && !iProgressMonitor.isCanceled()) {
        }
        ProgressAnimationItem[] progressAnimationItemArray = this.getAnimationItems();
        int n = 0;
        while (n < progressAnimationItemArray.length) {
            progressAnimationItemArray[n].animationDone();
            ++n;
        }
    }

    @Override
    public void addItem(AnimationItem animationItem) {
        Assert.isTrue((boolean)(animationItem instanceof ProgressAnimationItem));
        this.items.add(animationItem);
    }

    @Override
    public void removeItem(AnimationItem animationItem) {
        Assert.isTrue((boolean)(animationItem instanceof ProgressAnimationItem));
        this.items.remove(animationItem);
    }

    @Override
    public boolean hasItems() {
        return this.items.size() > 0;
    }

    public void itemsInactiveRedraw() {
    }

    @Override
    public void animationStarted() {
        ProgressAnimationItem[] progressAnimationItemArray = this.getAnimationItems();
        int n = 0;
        while (n < progressAnimationItemArray.length) {
            ((AnimationItem)progressAnimationItemArray[n]).animationStart();
            ++n;
        }
    }

    @Override
    public int getPreferredWidth() {
        return 30;
    }

    private ProgressAnimationItem[] getAnimationItems() {
        ProgressAnimationItem[] progressAnimationItemArray = new ProgressAnimationItem[this.items.size()];
        this.items.toArray(progressAnimationItemArray);
        return progressAnimationItemArray;
    }

    @Override
    public void animationFinished() {
        ProgressAnimationItem[] progressAnimationItemArray = this.getAnimationItems();
        int n = 0;
        while (n < progressAnimationItemArray.length) {
            ((AnimationItem)progressAnimationItemArray[n]).animationDone();
            ++n;
        }
    }

    @Override
    public boolean isProcessorJob(Job job) {
        return false;
    }
}

